/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.data;

import docking.DialogComponentProvider;
import docking.widgets.combobox.GComboBox;
import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.dialogs.StringChoices;
import docking.widgets.table.AbstractSortedTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.textfield.IntegerTextField;
import ghidra.docking.settings.BooleanSettingsDefinition;
import ghidra.docking.settings.EnumSettingsDefinition;
import ghidra.docking.settings.NumberSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.docking.settings.SettingsImpl;
import ghidra.docking.settings.StringSettingsDefinition;
import ghidra.framework.preferences.Preferences;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.GhidraTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public abstract class AbstractSettingsDialog
extends DialogComponentProvider {
    private static final int WIDTH = 400;
    private static final int HEIGHT = 150;
    private static String[] BOOLEAN_CHOICES = new String[]{"yes", "no"};
    private static String NO_CHOICE = "";
    private SettingsDefinition[] settingsDefinitions;
    private Settings defaultSettings;
    private SettingsImpl settings;
    private SettingsTableModel settingsTableModel;
    private SettingsTable settingsTable;
    private Map<String, Boolean> intHexModeMap;
    private boolean appliedSettings;

    protected AbstractSettingsDialog(String title, SettingsDefinition[] settingDefinitions, final Settings originalSettings) {
        super(title, true, false, true, false);
        this.settingsDefinitions = settingDefinitions;
        this.settings = new SettingsImpl(originalSettings){

            public boolean isChangeAllowed(SettingsDefinition settingsDefinition) {
                return originalSettings == null || originalSettings.isChangeAllowed(settingsDefinition);
            }
        };
        this.defaultSettings = this.settings.getDefaultSettings();
        if (originalSettings != null && this.defaultSettings == null) {
            this.defaultSettings = new SettingsImpl();
            this.settings.setDefaultSettings(this.defaultSettings);
        }
        this.buildPanel();
    }

    protected SettingsDefinition[] getSettingsDefinitions() {
        return this.settingsDefinitions;
    }

    protected Settings getSettings() {
        return this.settings;
    }

    protected Settings getDefaultSettings() {
        return this.defaultSettings;
    }

    GTable getSettingsTable() {
        return this.settingsTable;
    }

    SettingsTableModel getSettingsTableModel() {
        return this.settingsTableModel;
    }

    public void dispose() {
        super.dispose();
        this.settingsDefinitions = null;
        this.defaultSettings = null;
        this.settings = null;
    }

    boolean hasSettings() {
        return this.settingsDefinitions.length != 0;
    }

    private void buildPanel() {
        this.addWorkPanel(this.buildWorkPanel());
        this.addButtons();
    }

    private void addButtons() {
        this.addOKButton();
        JButton newApplyButton = new JButton("Apply");
        newApplyButton.addActionListener(e -> this.apply());
        this.addButton(newApplyButton);
        this.addCancelButton();
    }

    private String getHexModePropertyName(SettingsDefinition settingsDef) {
        return settingsDef.getClass().getSimpleName() + ".hexMode";
    }

    private void readHexModePreferences() {
        this.intHexModeMap = new HashMap<String, Boolean>();
        for (SettingsDefinition settingsDefinition : this.settingsDefinitions) {
            if (!(settingsDefinition instanceof NumberSettingsDefinition)) continue;
            String propertyName = this.getHexModePropertyName(settingsDefinition);
            boolean hexMode = Boolean.valueOf(Preferences.getProperty((String)propertyName, (String)Boolean.FALSE.toString()));
            this.intHexModeMap.put(settingsDefinition.getName(), hexMode);
        }
    }

    private void writeHexModePreferences() {
        boolean save = false;
        for (SettingsDefinition settingsDefinition : this.settingsDefinitions) {
            String propertyName;
            boolean hexMode;
            if (!(settingsDefinition instanceof NumberSettingsDefinition) || (hexMode = this.intHexModeMap.get(settingsDefinition.getName()).booleanValue()) == Boolean.valueOf(Preferences.getProperty((String)(propertyName = this.getHexModePropertyName(settingsDefinition)), (String)Boolean.FALSE.toString()))) continue;
            Preferences.setProperty((String)propertyName, (String)Boolean.toString(hexMode));
            save = true;
        }
        if (save) {
            Preferences.store();
        }
    }

    private boolean isHexModeEnabled(SettingsDefinition settingsDef) {
        return this.intHexModeMap.get(settingsDef.getName());
    }

    private JPanel buildWorkPanel() {
        JPanel workPanel = new JPanel(new BorderLayout());
        workPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.readHexModePreferences();
        this.settingsTableModel = new SettingsTableModel(this.settingsDefinitions);
        this.settingsTableModel.addTableModelListener(e -> {
            this.appliedSettings = false;
        });
        this.settingsTable = new SettingsTable(this.settingsTableModel);
        this.settingsTable.setAutoscrolls(true);
        this.settingsTable.setRowSelectionAllowed(false);
        this.settingsTable.setColumnSelectionAllowed(false);
        this.settingsTable.setRowHeight(22);
        this.settingsTable.getTableHeader().setReorderingAllowed(false);
        this.settingsTable.setColumnHeaderPopupEnabled(false);
        this.settingsTable.setUserSortingEnabled(false);
        this.settingsTable.setDefaultRenderer(Settings.class, (TableCellRenderer)((Object)new SettingsRenderer()));
        this.settingsTable.setDefaultEditor(Settings.class, new SettingsEditor());
        JScrollPane scrollpane = new JScrollPane((Component)((Object)this.settingsTable));
        scrollpane.setPreferredSize(new Dimension(400, 150));
        workPanel.add((Component)scrollpane, "Center");
        boolean hasImmutableSettings = false;
        for (SettingsDefinition def : this.settingsDefinitions) {
            if (this.settings.isChangeAllowed(def)) continue;
            hasImmutableSettings = true;
            break;
        }
        if (hasImmutableSettings) {
            workPanel.add((Component)new JLabel("* Immutable setting"), "South");
        }
        return workPanel;
    }

    protected void cancelCallback() {
        this.settingsTable.editingStopped(null);
        this.close();
        this.dispose();
    }

    protected void okCallback() {
        this.settingsTable.editingStopped(null);
        this.apply();
        this.close();
        this.dispose();
    }

    private void apply() {
        this.settingsTable.editingStopped(null);
        try {
            this.applySettings();
        }
        catch (CancelledException e) {
            return;
        }
        this.writeHexModePreferences();
        this.appliedSettings = true;
    }

    protected abstract String[] getSuggestedValues(StringSettingsDefinition var1);

    protected abstract void applySettings() throws CancelledException;

    protected boolean isSettingsApplied() {
        return this.appliedSettings;
    }

    protected StringChoices getChoices(EnumSettingsDefinition def) {
        String[] choices = def.getDisplayChoices((Settings)this.settings);
        int currentChoice = def.getChoice((Settings)this.settings);
        if (this.defaultSettings == null) {
            choices = this.addNoChoice(choices);
            currentChoice = !def.hasValue((Settings)this.settings) ? 0 : ++currentChoice;
        }
        StringChoices choicesEnum = new StringChoices(choices);
        choicesEnum.setSelectedValue(currentChoice);
        return choicesEnum;
    }

    protected StringChoices getChoices(BooleanSettingsDefinition def) {
        int currentChoice;
        String[] choices = BOOLEAN_CHOICES;
        int n = currentChoice = def.getValue((Settings)this.settings) ? 0 : 1;
        if (this.defaultSettings == null) {
            choices = this.addNoChoice(choices);
            currentChoice = !def.hasValue((Settings)this.settings) ? 0 : ++currentChoice;
        }
        StringChoices choicesEnum = new StringChoices(choices);
        choicesEnum.setSelectedValue(currentChoice);
        return choicesEnum;
    }

    protected void setChoice(Object value, EnumSettingsDefinition def) {
        StringChoices choices = (StringChoices)value;
        int selectedChoice = choices.getSelectedValueIndex();
        if (this.defaultSettings == null) {
            if (selectedChoice == 0) {
                this.settings.clearSetting(def.getName());
                return;
            }
            --selectedChoice;
        }
        def.setChoice((Settings)this.settings, selectedChoice);
    }

    protected void setChoice(Object value, BooleanSettingsDefinition def) {
        StringChoices choices = (StringChoices)value;
        int selectedChoice = choices.getSelectedValueIndex();
        if (this.defaultSettings == null) {
            if (selectedChoice == 0) {
                this.settings.clearSetting(def.getName());
                return;
            }
            --selectedChoice;
        }
        def.setValue((Settings)this.settings, selectedChoice == 0);
    }

    protected void setValue(Number value, NumberSettingsDefinition def) {
        if (value == null) {
            def.clear((Settings)this.settings);
        } else {
            def.setValue((Settings)this.settings, value.longValue());
        }
    }

    protected void setValue(String value, StringSettingsDefinition def) {
        if (value == null) {
            def.clear((Settings)this.settings);
        } else {
            def.setValue((Settings)this.settings, value);
        }
    }

    private String[] addNoChoice(String[] choices) {
        String[] newChoices = new String[choices.length + 1];
        newChoices[0] = NO_CHOICE;
        System.arraycopy(choices, 0, newChoices, 1, choices.length);
        return newChoices;
    }

    private String getIntegerString(Number num, NumberSettingsDefinition settingsDef) {
        boolean decimalMode;
        long value = num.longValue();
        boolean bl = decimalMode = !settingsDef.isHexModePreferred() && !this.isHexModeEnabled((SettingsDefinition)settingsDef);
        if (!settingsDef.allowNegativeValue()) {
            byte[] bytes = BigEndianDataConverter.INSTANCE.getBytes(value);
            BigInteger unsignedValue = new BigInteger(1, bytes);
            if (decimalMode) {
                return unsignedValue.toString();
            }
            return "0x" + unsignedValue.toString(16);
        }
        if (decimalMode) {
            return Long.toString(value);
        }
        BigInteger signedValue = BigInteger.valueOf(value);
        String sign = "";
        if (signedValue.signum() < 0) {
            sign = "-";
            signedValue = signedValue.negate();
        }
        return sign + "0x" + signedValue.toString(16);
    }

    class SettingsTable
    extends GhidraTable {
        public SettingsTable(SettingsTableModel settingsTableModel) {
            super((TableModel)((Object)settingsTableModel));
        }

        public String getToolTipText(MouseEvent evt) {
            int col = this.columnAtPoint(evt.getPoint());
            if (col != 0) {
                return super.getToolTipText();
            }
            int row = this.rowAtPoint(evt.getPoint());
            SettingsRowObject rowObject = (SettingsRowObject)AbstractSettingsDialog.this.settingsTableModel.getRowObject(row);
            String description = rowObject.definition.getDescription();
            if (!description.isEmpty()) {
                return "<html>" + HTMLUtilities.escapeHTML((String)description) + "</html>";
            }
            return null;
        }
    }

    private class SettingsTableModel
    extends AbstractSortedTableModel<SettingsRowObject> {
        private List<SettingsRowObject> rows = new ArrayList<SettingsRowObject>();

        SettingsTableModel(SettingsDefinition[] settingsDefs) {
            for (SettingsDefinition sd : settingsDefs) {
                this.rows.add(new SettingsRowObject(sd));
            }
        }

        public List<SettingsRowObject> getModelData() {
            return this.rows;
        }

        public String getName() {
            return "Settings Definition Model";
        }

        public boolean isSortable(int columnIndex) {
            return columnIndex == 0;
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            SettingsRowObject rowObject = this.rows.get(row);
            return rowObject.isEditable();
        }

        public int getColumnCount() {
            return AbstractSettingsDialog.this.defaultSettings != null ? 3 : 2;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Name";
                }
                case 1: {
                    return "Settings";
                }
                case 2: {
                    return "Use Default";
                }
            }
            return null;
        }

        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Settings.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return null;
        }

        public Object getColumnValueForRow(SettingsRowObject t, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Object name = t.getName();
                    if (!t.isEditable()) {
                        name = (String)name + "*";
                    }
                    return name;
                }
                case 1: {
                    return t.getSettingsObject();
                }
                case 2: {
                    return t.useDefault();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (AbstractSettingsDialog.this.settings == null) {
                return;
            }
            SettingsRowObject rowObject = this.rows.get(row);
            switch (col) {
                case 1: {
                    if (!rowObject.setSettingsChoice(value)) break;
                    this.fireTableDataChanged();
                    break;
                }
                case 2: {
                    if (!((Boolean)value).booleanValue()) break;
                    rowObject.clear(AbstractSettingsDialog.this.settings);
                    this.fireTableDataChanged();
                }
            }
        }
    }

    private class SettingsRenderer
    extends GTableCellRenderer {
        private Font originalFont;

        private SettingsRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData tableData) {
            String str;
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(tableData);
            renderer.setAlignmentX(0.0f);
            if (this.originalFont != null) {
                renderer.setFont(this.originalFont);
            } else {
                this.originalFont = renderer.getFont();
            }
            Object value = tableData.getValue();
            if (value instanceof NumberWrapper) {
                Number n = ((NumberWrapper)value).value;
                if (n != null) {
                    SettingsRowObject rowObject = (SettingsRowObject)tableData.getRowObject();
                    String valString = AbstractSettingsDialog.this.getIntegerString(n, (NumberSettingsDefinition)rowObject.definition);
                    renderer.setText(valString);
                }
            } else if (value instanceof StringWrapper && (str = ((StringWrapper)value).value) == null) {
                renderer.setText("--default--");
                renderer.setFont(this.originalFont.deriveFont(2));
            }
            return renderer;
        }
    }

    class SettingsEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        static final int ENUM = 0;
        static final int BOOLEAN = 1;
        static final int NUMBER = 2;
        static final int STRING = 3;
        static final int STRING_WITH_SUGGESTIONS = 4;
        private int mode;
        private GhidraComboBox<String> comboBox = new GhidraComboBox();
        private IntegerTextField intTextField = new IntegerTextField();
        private JTextField textField = new JTextField();
        private SettingsRowObject rowobject;

        SettingsEditor() {
            this.comboBox.setEnterKeyForwarding(false);
            this.comboBox.addActionListener(e -> this.fireEditingStopped());
            this.intTextField.addChangeListener(e -> this.updateHexMode());
        }

        GhidraComboBox<String> getComboBox() {
            return this.comboBox;
        }

        @Override
        public Object getCellEditorValue() {
            switch (this.mode) {
                case 0: {
                    return this.getComboBoxEnum();
                }
                case 1: {
                    return this.getComboBoxEnum();
                }
                case 2: {
                    return this.getNumber();
                }
                case 3: 
                case 4: {
                    return this.getString();
                }
            }
            throw new AssertException();
        }

        private StringChoices getComboBoxEnum() {
            String[] items = new String[this.comboBox.getItemCount()];
            for (int i = 0; i < items.length; ++i) {
                items[i] = (String)this.comboBox.getItemAt(i);
            }
            StringChoices enuum = new StringChoices(items);
            enuum.setSelectedValue(this.comboBox.getSelectedIndex());
            return enuum;
        }

        private void updateHexMode() {
            AbstractSettingsDialog.this.intHexModeMap.put(this.rowobject.definition.getName(), this.intTextField.isHexMode());
        }

        private Number getNumber() {
            BigInteger currentValue = this.intTextField.getValue();
            if (currentValue == null) {
                return null;
            }
            return currentValue.longValue();
        }

        private String getString() {
            if (this.mode == 4) {
                return this.comboBox.getEditor().getItem().toString();
            }
            String value = this.textField.getText().trim();
            return value.length() == 0 ? null : value;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.rowobject = (SettingsRowObject)AbstractSettingsDialog.this.settingsTableModel.getRowObject(row);
            if (value instanceof StringChoices || value instanceof Boolean) {
                this.initComboBox((StringChoices)value);
                return this.comboBox;
            }
            if (value instanceof NumberWrapper) {
                this.initIntField(((NumberWrapper)value).value);
                return this.intTextField.getComponent();
            }
            if (value instanceof StringWrapper) {
                StringWrapper strWrapper = (StringWrapper)value;
                StringChoices strWithChoices = strWrapper.getStringChoices();
                if (strWithChoices == null) {
                    this.initTextField(strWrapper.value);
                    return this.textField;
                }
                this.initEditableComboBox(strWithChoices, strWrapper.value);
                return this.comboBox;
            }
            throw new AssertException("SettingsEditor: " + value.getClass().getName() + " not supported");
        }

        private void initComboBox(StringChoices enuum) {
            String[] items;
            this.mode = 0;
            this.comboBox.removeAllItems();
            this.comboBox.setEditable(false);
            for (String item : items = enuum.getValues()) {
                this.comboBox.addItem((Object)item);
            }
            this.comboBox.setSelectedIndex(enuum.getSelectedValueIndex());
        }

        private void initEditableComboBox(StringChoices strChoices, String value) {
            String[] items;
            this.mode = 4;
            this.comboBox.removeAllItems();
            this.comboBox.setEditable(true);
            for (String item : items = strChoices.getValues()) {
                this.comboBox.addItem((Object)item);
            }
            this.comboBox.getEditor().setItem(value);
        }

        private void initIntField(Number value) {
            this.mode = 2;
            NumberSettingsDefinition def = (NumberSettingsDefinition)this.rowobject.definition;
            if (def.isHexModePreferred() || AbstractSettingsDialog.this.isHexModeEnabled((SettingsDefinition)def)) {
                this.intTextField.setHexMode();
            } else {
                this.intTextField.setDecimalMode();
            }
            this.intTextField.setMaxValue(def.getMaxValue());
            this.intTextField.setAllowNegativeValues(def.allowNegativeValue());
            if (value == null) {
                this.intTextField.setValue(null);
            } else if (def.allowNegativeValue()) {
                this.intTextField.setValue(value.longValue());
            } else {
                byte[] bytes = BigEndianDataConverter.INSTANCE.getBytes(value.longValue());
                this.intTextField.setValue(new BigInteger(1, bytes));
            }
        }

        private void initTextField(String str) {
            this.mode = 3;
            this.textField.setText(str);
        }
    }

    class StringSettingsComboBox
    extends GComboBox<String> {
        StringSettingsComboBox() {
        }
    }

    private class StringWrapper {
        final StringSettingsDefinition settingsDefinition;
        final String value;

        StringWrapper(StringSettingsDefinition settingsDefinition, String value) {
            this.value = value;
            this.settingsDefinition = settingsDefinition;
        }

        public String toString() {
            return this.value == null ? "" : this.value;
        }

        StringChoices getStringChoices() {
            String[] suggestedValues = AbstractSettingsDialog.this.getSuggestedValues(this.settingsDefinition);
            if (suggestedValues == null) {
                return null;
            }
            return suggestedValues.length == 0 ? null : new StringChoices(suggestedValues);
        }
    }

    private class NumberWrapper {
        final Number value;

        NumberWrapper(AbstractSettingsDialog abstractSettingsDialog, Number value) {
            this.value = value;
        }

        public String toString() {
            return this.value == null ? "" : Long.toString(this.value.longValue());
        }
    }

    class SettingsRowObject {
        private SettingsDefinition definition;

        SettingsRowObject(SettingsDefinition definition) {
            this.definition = definition;
        }

        public String getName() {
            return this.definition.getName();
        }

        boolean isEditable() {
            return AbstractSettingsDialog.this.settings.isChangeAllowed(this.definition);
        }

        Object getSettingsObject() {
            if (this.definition instanceof EnumSettingsDefinition) {
                StringChoices choices = AbstractSettingsDialog.this.getChoices((EnumSettingsDefinition)this.definition);
                return choices;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                StringChoices choices = AbstractSettingsDialog.this.getChoices((BooleanSettingsDefinition)this.definition);
                return choices;
            }
            if (this.definition instanceof NumberSettingsDefinition) {
                NumberSettingsDefinition def = (NumberSettingsDefinition)this.definition;
                if (AbstractSettingsDialog.this.defaultSettings == null && !def.hasValue((Settings)AbstractSettingsDialog.this.settings)) {
                    return new NumberWrapper(AbstractSettingsDialog.this, null);
                }
                return new NumberWrapper(AbstractSettingsDialog.this, def.getValue((Settings)AbstractSettingsDialog.this.settings));
            }
            if (this.definition instanceof StringSettingsDefinition) {
                StringSettingsDefinition def = (StringSettingsDefinition)this.definition;
                if (AbstractSettingsDialog.this.defaultSettings == null && !def.hasValue((Settings)AbstractSettingsDialog.this.settings)) {
                    return new StringWrapper(def, null);
                }
                return new StringWrapper(def, def.getValue((Settings)AbstractSettingsDialog.this.settings));
            }
            return "<Unsupported>";
        }

        boolean useDefault() {
            if (this.definition instanceof EnumSettingsDefinition) {
                EnumSettingsDefinition def = (EnumSettingsDefinition)this.definition;
                return def.getChoice((Settings)AbstractSettingsDialog.this.settings) == def.getChoice(AbstractSettingsDialog.this.defaultSettings);
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                BooleanSettingsDefinition def = (BooleanSettingsDefinition)this.definition;
                return def.getValue((Settings)AbstractSettingsDialog.this.settings) == def.getValue(AbstractSettingsDialog.this.defaultSettings);
            }
            if (this.definition instanceof NumberSettingsDefinition) {
                NumberSettingsDefinition def = (NumberSettingsDefinition)this.definition;
                return def.getValue((Settings)AbstractSettingsDialog.this.settings) == def.getValue(AbstractSettingsDialog.this.defaultSettings);
            }
            if (this.definition instanceof StringSettingsDefinition) {
                StringSettingsDefinition def = (StringSettingsDefinition)this.definition;
                return def.getValue((Settings)AbstractSettingsDialog.this.settings) == def.getValue(AbstractSettingsDialog.this.defaultSettings);
            }
            return false;
        }

        boolean setSettingsChoice(Object value) {
            if (this.definition instanceof EnumSettingsDefinition) {
                AbstractSettingsDialog.this.setChoice(value, (EnumSettingsDefinition)this.definition);
                return true;
            }
            if (this.definition instanceof BooleanSettingsDefinition) {
                AbstractSettingsDialog.this.setChoice(value, (BooleanSettingsDefinition)this.definition);
                return true;
            }
            if (this.definition instanceof NumberSettingsDefinition) {
                AbstractSettingsDialog.this.setValue((Number)value, (NumberSettingsDefinition)this.definition);
                return true;
            }
            if (this.definition instanceof StringSettingsDefinition) {
                AbstractSettingsDialog.this.setValue((String)value, (StringSettingsDefinition)this.definition);
                return true;
            }
            return false;
        }

        void clear(SettingsImpl s) {
            this.definition.clear((Settings)s);
        }
    }
}

