/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.DuplicateIdException;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.services.DataTypeArchiveService;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.listing.DataTypeArchive;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DefaultDataTypeArchiveService
implements DataTypeArchiveService {
    protected Map<UniversalID, DataTypeManagerInfo> openDTMs = new HashMap<UniversalID, DataTypeManagerInfo>();
    protected BuiltInDataTypeManager builtInDataTypesManager = BuiltInDataTypeManager.getDataTypeManager();

    public synchronized void dispose() {
        for (DataTypeManagerInfo dtmInfo : new ArrayList<DataTypeManagerInfo>(this.openDTMs.values())) {
            this.closeDTM(dtmInfo);
        }
    }

    @Override
    public DataTypeManager getBuiltInDataTypesManager() {
        return this.builtInDataTypesManager;
    }

    @Override
    public DataTypeManager[] getDataTypeManagers() {
        List dtmList = this.openDTMs.values().stream().filter(dtmInfo -> !dtmInfo.isClosed()).map(dtmInfo -> dtmInfo.dtm()).collect(Collectors.toList());
        return (DataTypeManager[])dtmList.toArray(DataTypeManager[]::new);
    }

    @Override
    public synchronized void closeArchive(DataTypeManager dtm) {
        if (dtm instanceof BuiltInDataTypeManager) {
            Msg.info((Object)this, (Object)"Cannot close the built-in Data Type Manager");
            return;
        }
        if (dtm instanceof ProgramDataTypeManager) {
            Msg.info((Object)this, (Object)"Cannot close the Program's Data Type Manager");
            return;
        }
        DataTypeManagerInfo dtmInfo = this.openDTMs.get(dtm.getUniversalID());
        if (dtmInfo == null) {
            Msg.info((Object)this, (Object)"Unable close archive; archive not open: '%s'".formatted(dtm.getName()));
            return;
        }
        this.beforeCloseDataTypeManager(dtmInfo);
        this.openDTMs.remove(dtm.getUniversalID());
        if (dtmInfo.domainObject != null) {
            dtmInfo.domainObject.release((Object)this);
        }
        dtmInfo.dtm.close();
        this.afterCloseDataTypeManager(dtmInfo);
    }

    @Override
    public Archive openArchive(DataTypeArchive dataTypeArchive) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Archive openArchive(File file, boolean acquireWriteLock) throws IOException, DuplicateIdException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataTypeManager openDataTypeArchive(String archiveName) throws IOException, DuplicateIdException {
        ResourceFile file = DataTypeArchiveUtility.findArchiveFile(archiveName);
        if (file != null) {
            return this.openArchive(file, false);
        }
        return null;
    }

    @Override
    public synchronized DataTypeManager openArchive(DomainFile domainFile, TaskMonitor monitor) throws VersionException, CancelledException, IOException, DuplicateIdException {
        if (!DataTypeArchive.class.isAssignableFrom(domainFile.getDomainObjectClass())) {
            throw new IOException("Unable to open domain file: '%s', not a data type archive".formatted(domainFile.getName()));
        }
        DataTypeManagerInfo dtmInfo = this.getOpenDTMInfo(domainFile);
        if (dtmInfo == null) {
            DataTypeArchive dta = this.openDomainFile(domainFile, monitor);
            DataTypeManager dtm = dta.getDataTypeManager();
            dtmInfo = this.addDTM(new DataTypeManagerInfo(null, (DomainObject)dta, domainFile.getPathname(), dtm));
        }
        return dtmInfo.dtm;
    }

    protected DataTypeArchive openDomainFile(DomainFile domainFile, TaskMonitor monitor) throws VersionException, CancelledException, IOException {
        DataTypeArchive dta = (DataTypeArchive)domainFile.getDomainObject((Object)this, false, false, monitor);
        return dta;
    }

    @Override
    public synchronized DataTypeManager openArchive(ResourceFile file, boolean acquireWriteLock) throws IOException, DuplicateIdException {
        DataTypeManagerInfo dtmInfo = this.getOpenDTMInfo(file = file.getCanonicalFile());
        if (dtmInfo == null) {
            FileDataTypeManager fileDTM = FileDataTypeManager.openFileArchive((ResourceFile)file, (boolean)acquireWriteLock);
            dtmInfo = this.addDTM(new DataTypeManagerInfo(file, null, file.getName(), (DataTypeManager)fileDTM));
        }
        return dtmInfo.dtm;
    }

    protected DataTypeManagerInfo addDTM(DataTypeManagerInfo dtmInfo) throws DuplicateIdException {
        DataTypeManagerInfo existingDTM = this.openDTMs.get(dtmInfo.dtm.getUniversalID());
        if (existingDTM != null) {
            if (existingDTM.isClosed()) {
                this.openDTMs.remove(dtmInfo.dtm.getUniversalID());
            } else {
                dtmInfo.dtm.close();
                throw new DuplicateIdException(dtmInfo.name(), existingDTM.name());
            }
        }
        this.openDTMs.put(dtmInfo.dtm.getUniversalID(), dtmInfo);
        this.afterAddDataTypeManager(dtmInfo);
        return dtmInfo;
    }

    protected void closeDTM(DataTypeManagerInfo dtmInfo) {
        this.beforeCloseDataTypeManager(dtmInfo);
        this.openDTMs.remove(dtmInfo.dtm.getUniversalID());
        if (dtmInfo.domainObject != null) {
            dtmInfo.domainObject.release((Object)this);
        }
        dtmInfo.dtm.close();
        this.afterCloseDataTypeManager(dtmInfo);
    }

    private DataTypeManagerInfo getOpenDTMInfo(ResourceFile file) {
        for (DataTypeManagerInfo dtmInfo : this.openDTMs.values()) {
            if (dtmInfo.file == null || !dtmInfo.file.equals((Object)file)) continue;
            if (dtmInfo.isClosed()) {
                this.openDTMs.remove(dtmInfo.dtm.getUniversalID());
                return null;
            }
            return dtmInfo;
        }
        return null;
    }

    private DataTypeManagerInfo getOpenDTMInfo(DomainFile projectFile) {
        for (DataTypeManagerInfo dtmInfo : this.openDTMs.values()) {
            if (dtmInfo.domainObject == null || !dtmInfo.domainObject.getDomainFile().equals((Object)projectFile)) continue;
            if (dtmInfo.isClosed()) {
                this.openDTMs.remove(dtmInfo.dtm.getUniversalID());
                return null;
            }
            return dtmInfo;
        }
        return null;
    }

    protected void afterAddDataTypeManager(DataTypeManagerInfo dtmInfo) {
    }

    protected void afterCloseDataTypeManager(DataTypeManagerInfo dtmInfo) {
    }

    protected void beforeCloseDataTypeManager(DataTypeManagerInfo dtmInfo) {
    }

    protected record DataTypeManagerInfo(ResourceFile file, DomainObject domainObject, String name, DataTypeManager dtm) {
        public boolean isClosed() {
            boolean bl;
            DataTypeManager dataTypeManager = this.dtm;
            if (dataTypeManager instanceof FileDataTypeManager) {
                FileDataTypeManager fdtm = (FileDataTypeManager)dataTypeManager;
                bl = fdtm.isClosed();
            } else {
                bl = false;
            }
            return bl;
        }
    }
}

