/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.editor;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.DataType;
import java.awt.Component;
import javax.swing.CellEditor;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class DataTypesTreeCellEditor
extends DefaultTreeCellEditor {
    private final DataTypeManagerPlugin plugin;
    private GTreeNode lastEditedNode;

    public DataTypesTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, DataTypeManagerPlugin plugin) {
        super(tree, renderer);
        this.plugin = plugin;
        this.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingCanceled(ChangeEvent e) {
                DataTypesTreeCellEditor.this.lastEditedNode = null;
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                if (DataTypesTreeCellEditor.this.lastEditedNode != null) {
                    DataTypesTreeCellEditor.this.handleEditingFinished((CellEditor)e.getSource());
                }
            }
        });
    }

    private void handleEditingFinished(final CellEditor cellEditor) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object cellEditorValue = cellEditor.getCellEditorValue();
                if (cellEditorValue == null || !(cellEditorValue instanceof String)) {
                    return;
                }
                GTreeNode newNode = DataTypesTreeCellEditor.this.lastEditedNode.getChild(cellEditorValue.toString());
                if (newNode == null) {
                    return;
                }
                TreePath path = newNode.getTreePath();
                DataTypesTreeCellEditor.this.tree.setSelectionPath(path);
                DataTypesTreeCellEditor.this.tree.scrollPathToVisible(path);
                DataTypesTreeCellEditor.this.lastEditedNode = null;
            }
        });
    }

    @Override
    public Component getTreeCellEditorComponent(final JTree jTree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.isCustom(value)) {
            this.edit(value);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    jTree.cancelEditing();
                }
            });
            return this.renderer.getTreeCellRendererComponent(jTree, value, isSelected, expanded, leaf, row, true);
        }
        this.lastEditedNode = ((GTreeNode)value).getParent();
        return super.getTreeCellEditorComponent(jTree, value, isSelected, expanded, leaf, row);
    }

    private void edit(Object value) {
        DataTypeNode dataTypeNode = (DataTypeNode)((Object)value);
        if (dataTypeNode.isModifiable()) {
            DataType dt = dataTypeNode.getDataType();
            this.plugin.getEditorManager().edit(dt);
        }
    }

    private boolean isCustom(Object value) {
        if (!(value instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode node = (DataTypeNode)((Object)value);
        return node.hasCustomEditor();
    }
}

