/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.ToolTipUtils;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeNameComparator;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;

public class DataTypeNode
extends DataTypeTreeNode {
    private final DataType dataType;
    private final String name;
    private String displayText;
    private boolean isCut;
    private boolean useHighlight = false;
    private String toolTipText;
    private long toolTipTimestamp;

    public DataTypeNode(DataType dataType) {
        this.dataType = dataType;
        this.name = dataType.getName();
        this.displayText = this.getCurrentDisplayText();
    }

    public int compareTo(GTreeNode node) {
        if (node instanceof DataTypeNode) {
            DataTypeNode other = (DataTypeNode)node;
            return DataTypeNameComparator.INSTANCE.compare(this.dataType.getName(), other.dataType.getName());
        }
        return 1;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DataTypeNode otherNode = (DataTypeNode)((Object)o);
        CategoryPath otherPath = otherNode.getDataType().getCategoryPath();
        CategoryPath path = this.dataType.getCategoryPath();
        if (!path.equals((Object)otherPath)) {
            return false;
        }
        return this.name.equals(otherNode.name);
    }

    public Icon getIcon(boolean expanded) {
        if (this.isFavorite()) {
            return DataTypeUtils.getFavoriteIcon(this.isCut);
        }
        Icon icon = null;
        icon = this.dataType instanceof BuiltInDataType ? DataTypeUtils.getBuiltInIcon(this.isCut) : DataTypeUtils.getIconForDataType(this.dataType, this.isCut);
        if (!this.isCut && this.useHighlight) {
            return DataTypeUtils.getHighlightIcon(icon);
        }
        return icon;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        DataType baseType = DataTypeUtils.getBaseDataType(this.dataType);
        long lastChangeTime = baseType.getLastChangeTime();
        if (lastChangeTime > this.toolTipTimestamp) {
            this.toolTipText = null;
        }
        if (this.toolTipText == null) {
            this.toolTipText = ToolTipUtils.getToolTipText(this.dataType);
            this.toolTipTimestamp = lastChangeTime;
        }
        return this.toolTipText;
    }

    public boolean isLeaf() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueChanged(Object newValue) {
        if (this.dataType.getName().equals(newValue)) {
            return;
        }
        String newName = newValue.toString();
        if (StringUtils.isBlank((CharSequence)newName)) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Rename Failed", (Object)"Name cannot be empty.");
            return;
        }
        int transactionID = this.dataType.getDataTypeManager().startTransaction("Rename DataType");
        try {
            this.dataType.setName(newName);
        }
        catch (DuplicateNameException e) {
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Rename Failed", (Object)("Data Type by the name " + String.valueOf(newValue) + " already exists in this category."));
        }
        catch (InvalidNameException exc) {
            Object msg = exc.getMessage();
            if (msg == null) {
                msg = "Invalid name specified: " + String.valueOf(newValue);
            }
            Msg.showError(((Object)((Object)this)).getClass(), null, (String)"Invalid Name Specified", (Object)exc.getMessage());
        }
        finally {
            this.dataType.getDataTypeManager().endTransaction(transactionID, true);
        }
    }

    public boolean isEditable() {
        return this.isModifiable() && this.canRename();
    }

    public boolean hasCustomEditor() {
        return this.dataType instanceof Composite || this.dataType instanceof Enum || this.dataType instanceof FunctionDefinition || this.hasCustomEditorForBaseDataType();
    }

    private boolean hasCustomEditorForBaseDataType() {
        DataType baseDataType = DataTypeUtils.getBaseDataType(this.dataType);
        return baseDataType instanceof Composite || baseDataType instanceof Enum || this.dataType instanceof FunctionDefinition;
    }

    private boolean canRename() {
        return !(this.dataType instanceof BuiltInDataType) && !(this.dataType instanceof MissingBuiltInDataType) && !(this.dataType instanceof Array) && !(this.dataType instanceof Pointer);
    }

    public String toString() {
        return this.getName();
    }

    public boolean isFavorite() {
        DataTypeManager dataTypeManager = this.dataType.getDataTypeManager();
        return dataTypeManager.isFavorite(this.dataType);
    }

    @Override
    public void setNodeCut(boolean isCut) {
        this.isCut = isCut;
        this.fireNodeChanged();
    }

    @Override
    public boolean canCut() {
        return this.isModifiable();
    }

    @Override
    public boolean canPaste(List<GTreeNode> pastedNodes) {
        return this.isModifiable();
    }

    @Override
    public boolean isCut() {
        return this.isCut;
    }

    @Override
    public ArchiveNode getArchiveNode() {
        GTreeNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return ((DataTypeTreeNode)parent).getArchiveNode();
    }

    @Override
    public boolean isModifiable() {
        ArchiveNode archiveNode = this.getArchiveNode();
        return archiveNode != null && archiveNode.isModifiable();
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    public void dataTypeStatusChanged() {
        this.fireNodeChanged();
    }

    public void dataTypeChanged() {
        this.toolTipText = null;
        this.fireNodeChanged();
        GTree tree = this.getTree();
        if (tree != null) {
            tree.repaint();
        }
    }

    public String getDisplayText() {
        String currentDisplayText = this.getCurrentDisplayText();
        if (!this.displayText.equals(currentDisplayText)) {
            this.displayText = currentDisplayText;
            this.fireNodeChanged();
        }
        return this.displayText;
    }

    private String getCurrentDisplayText() {
        String baseDisplayText = this.dataType.getName();
        UniversalID localID = this.dataType.getDataTypeManager().getUniversalID();
        SourceArchive sourceArchive = this.dataType.getSourceArchive();
        if (sourceArchive != null && sourceArchive.getArchiveType() != ArchiveType.BUILT_IN && !sourceArchive.getSourceArchiveID().equals((Object)localID)) {
            return baseDisplayText + "  (" + sourceArchive.getName() + ")";
        }
        return baseDisplayText;
    }

    protected List<GTreeNode> generateChildren() {
        return Collections.emptyList();
    }
}

