/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.tree.ArrayPointerFilterState;
import ghidra.app.plugin.core.datamgr.tree.DomainFileArchiveNode;
import ghidra.framework.model.DomainFile;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.HTMLUtilities;

public class ProgramArchiveNode
extends DomainFileArchiveNode {
    public ProgramArchiveNode(ProgramArchive archive, ArrayPointerFilterState filterState) {
        super(archive, filterState);
    }

    @Override
    public String getToolTip() {
        DataTypeManager dtm = this.archive.getDataTypeManager();
        DomainFile file = ((ProgramArchive)this.archive).getDomainFile();
        StringBuilder buf = new StringBuilder("<html>");
        if (file != null) {
            buf.append(HTMLUtilities.escapeHTML((String)file.toString()));
        } else {
            buf.append("[Unsaved New Program Archive]");
        }
        buf.append("<br>");
        buf.append("&nbsp;");
        buf.append("&nbsp;");
        buf.append(HTMLUtilities.escapeHTML((String)dtm.getProgramArchitectureSummary()));
        return buf.toString();
    }
}

