/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.editor;

import docking.widgets.combobox.GhidraComboBox;
import docking.widgets.table.FocusableEditor;
import docking.widgets.textfield.IntegerTextField;
import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.function.editor.StorageAddressModel;
import ghidra.app.plugin.core.function.editor.VarnodeInfo;
import ghidra.app.plugin.core.function.editor.VarnodeTableModel;
import ghidra.app.plugin.core.function.editor.VarnodeType;
import ghidra.app.util.AddressInput;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.util.Msg;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;

class VarnodeLocationCellEditor
extends AbstractCellEditor
implements TableCellEditor,
FocusableEditor {
    private Program program;
    private VarnodeType type;
    private Component editorComponent;
    private GhidraComboBox<Register> combo;
    private AddressInput addressInput;
    private IntegerTextField offsetInput;
    private Comparator<Register> registerWrapperComparator = (r1, r2) -> r1.toString().compareToIgnoreCase(r2.toString());
    private VarnodeInfo currentVarnode;
    private int maxRegisterSize;

    VarnodeLocationCellEditor(StorageAddressModel model) {
        this.program = model.getProgram();
        this.maxRegisterSize = this.program.getDefaultPointerSize();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() > 1;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        switch (this.type) {
            case Register: {
                Object selectedObj = this.combo.getSelectedItem();
                if (!(selectedObj instanceof String) || this.program.getRegister((String)selectedObj) != null) break;
                Msg.showError((Object)this, (Component)this.editorComponent, (String)"Invalid Register", (Object)("Register does not exist: " + String.valueOf(selectedObj)));
                return false;
            }
            case Stack: {
                BigInteger value = this.offsetInput.getValue();
                if (value == null) break;
                try {
                    this.program.getAddressFactory().getStackSpace().getAddress(value.longValue());
                    break;
                }
                catch (AddressOutOfBoundsException e) {
                    Msg.showError((Object)this, (Component)this.editorComponent, (String)"Invalid Stack Offset", (Object)("Invalid stack offset: " + this.offsetInput.getText()));
                    return false;
                }
            }
        }
        this.fireEditingStopped();
        return true;
    }

    @Override
    public Object getCellEditorValue() {
        switch (this.type) {
            case Register: {
                return this.combo.getSelectedItem();
            }
            case Stack: {
                BigInteger value = this.offsetInput.getValue();
                return value == null ? null : this.program.getAddressFactory().getStackSpace().getAddress(value.longValue());
            }
            case Memory: {
                return this.addressInput.getAddress();
            }
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        VarnodeTableModel tableModel = (VarnodeTableModel)((Object)table.getModel());
        this.currentVarnode = (VarnodeInfo)tableModel.getRowObject(row);
        this.type = this.currentVarnode.getType();
        this.editorComponent = null;
        switch (this.type) {
            case Register: {
                this.editorComponent = this.createRegisterCombo(this.currentVarnode);
                break;
            }
            case Stack: {
                this.editorComponent = this.createStackOffsetEditor(this.currentVarnode);
                break;
            }
            case Memory: {
                this.editorComponent = this.createAddressEditor(this.currentVarnode);
            }
        }
        return this.editorComponent;
    }

    public void focusEditor() {
        Component component = this.editorComponent;
        if (component instanceof AddressInput) {
            AddressInput input = (AddressInput)component;
            input.focusEditor();
        } else {
            this.editorComponent.requestFocusInWindow();
        }
    }

    private Component createAddressEditor(VarnodeInfo varnode) {
        this.addressInput = new AddressInput(BorderFactory.createEmptyBorder());
        this.addressInput.setAddressFactory(this.program.getAddressFactory());
        Address address = varnode.getAddress();
        if (address != null) {
            this.addressInput.setAddress(address);
        }
        this.addressInput.addActionListener(e -> this.stopCellEditing());
        return this.addressInput;
    }

    private Component createStackOffsetEditor(VarnodeInfo varnode) {
        this.offsetInput = new IntegerTextField();
        this.offsetInput.setHexMode();
        Address address = varnode.getAddress();
        if (address != null) {
            this.offsetInput.setValue(address.getOffset());
        }
        this.offsetInput.addActionListener(e -> this.stopCellEditing());
        JComponent component = this.offsetInput.getComponent();
        component.setBorder(BorderFactory.createLineBorder((Color)GThemeDefaults.Colors.Palette.GRAY, 1));
        return component;
    }

    private Component createRegisterCombo(VarnodeInfo varnode) {
        ProgramContext programContext = this.program.getProgramContext();
        ArrayList validItems = new ArrayList(programContext.getRegisters());
        Iterator iter = validItems.iterator();
        while (iter.hasNext()) {
            Register register = (Register)iter.next();
            if (!register.isProcessorContext() && !register.isHidden()) continue;
            iter.remove();
        }
        Collections.sort(validItems, this.registerWrapperComparator);
        Object[] registers = validItems.toArray(new Register[validItems.size()]);
        this.combo = new GhidraComboBox(registers);
        this.combo.setEditable(false);
        this.combo.setEnterKeyForwarding(true);
        Address address = varnode.getAddress();
        if (address != null && varnode.getSize() != null) {
            Register register = this.program.getRegister(address, varnode.getSize().intValue());
            this.combo.setSelectedItem((Object)register);
        }
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                VarnodeLocationCellEditor.this.stopCellEditing();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.combo.addActionListener(e -> this.stopCellEditing());
        return this.combo;
    }
}

