/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.InputDialog;
import docking.widgets.table.GTable;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.cmd.function.ChangeFunctionTagCmd;
import ghidra.app.cmd.function.DeleteFunctionTagCmd;
import ghidra.app.plugin.core.function.tags.FunctionTagProvider;
import ghidra.app.plugin.core.function.tags.FunctionTagRowObject;
import ghidra.app.plugin.core.function.tags.FunctionTagTable;
import ghidra.app.plugin.core.function.tags.FunctionTagTableModel;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionTag;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.apache.commons.lang3.StringUtils;

public abstract class TagListPanel
extends JPanel {
    protected PluginTool tool;
    protected FunctionTagProvider provider;
    protected Program program;
    protected Function function;
    protected FunctionTagTableModel model;
    protected FunctionTagTable table;
    private GhidraTableFilterPanel<FunctionTagRowObject> filterPanel;
    private JLabel titleLabel;

    public TagListPanel(final FunctionTagProvider provider, PluginTool tool, String name) {
        this.tool = tool;
        this.provider = provider;
        this.setLayout(new BorderLayout());
        this.model = new FunctionTagTableModel("Function Tags", (ServiceProvider)provider.getTool(), this);
        GhidraThreadedTablePanel<FunctionTagRowObject> tablePanel = new GhidraThreadedTablePanel<FunctionTagRowObject>((ThreadedTableModel)this.model){

            @Override
            protected GTable createTable(ThreadedTableModel<FunctionTagRowObject, ?> tm) {
                return new FunctionTagTable(TagListPanel.this.model);
            }
        };
        this.table = (FunctionTagTable)tablePanel.getTable();
        this.filterPanel = new GhidraTableFilterPanel((JTable)((Object)this.table), this.model);
        this.titleLabel = new JLabel(name);
        this.titleLabel.setBorder(BorderFactory.createEmptyBorder(3, 5, 0, 0));
        this.add((Component)this.titleLabel, "North");
        this.add((Component)((Object)tablePanel), "Center");
        this.add((Component)((Object)this.filterPanel), "South");
        this.table.setAccessibleNamePrefix(name);
        this.filterPanel.setAccessibleNamePrefix(name);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                provider.selectionChanged(TagListPanel.this);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() != 2) {
                    return;
                }
                int row = TagListPanel.this.table.getSelectedRow();
                TagListPanel.this.editRow(row);
            }
        });
    }

    public abstract void refresh(Function var1);

    protected abstract Set<FunctionTag> backgroundLoadTags();

    void editRow(int row) {
        ChangeFunctionTagCmd cmd;
        FunctionTagRowObject rowObject = (FunctionTagRowObject)this.model.getRowObject(row);
        if (rowObject.isImmutable()) {
            Msg.showWarn((Object)this, (Component)((Object)this.table), (String)"Tag Not Editable", (Object)("Tag \"" + rowObject.getName() + "\" must be added to the program before it can be modified/deleted"));
            return;
        }
        String tagName = rowObject.getName();
        String comment = rowObject.getComment();
        String[] labels = new String[]{"Name:", "Comment:"};
        String[] init = new String[]{tagName, comment};
        InputDialog dialog = new InputDialog("Edit Tag", labels, init, d -> {
            String[] results = d.getValues();
            if (results == null || results.length != 2) {
                return false;
            }
            String newName = results[0].trim();
            if (StringUtils.isBlank((CharSequence)newName)) {
                d.setStatusText("Tag name cannot be empty");
                return false;
            }
            if (!Objects.equals(tagName, newName)) {
                return true;
            }
            String newComment = results[1].trim();
            return !Objects.equals(comment, newComment);
        });
        DockingWindowManager.showDialog((Component)this.tool.getActiveWindow(), (DialogComponentProvider)dialog);
        String[] results = dialog.getValues();
        if (results[0] == null) {
            return;
        }
        String newName = results[0].trim();
        String newComment = results[1].trim();
        if (!newName.equals(tagName)) {
            cmd = new ChangeFunctionTagCmd(tagName, newName, 0);
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
        if (!newComment.equals(comment)) {
            cmd = new ChangeFunctionTagCmd(tagName, newComment, 1);
            this.tool.execute((Command)cmd, (DomainObject)this.program);
        }
    }

    FunctionTagTableModel getModel() {
        return this.model;
    }

    public FunctionTagTable getTable() {
        return this.table;
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public void setProgram(Program program) {
        this.program = program;
        this.model.setProgram(program);
    }

    public void setTitle(String title) {
        this.titleLabel.setText(title);
    }

    public boolean tagExists(String name) {
        return this.model.containsTag(name);
    }

    protected boolean hasSelection() {
        return this.table.getSelectedRowCount() != 0;
    }

    protected boolean isSelectionImmutable() {
        List items = this.filterPanel.getSelectedItems();
        return items.stream().anyMatch(row -> row.isImmutable());
    }

    protected void deleteSelectedTags() {
        Set<FunctionTag> selectedTags = this.getSelectedTags();
        if (selectedTags.isEmpty()) {
            return;
        }
        int option = OptionDialog.showOptionDialog((Component)this, (String)"Function Tag Delete", (String)"Are you sure? \nThis will delete the tag from all functions in the program.", (String)"OK", (int)2);
        if (option == 1) {
            for (FunctionTag tag : selectedTags) {
                DeleteFunctionTagCmd cmd = new DeleteFunctionTagCmd(tag.getName());
                this.tool.execute((Command)cmd, (DomainObject)this.program);
            }
        }
    }

    protected Set<FunctionTag> getAssignedTags(Function func) {
        HashSet<FunctionTag> assignedTags = new HashSet<FunctionTag>();
        if (func != null) {
            assignedTags.addAll(func.getTags());
        }
        return assignedTags;
    }

    protected Set<FunctionTag> getSelectedTags() {
        List items = this.filterPanel.getSelectedItems();
        return items.stream().map(row -> row.getTag()).collect(Collectors.toSet());
    }
}

