/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import docking.widgets.table.GTableCellRenderingData;
import generic.theme.Gui;
import ghidra.app.plugin.core.instructionsearch.model.InstructionTableDataObject;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;

public class InstructionTableCellRenderer
extends GhidraTableCellRenderer {
    private static final String FONT_ID = "font.plugin.instruction.table.renderer";

    public InstructionTableCellRenderer() {
        super(Gui.getFont((String)FONT_ID));
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        Object value = data.getValue();
        boolean isSelected = data.isSelected();
        boolean hasFocus = data.hasFocus();
        if (value == null) {
            return this;
        }
        InstructionTableDataObject dataObject = (InstructionTableDataObject)value;
        String strData = dataObject.getData();
        GTableCellRenderingData renderData = data.copyWithNewValue((Object)strData);
        JLabel theRenderer = (JLabel)super.getTableCellRendererComponent(renderData);
        this.setTextAttributes();
        this.setBackgroundAttributes(isSelected, hasFocus, dataObject);
        this.setBorderAttributes(dataObject, theRenderer);
        this.setForegroundAttributes(dataObject, theRenderer);
        return this;
    }

    private void setBorderAttributes(InstructionTableDataObject dataObject, JLabel theRenderer) {
        theRenderer.setBorder(dataObject.getBorder());
    }

    private void setForegroundAttributes(InstructionTableDataObject dataObject, JLabel theRenderer) {
        theRenderer.setForeground(dataObject.getForegroundColor());
        Font newFont = theRenderer.getFont().deriveFont(dataObject.getFontStyle());
        theRenderer.setFont(newFont);
    }

    private void setBackgroundAttributes(boolean isSelected, boolean hasFocus, InstructionTableDataObject dataObject) {
        Color backgroundColor = dataObject.getBackgroundColor();
        if (backgroundColor != null) {
            if (isSelected || hasFocus) {
                this.setBackground(Gui.darker((Color)backgroundColor));
            } else {
                this.setBackground(backgroundColor);
            }
        }
    }

    private void setTextAttributes() {
        this.setHorizontalAlignment(2);
        this.setFont(this.getDefaultFont());
        this.setOpaque(true);
    }
}

