/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import ghidra.app.plugin.core.clear.ClearCmd;
import ghidra.app.plugin.core.clear.ClearOptions;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.exception.RollbackException;
import ghidra.util.task.TaskMonitor;

public class UninitializedBlockCmd
extends BackgroundCommand<Program> {
    private MemoryBlock block;

    public UninitializedBlockCmd(MemoryBlock block) {
        super("Unitialize Memory Block", false, true, true);
        this.block = block;
    }

    public boolean applyTo(Program program, TaskMonitor monitor) throws RuntimeException {
        ClearOptions clearOptions = new ClearOptions(false);
        clearOptions.setClearCode(true);
        clearOptions.setClearDefaultReferences(true);
        clearOptions.setClearFunctions(true);
        clearOptions.setClearAnalysisReferences(true);
        clearOptions.setClearImportReferences(true);
        clearOptions.setClearUserReferences(true);
        ClearCmd clearCmd = new ClearCmd((AddressSetView)new AddressSet(this.block.getStart(), this.block.getEnd()), clearOptions);
        if (!clearCmd.applyTo(program, monitor)) {
            this.setStatusMsg(clearCmd.getStatusMsg());
            return false;
        }
        if (monitor.isCancelled()) {
            throw new RollbackException("Operation cancelled");
        }
        try {
            program.getMemory().convertToUninitialized(this.block);
        }
        catch (Exception e) {
            this.setStatusMsg(e.getMessage());
            return false;
        }
        return true;
    }
}

