/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import generic.theme.GColor;
import generic.theme.GIcon;
import ghidra.app.plugin.core.programtree.DragNDropTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.program.model.listing.Group;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import resources.ResourceManager;

class DnDTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Color BACKGROUND_UNSELECTED = new GColor("color.bg.tree");
    private static final Color BACKGROUND_SELECTED = new GColor("color.bg.tree.selected");
    private static final Color FOREGROUND_SELECTED = new GColor("color.fg.tree.selected");
    private static final String DISABLED_DOCS = "DisabledDocument.gif";
    private static final String DISABLED_FRAGMENT = "DisabledFragment";
    private static final String DISABLED_VIEWED_FRAGMENT = "DisabledViewedFragment";
    private static final String DISABLED_EMPTY_FRAGMENT = "DisabledEmptyFragment";
    private static final String DISABLED_VIEWED_EMPTY_FRAGMENT = "DisabledViewedEmptyFragment";
    private static final String DISABLED_VIEWED_OPEN_FOLDER = "DisabledViewedOpenFolder";
    private static final String DISABLED_VIEWED_CLOSED_FOLDER = "DisabledViewedClosedFolder";
    private static final String DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC = "DisabledViewedClosedFolderWithDescendants";
    private static final String DISABLED_CLOSED_FOLDER = "DisabledClosedFolder";
    private static final String DISABLED_OPEN_FOLDER = "DisabledOpenedFolder";
    private static final String DOCS = "icon.plugin.programtree.docs";
    static final String FRAGMENT = "icon.plugin.programtree.fragment";
    private static final String EMPTY_FRAGMENT = "icon.plugin.programtree.fragment.empty";
    static final String VIEWED_FRAGMENT = "icon.plugin.programtree.fragment.viewed";
    static final String VIEWED_EMPTY_FRAGMENT = "icon.plugin.programtree.fragment.viewed.empty";
    static final String VIEWED_CLOSED_FOLDER = "icon.plugin.programtree.fragment.closed.folder";
    static final String VIEWED_OPEN_FOLDER = "icon.plugin.programtree.fragment.open.folder";
    static final String VIEWED_CLOSED_FOLDER_WITH_DESC = "icon.plugin.programtree.fragment.viewed.closed.folder.with.description";
    static final String CLOSED_FOLDER = "icon.plugin.programtree.closed.folder";
    static final String OPEN_FOLDER = "icon.plugin.programtree.open.folder";
    private Map<String, Icon> iconMap;
    private Color defaultSelectionColor;
    private Color defaultNonSelectionColor = BACKGROUND_UNSELECTED;
    private Color selectionForDragColor;
    private Color nonSelectionForDragColor;
    private Color defaultTextSelectionColor;
    private int rowForFeedback = -1;

    DnDTreeCellRenderer() {
        this.defaultSelectionColor = BACKGROUND_SELECTED;
        this.defaultTextSelectionColor = FOREGROUND_SELECTED;
        this.setHTMLRenderingEnabled(false);
        this.loadImages();
    }

    public void setHTMLRenderingEnabled(boolean enable) {
        this.putClientProperty("html.disable", !enable);
    }

    void setSelectionForDrag(Color color) {
        this.selectionForDragColor = color;
    }

    void setNonSelectionForDrag(Color color) {
        this.nonSelectionForDragColor = color;
    }

    void setRowForFeedback(int row) {
        this.rowForFeedback = row;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean isFocused) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, isFocused);
        ProgramNode node = (ProgramNode)value;
        Group group = node.getGroup();
        Icon icon = null;
        boolean isInView = node.isInView();
        icon = group == null && !node.isRoot() ? (node.isDeleted() ? this.iconMap.get(DISABLED_DOCS) : this.iconMap.get(DOCS)) : (node.isFragment() ? this.getFragmentIcon(node, isInView) : this.getFolderIcon(expanded, leaf, node, isInView));
        if (icon != null) {
            this.setIcon(icon);
        }
        this.setSelectionColors(sel, row, node, (DragNDropTree)tree);
        return this;
    }

    private void setSelectionColors(boolean selected, int row, ProgramNode node, DragNDropTree dtree) {
        if (dtree.getDrawFeedbackState()) {
            if (row == this.rowForFeedback) {
                if (!selected) {
                    this.setBackgroundNonSelectionColor(this.nonSelectionForDragColor);
                } else {
                    this.setBackgroundSelectionColor(this.selectionForDragColor);
                }
            } else {
                this.setBackgroundSelectionColor(this.defaultSelectionColor);
                this.setTextSelectionColor(this.defaultTextSelectionColor);
                this.setBackgroundNonSelectionColor(this.defaultNonSelectionColor);
            }
            this.setToolTipText(null);
        } else {
            this.setBackgroundSelectionColor(this.defaultSelectionColor);
            this.setTextSelectionColor(this.defaultTextSelectionColor);
            this.setBackgroundNonSelectionColor(this.defaultNonSelectionColor);
            this.setToolTipText(dtree.getToolTipText(node));
        }
    }

    private Icon getFolderIcon(boolean expanded, boolean leaf, ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = leaf && node.isRoot() ? (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : this.iconMap.get(CLOSED_FOLDER)) : (leaf ? this.processLeafNode(node, isInView) : (node.isDeleted() ? this.processDeletedNode(expanded, node, isInView) : (expanded ? (isInView ? this.iconMap.get(VIEWED_OPEN_FOLDER) : this.iconMap.get(OPEN_FOLDER)) : (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : (node.hasDescendantsInView() ? this.iconMap.get(VIEWED_CLOSED_FOLDER_WITH_DESC) : this.iconMap.get(CLOSED_FOLDER))))));
        return icon;
    }

    private Icon processDeletedNode(boolean expanded, ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = expanded ? (isInView ? this.iconMap.get(DISABLED_VIEWED_OPEN_FOLDER) : this.iconMap.get(DISABLED_OPEN_FOLDER)) : (isInView ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER) : (node.hasDescendantsInView() ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC) : this.iconMap.get(DISABLED_CLOSED_FOLDER)));
        return icon;
    }

    private Icon processLeafNode(ProgramNode node, boolean isInView) {
        Icon icon = null;
        icon = node.isDeleted() ? (isInView ? this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER) : this.iconMap.get(DISABLED_VIEWED_CLOSED_FOLDER)) : (isInView ? this.iconMap.get(VIEWED_CLOSED_FOLDER) : this.iconMap.get(CLOSED_FOLDER));
        return icon;
    }

    private Icon getFragmentIcon(ProgramNode node, boolean isInView) {
        boolean isEmpty = false;
        try {
            isEmpty = node.getFragment().isEmpty();
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        Icon icon = node.isDeleted() ? (isInView ? (isEmpty ? this.iconMap.get(DISABLED_VIEWED_EMPTY_FRAGMENT) : this.iconMap.get(DISABLED_VIEWED_FRAGMENT)) : (isEmpty ? this.iconMap.get(DISABLED_EMPTY_FRAGMENT) : this.iconMap.get(DISABLED_FRAGMENT))) : (node.isInView() ? (isEmpty ? this.iconMap.get(VIEWED_EMPTY_FRAGMENT) : this.iconMap.get(VIEWED_FRAGMENT)) : (isEmpty ? this.iconMap.get(EMPTY_FRAGMENT) : this.iconMap.get(FRAGMENT)));
        return icon;
    }

    private void loadImages() {
        this.iconMap = new HashMap<String, Icon>();
        String[] iconIds = new String[]{DOCS, FRAGMENT, EMPTY_FRAGMENT, VIEWED_FRAGMENT, VIEWED_EMPTY_FRAGMENT, VIEWED_CLOSED_FOLDER, VIEWED_OPEN_FOLDER, VIEWED_CLOSED_FOLDER_WITH_DESC, CLOSED_FOLDER, OPEN_FOLDER};
        String[] disabledNames = new String[]{DISABLED_DOCS, DISABLED_FRAGMENT, DISABLED_EMPTY_FRAGMENT, DISABLED_VIEWED_EMPTY_FRAGMENT, DISABLED_VIEWED_FRAGMENT, DISABLED_VIEWED_CLOSED_FOLDER, DISABLED_VIEWED_OPEN_FOLDER, DISABLED_VIEWED_CLOSED_FOLDER_WITH_DESC, DISABLED_CLOSED_FOLDER, DISABLED_OPEN_FOLDER};
        for (int i = 0; i < iconIds.length; ++i) {
            GIcon icon = new GIcon(iconIds[i]);
            this.iconMap.put(iconIds[i], (Icon)icon);
            ImageIcon disabledIcon = ResourceManager.getDisabledIcon((Icon)icon);
            this.iconMap.put(disabledNames[i], disabledIcon);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        if (dim != null) {
            return new Dimension(dim.width, dim.height + 2);
        }
        return dim;
    }
}

