/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.reachability;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.reachability.FREdge;
import ghidra.app.plugin.core.reachability.FRVertex;
import ghidra.app.plugin.core.reachability.FunctionReachabilityResult;
import ghidra.app.services.BlockModelService;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.GEdge;
import ghidra.graph.GraphAlgorithms;
import ghidra.graph.GraphFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.block.CodeBlockModel;
import ghidra.program.model.block.CodeBlockReference;
import ghidra.program.model.block.CodeBlockReferenceIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.NotFoundException;
import ghidra.util.table.GhidraProgramTableModel;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FunctionReachabilityTableModel
extends GhidraProgramTableModel<FunctionReachabilityResult> {
    private static final int FROM_FUNCTION_COLUMN = 0;
    private static final int TO_FUNCTION_COLUMN = 1;
    private Function fromFunction;
    private Function toFunction;

    FunctionReachabilityTableModel(ServiceProvider sp, Program p) {
        super("Function Reachability Model", sp, p, null, true);
        this.setProgram(p);
    }

    protected TableColumnDescriptor<FunctionReachabilityResult> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new FromFunctionTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new ToFunctionTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new PathLengthTableColumn(this));
        return descriptor;
    }

    protected void doLoad(Accumulator<FunctionReachabilityResult> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.fromFunction == null || this.toFunction == null) {
            return;
        }
        monitor.setIndeterminate(true);
        monitor.setMessage("Creating callgraph...");
        HashMap<Address, FRVertex> instanceMap = new HashMap<Address, FRVertex>();
        FRVertex v1 = new FRVertex(this.fromFunction.getEntryPoint());
        FRVertex v2 = new FRVertex(this.toFunction.getEntryPoint());
        instanceMap.put(this.fromFunction.getEntryPoint(), v1);
        instanceMap.put(this.toFunction.getEntryPoint(), v2);
        GDirectedGraph<FRVertex, FREdge> graph = this.createCallGraph(instanceMap, monitor);
        PassThroughAccumulator pathAccumulator = new PassThroughAccumulator(accumulator);
        if (v1.equals(v2)) {
            return;
        }
        monitor.setMessage("Finding paths...");
        GraphAlgorithms.findPaths(graph, (Object)v1, (Object)v2, (Accumulator)pathAccumulator, (TaskMonitor)monitor);
    }

    protected GDirectedGraph<FRVertex, FREdge> createCallGraph(Map<Address, FRVertex> instanceMap, TaskMonitor monitor) throws CancelledException {
        GDirectedGraph graph = GraphFactory.createDirectedGraph();
        CodeBlockIterator codeBlocks = this.getCallGraphBlocks(monitor);
        while (codeBlocks.hasNext()) {
            monitor.checkCancelled();
            CodeBlock block = codeBlocks.next();
            monitor.setMessage("Creating callgraph - block " + String.valueOf(block.getMinAddress()));
            FRVertex fromVertex = instanceMap.get(block.getFirstStartAddress());
            if (fromVertex == null) {
                fromVertex = new FRVertex(block.getFirstStartAddress());
                instanceMap.put(block.getFirstStartAddress(), fromVertex);
                graph.addVertex((Object)fromVertex);
            }
            this.addEdgesForDestinations((GDirectedGraph<FRVertex, FREdge>)graph, fromVertex, block, instanceMap, monitor);
        }
        return graph;
    }

    private CodeBlockIterator getCallGraphBlocks(TaskMonitor monitor) throws CancelledException {
        CodeBlockModel model;
        BlockModelService blockModelService = (BlockModelService)this.serviceProvider.getService(BlockModelService.class);
        try {
            model = blockModelService.getNewModelByName("Isolated Entry");
        }
        catch (NotFoundException e) {
            Msg.error((Object)this, (Object)"Code block model not found: Isolated Entry");
            model = blockModelService.getActiveSubroutineModel();
        }
        return model.getCodeBlocks(monitor);
    }

    private void addEdgesForDestinations(GDirectedGraph<FRVertex, FREdge> graph, FRVertex fromVertex, CodeBlock sourceBlock, Map<Address, FRVertex> vertexMap, TaskMonitor monitor) throws CancelledException {
        CodeBlockReferenceIterator iterator = sourceBlock.getDestinations(monitor);
        while (iterator.hasNext()) {
            monitor.checkCancelled();
            CodeBlockReference destination = iterator.next();
            CodeBlock targetBlock = this.getDestinationBlock(destination, monitor);
            if (targetBlock == null) continue;
            FRVertex targetVertex = vertexMap.get(targetBlock.getFirstStartAddress());
            if (targetVertex == null) {
                targetVertex = new FRVertex(targetBlock.getFirstStartAddress());
                vertexMap.put(targetBlock.getFirstStartAddress(), targetVertex);
            }
            targetVertex.addReference(fromVertex, destination);
            graph.addVertex((Object)targetVertex);
            graph.addEdge((GEdge)new FREdge(fromVertex, targetVertex));
        }
    }

    private CodeBlock getDestinationBlock(CodeBlockReference destination, TaskMonitor monitor) throws CancelledException {
        Address targetAddress = destination.getDestinationAddress();
        BlockModelService blockModelService = (BlockModelService)this.serviceProvider.getService(BlockModelService.class);
        CodeBlockModel codeBlockModel = blockModelService.getActiveSubroutineModel();
        CodeBlock targetBlock = codeBlockModel.getFirstCodeBlockContaining(targetAddress, monitor);
        if (targetBlock == null) {
            return null;
        }
        return targetBlock;
    }

    void setFunctions(Function from, Function to) {
        this.fromFunction = from;
        this.toFunction = to;
        this.reload();
    }

    @Override
    public Program getDataSource() {
        return this.program;
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        FunctionReachabilityResult result = (FunctionReachabilityResult)this.getRowObject(row);
        if (column == 0) {
            Function function = result.getFromFunction();
            Address address = function.getEntryPoint();
            return new ProgramLocation(this.getProgram(), address);
        }
        if (column == 1) {
            Function function = result.getToFunction();
            Address address = function.getEntryPoint();
            return new ProgramLocation(this.getProgram(), address);
        }
        return null;
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        return null;
    }

    private class FromFunctionTableColumn
    extends AbstractDynamicTableColumn<FunctionReachabilityResult, String, Program> {
        private FromFunctionTableColumn(FunctionReachabilityTableModel functionReachabilityTableModel) {
        }

        public String getColumnName() {
            return "From";
        }

        public String getValue(FunctionReachabilityResult rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getFromFunction().toString();
        }
    }

    private class ToFunctionTableColumn
    extends AbstractDynamicTableColumn<FunctionReachabilityResult, String, Program> {
        private ToFunctionTableColumn(FunctionReachabilityTableModel functionReachabilityTableModel) {
        }

        public String getColumnName() {
            return "To";
        }

        public String getValue(FunctionReachabilityResult rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getToFunction().toString();
        }
    }

    private class PathLengthTableColumn
    extends AbstractDynamicTableColumn<FunctionReachabilityResult, Integer, Program> {
        private PathLengthTableColumn(FunctionReachabilityTableModel functionReachabilityTableModel) {
        }

        public String getColumnName() {
            return "Length";
        }

        public String getColumnDescription() {
            return "The length of this path";
        }

        public Integer getValue(FunctionReachabilityResult rowObject, Settings settings, Program data, ServiceProvider sp) throws IllegalArgumentException {
            return rowObject.getPathLength();
        }
    }

    private class PassThroughAccumulator
    implements Accumulator<List<FRVertex>> {
        private Accumulator<FunctionReachabilityResult> accumulator;

        PassThroughAccumulator(Accumulator<FunctionReachabilityResult> accumulator) {
            this.accumulator = accumulator;
        }

        public Iterator<List<FRVertex>> iterator() {
            throw new UnsupportedOperationException();
        }

        public void add(List<FRVertex> t) {
            this.accumulator.add((Object)new FunctionReachabilityResult(FunctionReachabilityTableModel.this.fromFunction, FunctionReachabilityTableModel.this.toFunction, t));
        }

        public void addAll(Collection<List<FRVertex>> collection) {
            for (List<FRVertex> list : collection) {
                this.accumulator.add((Object)new FunctionReachabilityResult(FunctionReachabilityTableModel.this.fromFunction, FunctionReachabilityTableModel.this.toFunction, list));
            }
        }

        public boolean contains(List<FRVertex> t) {
            throw new UnsupportedOperationException();
        }

        public Collection<List<FRVertex>> get() {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.accumulator.size();
        }
    }
}

