/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.action.DockingAction;
import docking.actions.KeyBindingUtils;
import docking.dnd.DropTgtAdapter;
import docking.dnd.Droppable;
import docking.widgets.label.GDLabel;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.plugin.core.references.EditReferencesProvider;
import ghidra.app.plugin.core.references.InstructionPanelListener;
import ghidra.app.plugin.core.references.ReferencesPlugin;
import ghidra.app.util.SelectionTransferData;
import ghidra.app.util.SelectionTransferable;
import ghidra.app.util.SymbolInspector;
import ghidra.app.util.viewer.field.BrowserCodeUnitFormat;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class InstructionPanel
extends JPanel
implements ChangeListener {
    private static Color FOCUS_COLOR = new GColor("color.palette.yellow");
    private static final int BORDER_SIZE = 2;
    private static final Border EMPTY_BORDER = new EmptyBorder(2, 2, 2, 2);
    private static final Border ETCHED_BORDER = new EtchedBorder();
    private static final Color NOT_IN_MEMORY_COLOR = GThemeDefaults.Colors.ERROR;
    private static final Color DEFAULT_FG_COLOR = GThemeDefaults.Colors.FOREGROUND;
    private static final DataFlavor[] ACCEPTABLE_DROP_FLAVORS = new DataFlavor[]{SelectionTransferable.localProgramSelectionFlavor};
    private MouseListener mouseListener = new LabelMouseListener();
    private boolean locked;
    private DockingAction goHomeAction;
    private JLabel addressLabel;
    private JLabel mnemonicLabel;
    private JLabel[] operandLabels;
    private DropTarget[] dropTargets;
    private JPanel innerPanel;
    private int activeIndex;
    private int activeSubIndex;
    private CodeUnit currentCodeUnit;
    private BrowserCodeUnitFormat cuFormat;
    private SymbolInspector symbolInspector;
    private Memory memory;
    private InstructionPanelListener listener;
    private boolean dropSupported;
    private DropTgtAdapter dropTargetAdapter;
    private Droppable dropHandler = new InstructionPanelDroppable();
    private int nOperands;

    InstructionPanel(int topPad, int leftPad, int bottomPad, int rightPad, DockingAction goHomeAction, ReferencesPlugin plugin, InstructionPanelListener listener) {
        super(new BorderLayout());
        this.dropSupported = listener != null ? listener.dropSupported() : false;
        this.goHomeAction = goHomeAction;
        this.symbolInspector = plugin.getSymbolInspector();
        this.cuFormat = plugin.getCodeUnitFormat();
        this.listener = listener;
        this.create(topPad, leftPad, bottomPad, rightPad);
    }

    private int getNextIndex() {
        if (this.operandLabels.length == 0) {
            return -1;
        }
        if (this.activeIndex == -1) {
            return 0;
        }
        if (this.activeIndex < this.nOperands - 1) {
            return this.activeIndex + 1;
        }
        return -1;
    }

    private int getPreviousIndex() {
        if (this.operandLabels.length == 0) {
            return -1;
        }
        if (this.activeIndex == -1) {
            return this.nOperands - 1;
        }
        if (this.activeIndex > 0) {
            return this.activeIndex - 1;
        }
        return -1;
    }

    CodeUnit getCurrentCodeUnit() {
        return this.currentCodeUnit;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateActiveIndex(this.activeIndex, this.activeSubIndex);
    }

    void setCodeUnitLocation(CodeUnit cu, int opIndex, int subIndex, boolean locked) {
        if (cu != null) {
            this.locked = locked;
            this.addressLabel.setText(cu.getMinAddress().toString());
            this.memory = cu.getProgram().getMemory();
            this.cuFormat.addChangeListener(this);
        } else {
            this.cuFormat.removeChangeListener(this);
            this.locked = false;
            this.addressLabel.setText("");
            this.memory = null;
        }
        this.currentCodeUnit = cu;
        this.activeIndex = -2;
        this.updateActiveIndex(opIndex, subIndex);
        this.updateDropTargets(cu != null ? cu.getNumOperands() : -1);
    }

    void setSelectedOpIndex(int index, int subIndex) {
        this.updateActiveIndex(index, subIndex);
    }

    int getSelectedOpIndex() {
        return this.activeIndex;
    }

    int getSelectedSubOpIndex() {
        return this.activeSubIndex;
    }

    private void create(int topPad, int leftPad, int bottomPad, int rightPad) {
        TitledBorder border = new TitledBorder(new EtchedBorder(), "Source");
        this.setBorder(border);
        this.addressLabel = new GDLabel("FFFFFFFF");
        Gui.registerFont((Component)this.addressLabel, (String)"font.monospaced");
        this.addressLabel.setName("addressLabel");
        this.mnemonicLabel = new GDLabel("movl");
        Gui.registerFont((Component)this.mnemonicLabel, (String)"font.monospaced");
        this.mnemonicLabel.setName("mnemonicLabel");
        this.mnemonicLabel.addMouseListener(this.mouseListener);
        this.operandLabels = new JLabel[16];
        for (int i = 0; i < this.operandLabels.length; ++i) {
            this.operandLabels[i] = new GDLabel("%ebp, ");
            this.operandLabels[i].setName("operandLabels[" + i + "]");
            this.operandLabels[i].addMouseListener(this.mouseListener);
            Gui.registerFont((Component)this.operandLabels[i], (String)"font.monospaced");
        }
        this.innerPanel = new JPanel();
        BoxLayout bl = new BoxLayout(this.innerPanel, 0);
        this.innerPanel.setLayout(bl);
        this.setName("Instruction Panel");
        this.setToolTipText("This component selects which instruction piece is active for this dialog");
        this.innerPanel.getAccessibleContext().setAccessibleDescription("Use left or right arrows to choose which mnemonic or operand piece this dialog applies to");
        this.updateAccessibleInfo();
        if (this.goHomeAction != null) {
            JLabel[] action = KeyBindingUtils.adaptDockingActionToNonContextAction((DockingAction)this.goHomeAction);
            JButton homeButton = new JButton((Action)action);
            homeButton.setText(null);
            homeButton.setMargin(new Insets(0, 0, 0, 0));
            this.innerPanel.add(Box.createHorizontalStrut(5));
            this.add((Component)homeButton, "West");
        }
        this.innerPanel.add(Box.createHorizontalStrut(5));
        this.innerPanel.add(this.addressLabel);
        this.innerPanel.add(Box.createHorizontalStrut(20));
        this.innerPanel.add(this.mnemonicLabel);
        this.innerPanel.add(Box.createHorizontalStrut(10));
        this.innerPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        for (JLabel operandLabel : this.operandLabels) {
            this.innerPanel.add(operandLabel);
            this.innerPanel.add(Box.createHorizontalStrut(5));
        }
        this.add((Component)this.innerPanel, "Center");
        if (this.dropSupported) {
            this.dropTargetAdapter = new DropTgtAdapter(this.dropHandler, 3, ACCEPTABLE_DROP_FLAVORS);
            this.dropTargets = new DropTarget[17];
            this.dropTargets[0] = new DropTarget(this.mnemonicLabel, 3, (DropTargetListener)this.dropTargetAdapter, true);
            this.dropTargets[0].setActive(false);
            for (int i = 1; i < this.dropTargets.length; ++i) {
                this.dropTargets[i] = new DropTarget(this.operandLabels[i - 1], 3, (DropTargetListener)this.dropTargetAdapter, true);
                this.dropTargets[i].setActive(false);
            }
        }
        this.innerPanel.setFocusable(true);
        this.innerPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 37: {
                        InstructionPanel.this.updateActiveIndex(InstructionPanel.this.getPreviousIndex(), -1);
                        e.consume();
                        break;
                    }
                    case 39: {
                        InstructionPanel.this.updateActiveIndex(InstructionPanel.this.getNextIndex(), -1);
                        e.consume();
                    }
                }
            }
        });
        this.innerPanel.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                InstructionPanel.this.innerPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }

            @Override
            public void focusGained(FocusEvent e) {
                InstructionPanel.this.innerPanel.setBorder(BorderFactory.createLineBorder(FOCUS_COLOR, 1));
            }
        });
    }

    private void updateDropTargets(int numOperands) {
        ++numOperands;
        if (this.dropSupported) {
            for (int i = 0; i < this.dropTargets.length; ++i) {
                this.dropTargets[i].setActive(i < numOperands);
            }
        }
    }

    private void updateActiveIndex(int index, int subIndex) {
        int prevIndex = this.activeIndex;
        this.activeIndex = index;
        this.activeSubIndex = subIndex;
        this.updateLabels();
        this.updateAccessibleInfo();
        if (this.activeIndex != prevIndex && this.listener != null) {
            this.listener.operandSelected(this.activeIndex, this.activeSubIndex);
        }
        this.updateAccessibleInfo();
    }

    private void updateAccessibleInfo() {
        Object accessibleName = "Instruction Reference Panel";
        accessibleName = this.activeIndex < 0 ? (String)accessibleName + ", mnemonic selected" : (String)accessibleName + ", operand " + this.activeIndex + " selected";
        this.innerPanel.getAccessibleContext().setAccessibleName((String)accessibleName);
    }

    private void updateLabels() {
        for (JLabel operandLabel : this.operandLabels) {
            operandLabel.setText("");
            operandLabel.setBorder(EMPTY_BORDER);
            operandLabel.setBackground(this.getParent().getBackground());
        }
        if (this.currentCodeUnit != null) {
            this.nOperands = this.currentCodeUnit.getNumOperands();
            for (int i = 0; i < this.nOperands; ++i) {
                Object opRep = this.cuFormat.getOperandRepresentationString(this.currentCodeUnit, i);
                if (i < this.nOperands - 1) {
                    opRep = (String)opRep + ",";
                }
                this.setOperandAttributes(i, (String)opRep);
            }
            this.setMnemonicAttributes(this.currentCodeUnit.getMnemonicString());
        } else {
            this.mnemonicLabel.setText("");
            this.mnemonicLabel.setBorder(EMPTY_BORDER);
            this.mnemonicLabel.setBackground(this.getParent().getBackground());
        }
        this.innerPanel.invalidate();
        this.repaint();
    }

    private Color getOperandColor(int opIndex) {
        Address refAddr;
        Program program = this.currentCodeUnit.getProgram();
        Reference ref = this.currentCodeUnit.getPrimaryReference(opIndex);
        Address address = refAddr = ref != null ? ref.getToAddress() : this.currentCodeUnit.getAddress(opIndex);
        if (refAddr == null) {
            return DEFAULT_FG_COLOR;
        }
        if (refAddr.isMemoryAddress() && !program.getMemory().contains(refAddr)) {
            return NOT_IN_MEMORY_COLOR;
        }
        SymbolTable st = program.getSymbolTable();
        Symbol sym = st.getSymbol(ref);
        if (sym != null) {
            this.symbolInspector.setProgram(program);
            return this.symbolInspector.getColor(sym);
        }
        return DEFAULT_FG_COLOR;
    }

    private void setOperandAttributes(int opIndex, String operandText) {
        this.operandLabels[opIndex].setText(operandText);
        this.operandLabels[opIndex].setForeground(this.getOperandColor(opIndex));
        if (this.activeIndex == opIndex) {
            this.operandLabels[opIndex].setBorder(ETCHED_BORDER);
            this.operandLabels[opIndex].setBackground(EditReferencesProvider.BG_COLOR_ACTIVE_OPERAND);
            this.operandLabels[opIndex].setOpaque(true);
        } else {
            this.operandLabels[opIndex].setBackground(this.getParent().getBackground());
            this.operandLabels[opIndex].setBorder(EMPTY_BORDER);
            this.operandLabels[opIndex].setOpaque(false);
        }
    }

    private void setMnemonicAttributes(String mnemonicText) {
        this.mnemonicLabel.setText(mnemonicText);
        this.mnemonicLabel.setForeground(DEFAULT_FG_COLOR);
        if (this.activeIndex == -1) {
            this.mnemonicLabel.setBackground(EditReferencesProvider.BG_COLOR_ACTIVE_OPERAND);
            this.mnemonicLabel.setBorder(ETCHED_BORDER);
            this.mnemonicLabel.setOpaque(true);
        } else {
            this.mnemonicLabel.setBackground(this.getParent().getBackground());
            this.mnemonicLabel.setBorder(EMPTY_BORDER);
            this.mnemonicLabel.setOpaque(false);
        }
    }

    private int getLabelIndex(JLabel label) {
        for (int i = 0; i < this.operandLabels.length; ++i) {
            if (this.operandLabels[i] != label) continue;
            return i;
        }
        return -1;
    }

    private class LabelMouseListener
    extends MouseAdapter {
        private LabelMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (!InstructionPanel.this.locked) {
                JLabel label = (JLabel)e.getSource();
                label.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JLabel label = (JLabel)e.getSource();
            label.setCursor(Cursor.getDefaultCursor());
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!InstructionPanel.this.locked) {
                JLabel label = (JLabel)e.getSource();
                InstructionPanel.this.updateActiveIndex(InstructionPanel.this.getLabelIndex(label), -1);
            }
        }
    }

    private class InstructionPanelDroppable
    implements Droppable {
        private InstructionPanelDroppable() {
        }

        public boolean isDropOk(DropTargetDragEvent e) {
            Component targetComp = e.getDropTargetContext().getComponent();
            if (!(targetComp instanceof JLabel)) {
                return false;
            }
            InstructionPanel.this.updateActiveIndex(InstructionPanel.this.getLabelIndex((JLabel)targetComp), -1);
            try {
                Object data = e.getTransferable().getTransferData(SelectionTransferable.localProgramSelectionFlavor);
                AddressSetView view = ((SelectionTransferData)data).getAddressSet();
                if (InstructionPanel.this.memory.contains(view)) {
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }

        public void add(Object obj, DropTargetDropEvent e, DataFlavor f) {
            AddressSetView view = ((SelectionTransferData)obj).getAddressSet();
            if (view.getNumAddressRanges() == 0) {
                return;
            }
            InstructionPanel.this.listener.selectionDropped(view, InstructionPanel.this.currentCodeUnit, InstructionPanel.this.activeIndex);
        }
    }
}

