/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.references.OffsetTableDialog;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Create Offset References", description="Plugin to create offset tables based on a selection of data.  A dialog is displayed so that the user can enter a base address and the data type size. Data of the appropriate type is created; a reference to the base address + offset is placed on the operand index for each data that was created. The offset is the value of the data type.")
public class OffsetTablePlugin
extends Plugin {
    private DockingAction refAction;
    private int lastSelectedSize = 4;
    private boolean lastSigned = true;

    public OffsetTablePlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    private void createActions() {
        this.refAction = new ListingContextAction("Create Offset References", this.getName()){

            @Override
            public void actionPerformed(ListingActionContext context) {
                OffsetTablePlugin.this.showDialog(context);
            }

            @Override
            protected boolean isEnabledForContext(ListingActionContext context) {
                return context.hasSelection() && context.getSelection().getInteriorSelection() == null;
            }
        };
        this.refAction.setHelpLocation(new HelpLocation("ReferencesPlugin", this.refAction.getName()));
        this.refAction.setPopupMenuData(new MenuData(new String[]{"References", "Create Offset  References..."}, null, "references"));
        this.tool.addAction((DockingActionIf)this.refAction);
    }

    private void showDialog(ListingActionContext context) {
        this.tool.setStatusInfo("");
        if (this.containsInstructions(context)) {
            this.tool.setStatusInfo("Cannot create offset references: selection contains instructions", true);
            return;
        }
        AddressFactory addressFactory = context.getProgram().getAddressFactory();
        Address minAddress = context.getSelection().getMinAddress();
        OffsetTableDialog dialog = new OffsetTableDialog(minAddress, addressFactory);
        dialog.setSelectedSize(this.lastSelectedSize);
        dialog.setSigned(this.lastSigned);
        try {
            dialog.showDialog(this.tool);
        }
        catch (CancelledException e) {
            return;
        }
        Address addr = dialog.getBaseAddress();
        boolean signed = dialog.isSigned();
        if (addr != null) {
            this.createOffsetTable(context, addr, dialog.getSelectedSize(), signed);
        }
    }

    DataType getDataType(int size) {
        switch (size) {
            case 1: {
                return new ByteDataType();
            }
            case 2: {
                return new WordDataType();
            }
            case 4: {
                return new DWordDataType();
            }
            case 8: {
                return new QWordDataType();
            }
        }
        return new WordDataType();
    }

    private void createOffsetTable(ListingActionContext context, Address baseAddr, int dataTypeSize, boolean signed) {
        AddressRange range;
        Program program = context.getProgram();
        ProgramSelection selection = context.getSelection();
        this.lastSelectedSize = dataTypeSize;
        this.lastSigned = signed;
        DataType dt = this.getDataType(dataTypeSize);
        CompoundCmd cmd = new CompoundCmd("Create Offset References");
        AddressRangeIterator rangeIter = selection.getAddressRanges();
        while (rangeIter.hasNext()) {
            range = (AddressRange)rangeIter.next();
            cmd.add((Command)new ClearCmd(this, range));
        }
        try {
            rangeIter = selection.getAddressRanges();
            while (rangeIter.hasNext()) {
                range = (AddressRange)rangeIter.next();
                Address addr = range.getMinAddress();
                Address endAddr = addr.add((long)(dataTypeSize - 1));
                while (range.contains(endAddr)) {
                    cmd.add((Command)new MyCreateDataCmd(this, addr, baseAddr, dt, signed));
                    addr = addr.add((long)dataTypeSize);
                    endAddr = addr.add((long)(dataTypeSize - 1));
                }
            }
            this.tool.execute((Command)cmd, (DomainObject)program);
        }
        catch (AddressOutOfBoundsException e) {
            this.tool.setStatusInfo("Unable to create offset table: " + String.valueOf((Object)e));
        }
    }

    private boolean containsInstructions(ListingActionContext context) {
        Program program = context.getProgram();
        ProgramSelection selection = context.getSelection();
        InstructionIterator iter = program.getListing().getInstructions((AddressSetView)selection, true);
        return iter.hasNext();
    }

    private class ClearCmd
    implements Command<Program> {
        private AddressRange range;

        ClearCmd(OffsetTablePlugin offsetTablePlugin, AddressRange range) {
            this.range = range;
        }

        public boolean applyTo(Program program) {
            program.getListing().clearCodeUnits(this.range.getMinAddress(), this.range.getMaxAddress(), false);
            return true;
        }

        public String getName() {
            return "Clear Code Units";
        }

        public String getStatusMsg() {
            return null;
        }
    }

    private class MyCreateDataCmd
    extends CreateDataCmd {
        private Address dataAddr;
        private Address baseAddr;
        private String msg;
        private boolean signed;

        MyCreateDataCmd(OffsetTablePlugin offsetTablePlugin, Address dataAddr, Address baseAddr, DataType dt, boolean signed) {
            super(dataAddr, dt);
            this.dataAddr = dataAddr;
            this.baseAddr = baseAddr;
            this.signed = signed;
        }

        @Override
        public boolean applyTo(Program program) {
            if (super.applyTo(program)) {
                ReferenceManager refManager = program.getReferenceManager();
                Data data = program.getListing().getDefinedDataAt(this.dataAddr);
                if (data != null) {
                    Scalar value = (Scalar)data.getValue();
                    long offset = this.signed ? value.getSignedValue() : value.getUnsignedValue();
                    try {
                        data.addValueReference(this.baseAddr.add(offset), RefType.DATA);
                    }
                    catch (AddressOutOfBoundsException e) {
                        this.msg = e.getMessage();
                        return false;
                    }
                    Reference primRef = refManager.getPrimaryReferenceFrom(this.dataAddr, 0);
                    if (primRef == null) {
                        Reference[] refs = data.getValueReferences();
                        refManager.setPrimary(refs[0], true);
                    }
                    return true;
                }
                this.msg = "Data does not exist at " + String.valueOf(this.dataAddr);
            }
            return false;
        }

        @Override
        public String getStatusMsg() {
            if (this.msg != null) {
                return this.msg;
            }
            return super.getStatusMsg();
        }
    }
}

