/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.KeyEntryListener;
import docking.KeyEntryTextField;
import docking.actions.KeyBindingUtils;
import docking.actions.ToolActions;
import docking.widgets.label.GLabel;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

class KeyBindingInputDialog
extends DialogComponentProvider
implements KeyEntryListener {
    private KeyEntryTextField kbField;
    private KeyStroke ks;
    private boolean isCancelled;
    private Plugin plugin;

    KeyBindingInputDialog(Component parent, String scriptName, KeyStroke currentKeyStroke, Plugin plugin, HelpLocation help) {
        super("Assign Script Key Binding", true, true, true, false);
        this.plugin = plugin;
        this.kbField = new KeyEntryTextField(20, (KeyEntryListener)this);
        this.kbField.setName("KEY_BINDING");
        this.kbField.setText(currentKeyStroke == null ? "" : KeyBindingUtils.parseKeyStroke((KeyStroke)currentKeyStroke));
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add((Component)new GLabel(scriptName), "North");
        panel.add((Component)this.kbField, "Center");
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(help);
        DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this);
    }

    protected void okCallback() {
        PluginTool tool = this.plugin.getTool();
        ToolActions toolActions = (ToolActions)tool.getToolActions();
        String errorMessage = toolActions.validateActionKeyBinding(null, this.ks);
        if (errorMessage != null) {
            this.setStatusText(errorMessage);
            return;
        }
        this.close();
    }

    protected void cancelCallback() {
        super.cancelCallback();
        this.isCancelled = true;
    }

    boolean isCancelled() {
        return this.isCancelled;
    }

    public void processEntry(KeyStroke keyStroke) {
        this.ks = keyStroke;
    }

    KeyStroke getKeyStroke() {
        return this.ks;
    }

    void setKeyStroke(KeyStroke ks) {
        this.ks = ks;
        this.kbField.setKeyStroke(ks);
    }
}

