/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.string.translate;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import ghidra.app.context.DataLocationListContext;
import ghidra.app.plugin.core.codebrowser.CodeViewerActionContext;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataInstance;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.AssertException;
import java.util.List;

public abstract class AbstractTranslateAction
extends DockingAction {
    protected static String META_GROUP = "Translate_Meta";
    protected static String GROUP = "Translate";
    private MenuData codeViewerMenuData;
    private MenuData dataListMenuData;

    public AbstractTranslateAction(String name, String owner, MenuData codeViewerMenuData, MenuData dataListMenuData) {
        super(name, owner);
        this.codeViewerMenuData = codeViewerMenuData;
        this.dataListMenuData = dataListMenuData;
        this.setPopupMenuData(codeViewerMenuData);
    }

    public boolean isAddToPopup(ActionContext context) {
        return context instanceof DataLocationListContext || this.isEnabledForContext(context);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (context instanceof DataLocationListContext) {
            this.setPopupMenuData(this.dataListMenuData);
            return this.isEnabledForContext((DataLocationListContext)context);
        }
        if (context instanceof CodeViewerActionContext) {
            this.setPopupMenuData(this.codeViewerMenuData);
            return this.isEnabledForContext((CodeViewerActionContext)context);
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        if (context instanceof DataLocationListContext) {
            DataLocationListContext dllc = (DataLocationListContext)context;
            this.actionPerformed(dllc.getProgram(), this.getStringLocations(dllc));
        } else if (context instanceof CodeViewerActionContext) {
            CodeViewerActionContext cvac = (CodeViewerActionContext)context;
            this.actionPerformed(cvac.getProgram(), this.getStringLocations(cvac));
        } else {
            throw new AssertException("This can't happen!");
        }
    }

    private boolean isEnabledForContext(CodeViewerActionContext context) {
        if (context.hasSelection()) {
            return false;
        }
        List<ProgramLocation> dataLocations = this.getStringLocations(context);
        return !dataLocations.isEmpty();
    }

    private boolean isEnabledForContext(DataLocationListContext context) {
        return context.getCount() > 0;
    }

    protected List<ProgramLocation> getStringLocations(CodeViewerActionContext context) {
        Data data = DataUtilities.getDataAtLocation((ProgramLocation)context.getLocation());
        if (data == null || !StringDataInstance.isString((Data)data)) {
            return List.of();
        }
        return List.of(context.getLocation());
    }

    protected List<ProgramLocation> getStringLocations(DataLocationListContext context) {
        return context.getDataLocationList(StringDataInstance::isString);
    }

    protected abstract void actionPerformed(Program var1, List<ProgramLocation> var2);
}

