/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.KeyBindingData;
import docking.action.builder.ActionBuilder;
import ghidra.app.nav.DecoratorPanel;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.SymbolTreeProvider;
import ghidra.app.plugin.core.symboltree.nodes.ConfigurableSymbolTreeRootNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class DisconnectedSymbolTreeProvider
extends SymbolTreeProvider {
    private static final String WINDOW_GROUP = "Disconnected Symbol Tree";

    public DisconnectedSymbolTreeProvider(PluginTool tool, SymbolTreePlugin plugin, Program program) {
        super(tool, plugin);
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.createActions();
        this.goToToggleAction.setEnabled(false);
        this.setHelpLocation(new HelpLocation("SymbolTreePlugin", "Disconnected_Symbol_Tree"));
        this.program = program;
        program.addListener(this.domainObjectListener);
        this.rebuildTree();
    }

    public String getWindowGroup() {
        return WINDOW_GROUP;
    }

    public WindowPosition getDefaultWindowPosition() {
        return WindowPosition.WINDOW;
    }

    public boolean isTransient() {
        return true;
    }

    public boolean isSnapshot() {
        return true;
    }

    protected void addToToolbar() {
    }

    protected void setKeyBinding(KeyBindingData kbData) {
    }

    @Override
    void setProgram(Program newProgram) {
    }

    @Override
    void programDeactivated(Program deactivatedProgram) {
    }

    @Override
    void programClosed(Program closedProgram) {
        this.tree.cancelWork();
        closedProgram.removeListener(this.domainObjectListener);
        this.program = null;
        this.rebuildTree();
        this.closeComponent();
    }

    @Override
    protected JPanel createMainPanel(JComponent contentComponent) {
        return new DecoratorPanel(contentComponent, false);
    }

    @Override
    protected SymbolTreeRootNode createRootNode() {
        return new ConfigurableSymbolTreeRootNode(this.program);
    }

    public void closeComponent() {
        this.plugin.closeDisconnectedProvider(this);
    }

    @Override
    protected void transferSettings(DisconnectedSymbolTreeProvider newProvider) {
        ConfigurableSymbolTreeRootNode myModelRoot = (ConfigurableSymbolTreeRootNode)this.tree.getModelRoot();
        ConfigurableSymbolTreeRootNode newModelRoot = (ConfigurableSymbolTreeRootNode)newProvider.tree.getModelRoot();
        myModelRoot.transferSettings(newModelRoot);
        super.transferSettings(newProvider);
    }

    @Override
    void writeConfigState(SaveState saveState) {
    }

    @Override
    void readConfigState(SaveState saveState) {
    }

    private void createActions() {
        ((ActionBuilder)new ActionBuilder("Enable Category", this.plugin.getName()).popupMenuPath(new String[]{"Enable Category"})).withContext(SymbolTreeActionContext.class).enabledWhen(c -> {
            SymbolTreeNode node = c.getSelectedNode();
            return node instanceof SymbolCategoryNode;
        }).onAction(c -> {
            SymbolCategoryNode node = (SymbolCategoryNode)c.getSelectedNode();
            node.setEnabled(true);
        }).buildAndInstallLocal((ComponentProvider)this);
        ((ActionBuilder)new ActionBuilder("Disable Category", this.plugin.getName()).popupMenuPath(new String[]{"Disable Category"})).withContext(SymbolTreeActionContext.class).enabledWhen(c -> {
            SymbolTreeNode node = c.getSelectedNode();
            return node instanceof SymbolCategoryNode;
        }).onAction(c -> {
            SymbolCategoryNode node = (SymbolCategoryNode)c.getSelectedNode();
            node.setEnabled(false);
        }).buildAndInstallLocal((ComponentProvider)this);
    }
}

