/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.support.GTreeRenderer;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolGTreeDragNDropHandler;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import resources.ResourceManager;

public class SymbolGTree
extends GTree {
    private GTreeNode armedNode;
    private SymbolInspector symbolInspector;

    public SymbolGTree(GTreeNode root, SymbolTreePlugin plugin) {
        super(root);
        this.symbolInspector = new SymbolInspector((ServiceProvider)plugin.getTool(), (Component)((Object)this));
        this.setShowsRootHandles(true);
        this.setCellRenderer(new SymbolTreeCellRenderer());
        this.setDragNDropHandler(new SymbolGTreeDragNDropHandler(plugin));
        this.setAccessibleNamePrefix("Symbol");
        this.setRootNodeAllowedToCollapse(false);
    }

    protected void setFilterRestoreState(GTreeState state) {
        super.setFilterRestoreState(state);
    }

    public void setNodeEditable(GTreeNode node) {
        this.armedNode = node;
    }

    public boolean isPathEditable(TreePath path) {
        boolean isArmed = path.getLastPathComponent() == this.armedNode;
        this.armedNode = null;
        if (isArmed) {
            return super.isPathEditable(path);
        }
        return false;
    }

    public void setProgram(Program program) {
        this.symbolInspector.setProgram(program);
    }

    public void dispose() {
        super.dispose();
        this.symbolInspector.dispose();
    }

    private class SymbolTreeCellRenderer
    extends GTreeRenderer {
        public final Icon OPEN_FOLDER_GROUP_ICON = new GIcon("icon.plugin.symboltree.node.group.folder.open");
        public final Icon CLOSED_FOLDER_GROUP_ICON = new GIcon("icon.plugin.symboltree.node.group.folder.closed");

        public SymbolTreeCellRenderer() {
            this.setMinIconWidth(28);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean isFocused) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, isFocused);
            if (label.getIcon() == null) {
                label.setIcon(expanded ? this.OPEN_FOLDER_GROUP_ICON : this.CLOSED_FOLDER_GROUP_ICON);
            }
            if (!isSelected && value instanceof SymbolNode) {
                SymbolNode node = (SymbolNode)((Object)value);
                Symbol symbol = node.getSymbol();
                Color color = SymbolGTree.this.symbolInspector.getColor(symbol);
                label.setForeground(color);
            }
            return label;
        }

        protected Icon getNodeIcon(GTreeNode node, boolean expanded) {
            SymbolCategoryNode symbolNode;
            Icon icon = super.getNodeIcon(node, expanded);
            if (node instanceof SymbolCategoryNode && !(symbolNode = (SymbolCategoryNode)node).isEnabled()) {
                return ResourceManager.getDisabledIcon((Icon)icon);
            }
            return icon;
        }
    }
}

