/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolTreeRootNode;
import ghidra.program.model.listing.Program;
import java.util.List;

public class ConfigurableSymbolTreeRootNode
extends SymbolTreeRootNode {
    public ConfigurableSymbolTreeRootNode(Program program) {
        super(program);
    }

    public void transferSettings(ConfigurableSymbolTreeRootNode otherRoot) {
        if (!this.isLoaded()) {
            return;
        }
        List myChildren = this.getChildren();
        List otherChildren = otherRoot.getChildren();
        for (GTreeNode node : myChildren) {
            SymbolCategoryNode myCategoryNode = this.getModelNode((SymbolCategoryNode)node);
            SymbolCategoryNode otherCategoryNode = this.getMatchingNode(otherChildren, myCategoryNode);
            otherCategoryNode.setEnabled(myCategoryNode.isEnabled());
        }
    }

    private SymbolCategoryNode getMatchingNode(List<GTreeNode> nodes, SymbolCategoryNode nodeToMatch) {
        for (GTreeNode node : nodes) {
            if (!nodeToMatch.equals(node)) continue;
            return this.getModelNode((SymbolCategoryNode)node);
        }
        return null;
    }

    private SymbolCategoryNode getModelNode(SymbolCategoryNode node) {
        SymbolCategoryNode modelNode;
        GTree gTree = node.getTree();
        if (gTree != null && node != (modelNode = (SymbolCategoryNode)gTree.getModelNode((GTreeNode)node))) {
            return modelNode;
        }
        return node;
    }
}

