/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

class ExportsCategoryNode
extends SymbolCategoryNode {
    private static final Icon OPEN_FOLDER = new GIcon("icon.plugin.symboltree.node.category.exports.open");
    private static final Icon CLOSED_FOLDER = new GIcon("icon.plugin.symboltree.node.category.exports.closed");

    public ExportsCategoryNode(Program program) {
        super(SymbolCategory.EXPORTS_CATEGORY, program);
    }

    @Override
    public List<GTreeNode> generateChildren(TaskMonitor monitor) {
        if (!this.isEnabled) {
            return Collections.emptyList();
        }
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        List<Symbol> functionSymbolList = this.getExportSymbols();
        for (Symbol symbol : functionSymbolList) {
            list.add((GTreeNode)SymbolNode.createNode(symbol, this.program));
        }
        Collections.sort(list, this.getChildrenComparator());
        return list;
    }

    private List<Symbol> getExportSymbols() {
        ArrayList<Symbol> symbols = new ArrayList<Symbol>();
        AddressIterator iterator = this.symbolTable.getExternalEntryPointIterator();
        while (iterator.hasNext()) {
            Symbol symbol = this.symbolTable.getPrimarySymbol(iterator.next());
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER : CLOSED_FOLDER;
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        if (!symbol.isPrimary()) {
            return false;
        }
        return symbol.isExternalEntryPoint() || symbol.getParentSymbol().isExternalEntryPoint();
    }
}

