/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import ghidra.app.util.SymbolInspector;
import ghidra.program.model.address.Address;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableNameFieldLocation;
import ghidra.util.table.GhidraTableCellRenderer;
import java.awt.Color;
import java.awt.Component;

public class SymbolRenderer
extends GhidraTableCellRenderer {
    private SymbolInspector inspector;

    public void setSymbolInspector(SymbolInspector inspector) {
        this.inspector = inspector;
    }

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        int column = data.getColumnModelIndex();
        boolean isSelected = data.isSelected();
        if (value == null && column == 0) {
            this.setText("<< REMOVED >>");
        } else if (value instanceof Symbol) {
            this.handleSymbol(value, isSelected);
        } else if (value instanceof Address) {
            this.setText(this.getAddressString((Address)value));
        } else if (value instanceof ProgramLocation) {
            this.setText(this.getLocationString((ProgramLocation)value));
        }
        return this;
    }

    private String getLocationString(ProgramLocation location) {
        if (location instanceof VariableNameFieldLocation) {
            VariableNameFieldLocation varLoc = (VariableNameFieldLocation)location;
            Variable variable = varLoc.getVariable();
            return variable.getVariableStorage().toString();
        }
        return this.getAddressString(location.getAddress());
    }

    private void handleSymbol(Object value, boolean isSelected) {
        GColor color;
        this.setBold();
        Object object = color = this.inspector != null && value instanceof Symbol ? this.inspector.getColor((Symbol)value) : GThemeDefaults.Colors.FOREGROUND;
        if (!isSelected) {
            this.setForeground((Color)color);
        }
    }

    private String getAddressString(Address address) {
        if (address.isStackAddress()) {
            return this.getStackAddressString(address);
        }
        if (address.isRegisterAddress()) {
            return this.getRegisterAddressString(address);
        }
        if (address.isExternalAddress() || address == Address.NO_ADDRESS) {
            return "";
        }
        return address.toString();
    }

    private String getRegisterAddressString(Address address) {
        Register register;
        Program program = this.inspector.getProgram();
        if (program != null && (register = program.getRegister(address)) != null) {
            return register.toString();
        }
        return "";
    }

    private String getStackAddressString(Address address) {
        long offset = address.getOffset();
        if (offset < 0L) {
            return "Stack[-0x" + Long.toHexString(-offset) + "]";
        }
        return "Stack[0x" + Long.toHexString(offset) + "]";
    }
}

