/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.core.symboltree.actions.ClearPinSymbolAction;
import ghidra.app.plugin.core.symboltree.actions.CreateSymbolTableAction;
import ghidra.app.plugin.core.symboltree.actions.EditExternalLocationAction;
import ghidra.app.plugin.core.symboltree.actions.PinSymbolAction;
import ghidra.app.plugin.core.symtable.ReferenceProvider;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.services.BlockModelService;
import ghidra.app.services.GoToService;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.DomainObjectListenerBuilder;
import ghidra.framework.model.EventType;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramEvent;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import ghidra.util.worker.Worker;
import java.awt.Component;
import java.awt.Cursor;
import javax.swing.Icon;
import resources.Icons;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Show Symbols in Symbol Table", description="This plugin shows the symbols in the symbol table, provides navigation to the symbols in the Code Browser, and allows symbols to be renamed and deleted. This plugin also shows references to a symbol. Filters can be set to show subsets of the symbols.", servicesRequired={GoToService.class, BlockModelService.class}, eventsProduced={ProgramLocationPluginEvent.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class SymbolTablePlugin
extends Plugin {
    static final Cursor WAIT_CURSOR = new Cursor(3);
    static final Cursor NORM_CURSOR = new Cursor(0);
    private DockingAction openRefsAction;
    private DockingAction deleteAction;
    private DockingAction makeSelectionAction;
    private DockingAction setFilterAction;
    private ToggleDockingAction referencesToAction;
    private ToggleDockingAction instructionsFromAction;
    private ToggleDockingAction dataFromAction;
    private SymbolProvider symProvider;
    private ReferenceProvider refProvider;
    private SymbolInspector inspector;
    private Program currentProgram;
    private GoToService gotoService;
    private BlockModelService blockModelService;
    private SwingUpdateManager swingMgr;
    private DomainObjectListener domainObjectListener = this.createDomainObjectListener();
    private Worker domainObjectWorker = Worker.createGuiWorker();

    public SymbolTablePlugin(PluginTool tool) {
        super(tool);
        this.swingMgr = new SwingUpdateManager(1000, () -> {
            this.symProvider.getComponent().repaint();
            this.refProvider.getComponent().repaint();
        });
    }

    protected void init() {
        this.gotoService = (GoToService)this.tool.getService(GoToService.class);
        this.blockModelService = (BlockModelService)this.tool.getService(BlockModelService.class);
        this.symProvider = new SymbolProvider(this);
        this.refProvider = new ReferenceProvider(this);
        this.createSymActions();
        this.createRefActions();
        this.inspector = new SymbolInspector((ServiceProvider)this.getTool(), (Component)this.symProvider.getComponent());
    }

    public void dispose() {
        super.dispose();
        this.swingMgr.dispose();
        this.deleteAction.dispose();
        this.makeSelectionAction.dispose();
        this.domainObjectWorker.dispose();
        if (this.symProvider != null) {
            this.symProvider.dispose();
            this.symProvider = null;
        }
        if (this.refProvider != null) {
            this.refProvider.dispose();
            this.refProvider = null;
        }
        if (this.currentProgram != null) {
            this.currentProgram.removeListener(this.domainObjectListener);
            this.currentProgram = null;
        }
        this.gotoService = null;
        this.blockModelService = null;
        if (this.inspector != null) {
            this.inspector.dispose();
            this.inspector = null;
        }
    }

    public void readConfigState(SaveState saveState) {
        this.symProvider.readConfigState(saveState);
    }

    public void writeConfigState(SaveState saveState) {
        this.symProvider.writeConfigState(saveState);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent progEvent = (ProgramActivatedPluginEvent)event;
            Program oldProg = this.currentProgram;
            Program newProg = progEvent.getActiveProgram();
            if (oldProg != null) {
                this.inspector.setProgram(null);
                oldProg.removeListener(this.domainObjectListener);
                this.domainObjectWorker.clearAllJobs();
                this.symProvider.setProgram(null, this.inspector);
                this.refProvider.setProgram(null, this.inspector);
                this.tool.contextChanged((ComponentProvider)this.symProvider);
            }
            this.currentProgram = newProg;
            if (newProg != null) {
                this.currentProgram.addListener(this.domainObjectListener);
                this.inspector.setProgram(this.currentProgram);
                this.symProvider.setProgram(this.currentProgram, this.inspector);
                this.refProvider.setProgram(this.currentProgram, this.inspector);
            }
            this.tool.contextChanged((ComponentProvider)this.symProvider);
        }
    }

    boolean isBusy() {
        return this.domainObjectWorker.isBusy() || this.symProvider.isBusy() || this.refProvider.isBusy();
    }

    private void reload() {
        this.domainObjectWorker.clearAllJobs();
        this.symProvider.reload();
        this.refProvider.reload();
    }

    private DomainObjectListener createDomainObjectListener() {
        return ((DomainObjectListenerBuilder)((DomainObjectListenerBuilder)new DomainObjectListenerBuilder((Object)this).ignoreWhen(() -> !this.symProvider.isVisible() && !this.refProvider.isVisible())).any(new EventType[]{DomainObjectEvent.RESTORED, ProgramEvent.MEMORY_BLOCK_ADDED, ProgramEvent.MEMORY_BLOCK_REMOVED}).terminate(this::reload)).with(ProgramChangeRecord.class).each(new EventType[]{ProgramEvent.CODE_ADDED, ProgramEvent.CODE_REMOVED}).call(this::codeAddedRemoved).each(new EventType[]{ProgramEvent.SYMBOL_ADDED}).call(this::symbolAdded).each(new EventType[]{ProgramEvent.SYMBOL_REMOVED}).call(this::symbolRemoved).each(new EventType[]{ProgramEvent.SYMBOL_RENAMED, ProgramEvent.SYMBOL_SCOPE_CHANGED, ProgramEvent.SYMBOL_DATA_CHANGED}).call(this::symbolChanged).each(new EventType[]{ProgramEvent.SYMBOL_SOURCE_CHANGED}).call(this::symbolSourceChanged).each(new EventType[]{ProgramEvent.SYMBOL_PRIMARY_STATE_CHANGED}).call(this::symbolPrimaryStateChanged).each(new EventType[]{ProgramEvent.REFERENCE_ADDED}).call(this::referenceAdded).each(new EventType[]{ProgramEvent.REFERENCE_REMOVED}).call(this::referenceRemoved).each(new EventType[]{ProgramEvent.EXTERNAL_ENTRY_ADDED, ProgramEvent.EXTERNAL_ENTRY_REMOVED}).call(this::extenalEntryAddedRemoved).build();
    }

    private void codeAddedRemoved(ProgramChangeRecord rec) {
        if (rec.getNewValue() instanceof Data) {
            this.domainObjectWorker.schedule((Job)new CodeAddedRemoveJob(this.currentProgram, rec.getStart()));
        }
    }

    private void symbolAdded(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getNewValue();
        this.domainObjectWorker.schedule((Job)new SymbolAddedJob(this.currentProgram, symbol));
    }

    private void symbolRemoved(ProgramChangeRecord rec) {
        Address removeAddr = rec.getStart();
        Long symbolID = (Long)rec.getNewValue();
        this.domainObjectWorker.schedule((Job)new SymbolRemovedJob(this.currentProgram, removeAddr, symbolID));
    }

    private void symbolChanged(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getObject();
        this.domainObjectWorker.schedule((Job)new SymbolChangedJob(this.currentProgram, symbol));
    }

    private void symbolSourceChanged(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getObject();
        this.domainObjectWorker.schedule((Job)new SymbolSourceChangedJob(this.currentProgram, symbol));
    }

    private void symbolPrimaryStateChanged(ProgramChangeRecord rec) {
        Symbol symbol = (Symbol)rec.getNewValue();
        Symbol oldPrimarySymbol = (Symbol)rec.getOldValue();
        this.domainObjectWorker.schedule((Job)new SymbolSetAsPrimaryJob(this.currentProgram, symbol, oldPrimarySymbol));
    }

    private void referenceAdded(ProgramChangeRecord rec) {
        Reference ref = (Reference)rec.getObject();
        this.domainObjectWorker.schedule((Job)new ReferenceAddedJob(this.currentProgram, ref));
    }

    private void referenceRemoved(ProgramChangeRecord rec) {
        Reference ref = (Reference)rec.getObject();
        this.domainObjectWorker.schedule((Job)new ReferenceRemovedJob(this.currentProgram, ref));
    }

    private void extenalEntryAddedRemoved(ProgramChangeRecord rec) {
        Address address = rec.getStart();
        this.domainObjectWorker.schedule((Job)new ExternalEntryChangedJob(this.currentProgram, address));
    }

    Program getProgram() {
        return this.currentProgram;
    }

    BlockModelService getBlockModelService() {
        return this.blockModelService;
    }

    GoToService getGoToService() {
        return this.gotoService;
    }

    SymbolProvider getSymbolProvider() {
        return this.symProvider;
    }

    ReferenceProvider getReferenceProvider() {
        return this.refProvider;
    }

    void openSymbolProvider() {
        if (this.symProvider != null) {
            this.symProvider.open();
        }
    }

    void symbolProviderClosed() {
        this.domainObjectWorker.clearAllJobs();
        if (this.refProvider != null) {
            this.refProvider.closeComponent();
        }
    }

    private void createSymActions() {
        String popupGroup = "1";
        this.openRefsAction = new DockingAction("Symbol References", this.getName(), KeyBindingType.SHARED){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.refProvider.open();
                SymbolTablePlugin.this.refProvider.setCurrentSymbol(SymbolTablePlugin.this.symProvider.getCurrentSymbol());
            }
        };
        Object icon = new GIcon("icon.plugin.symboltable.referencetable.provider");
        this.openRefsAction.setPopupMenuData(new MenuData(new String[]{"Symbol References"}, (Icon)icon, popupGroup));
        this.openRefsAction.setToolBarData(new ToolBarData((Icon)icon));
        this.openRefsAction.setDescription("Display Symbol References");
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.openRefsAction);
        this.deleteAction = new DockingAction("Delete Symbols", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.symProvider.deleteSymbols();
            }

            public boolean isEnabledForContext(ActionContext context) {
                GhidraTable table = SymbolTablePlugin.this.symProvider.getTable();
                return table.getSelectedRowCount() > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                return true;
            }
        };
        icon = Icons.DELETE_ICON;
        String deleteGroup = "3";
        this.deleteAction.setPopupMenuData(new MenuData(new String[]{"Delete"}, (Icon)icon, deleteGroup));
        this.deleteAction.setToolBarData(new ToolBarData((Icon)icon));
        this.deleteAction.setKeyBindingData(new KeyBindingData(127, 0));
        this.deleteAction.setDescription("Delete Selected Symbols");
        this.deleteAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.deleteAction);
        EditExternalLocationAction editExternalLocationAction = new EditExternalLocationAction(this);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)editExternalLocationAction);
        this.makeSelectionAction = new MakeProgramSelectionAction(this, this.symProvider.getTable());
        this.makeSelectionAction.getPopupMenuData().setMenuGroup(popupGroup);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.makeSelectionAction);
        this.setFilterAction = new DockingAction("Set Filter", this.getName()){

            public void actionPerformed(ActionContext context) {
                SymbolTablePlugin.this.symProvider.setFilter();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return SymbolTablePlugin.this.currentProgram != null;
            }
        };
        icon = Icons.CONFIGURE_FILTER_ICON;
        this.setFilterAction.setToolBarData(new ToolBarData((Icon)icon));
        this.setFilterAction.setDescription("Configure Symbol Filter");
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)this.setFilterAction);
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this, this.symProvider.getTable()){

            @Override
            protected void toggleSelectionListening(boolean listen) {
                super.toggleSelectionListening(listen);
                SymbolTablePlugin.this.refProvider.getTable().setNavigateOnSelectionEnabled(listen);
            }
        };
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)selectionNavigationAction);
        String pinnedPopupGroup = "2";
        PinSymbolAction setPinnedAction = new PinSymbolAction(this.getName(), pinnedPopupGroup);
        this.tool.addAction((DockingActionIf)setPinnedAction);
        ClearPinSymbolAction clearPinnedAction = new ClearPinSymbolAction(this.getName(), pinnedPopupGroup);
        this.tool.addAction((DockingActionIf)clearPinnedAction);
        CreateSymbolTableAction tableAction = new CreateSymbolTableAction(this);
        tableAction.getPopupMenuData().setMenuGroup(popupGroup);
        this.tool.addLocalAction((ComponentProvider)this.symProvider, (DockingActionIf)tableAction);
    }

    private void createRefActions() {
        this.referencesToAction = new ToggleDockingAction("References To", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.referencesToAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showReferencesTo();
                    SymbolTablePlugin.this.referencesToAction.setSelected(true);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(false);
                    SymbolTablePlugin.this.dataFromAction.setSelected(false);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.referencesToAction);
                }
            }
        };
        this.referencesToAction.setDescription("References To");
        this.referencesToAction.setSelected(true);
        this.referencesToAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.symboltable.references.to"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.referencesToAction);
        this.instructionsFromAction = new ToggleDockingAction("Instruction References From", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.instructionsFromAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showInstructionsFrom();
                    SymbolTablePlugin.this.referencesToAction.setSelected(false);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(true);
                    SymbolTablePlugin.this.dataFromAction.setSelected(false);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.instructionsFromAction);
                }
            }
        };
        this.instructionsFromAction.setDescription("Instructions From");
        this.instructionsFromAction.setSelected(false);
        this.instructionsFromAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.symboltable.instructions.from"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.instructionsFromAction);
        this.dataFromAction = new ToggleDockingAction("Data References From", this.getName()){

            public void actionPerformed(ActionContext context) {
                if (SymbolTablePlugin.this.dataFromAction.isSelected()) {
                    SymbolTablePlugin.this.refProvider.showDataFrom();
                    SymbolTablePlugin.this.referencesToAction.setSelected(false);
                    SymbolTablePlugin.this.instructionsFromAction.setSelected(false);
                    SymbolTablePlugin.this.dataFromAction.setSelected(true);
                } else {
                    SymbolTablePlugin.this.reselectAction(SymbolTablePlugin.this.dataFromAction);
                }
            }
        };
        this.dataFromAction.setDescription("Data From");
        this.dataFromAction.setSelected(false);
        this.dataFromAction.setToolBarData(new ToolBarData((Icon)new GIcon("icon.plugin.symboltable.data.from"), null));
        this.tool.addLocalAction((ComponentProvider)this.refProvider, (DockingActionIf)this.dataFromAction);
    }

    private void reselectAction(ToggleDockingAction action) {
        action.setSelected(false);
        action.setSelected(true);
    }

    private class CodeAddedRemoveJob
    extends AbstractSymbolUpdateJob {
        private Address start;

        CodeAddedRemoveJob(Program program, Address start) {
            super(program);
            this.start = start;
        }

        @Override
        protected void doRun() {
            if (!SymbolTablePlugin.this.symProvider.isShowingDynamicSymbols()) {
                return;
            }
            SymbolTable symbolTable = SymbolTablePlugin.this.currentProgram.getSymbolTable();
            Symbol symbol = symbolTable.getPrimarySymbol(this.start);
            if (symbol != null && symbol.isDynamic()) {
                SymbolTablePlugin.this.symProvider.symbolChanged(symbol);
                SymbolTablePlugin.this.refProvider.symbolChanged(symbol);
            }
        }
    }

    private class SymbolAddedJob
    extends AbstractSymbolUpdateJob {
        private Symbol symbol;

        SymbolAddedJob(Program program, Symbol symbol) {
            super(program);
            this.symbol = symbol;
        }

        @Override
        protected void doRun() {
            SymbolTablePlugin.this.symProvider.symbolAdded(this.symbol);
            SymbolTablePlugin.this.refProvider.symbolAdded(this.symbol);
        }
    }

    private class SymbolRemovedJob
    extends AbstractSymbolUpdateJob {
        private long symbolId;
        private Address address;

        SymbolRemovedJob(Program program, Address address, long symbolId) {
            super(program);
            this.address = address;
            this.symbolId = symbolId;
        }

        @Override
        protected void doRun() {
            SymbolTablePlugin.this.symProvider.symbolRemoved(this.symbolId);
            SymbolTablePlugin.this.refProvider.symbolRemoved(this.symbolId);
            if (!SymbolTablePlugin.this.symProvider.isShowingDynamicSymbols()) {
                return;
            }
            SymbolTable symbolTable = SymbolTablePlugin.this.currentProgram.getSymbolTable();
            Symbol primaryAtRemove = symbolTable.getPrimarySymbol(this.address);
            if (primaryAtRemove != null && primaryAtRemove.isDynamic()) {
                SymbolTablePlugin.this.symProvider.symbolChanged(primaryAtRemove);
                SymbolTablePlugin.this.refProvider.symbolChanged(primaryAtRemove);
            }
        }
    }

    private class SymbolChangedJob
    extends AbstractSymbolUpdateJob {
        private Symbol symbol;

        SymbolChangedJob(Program program, Symbol symbol) {
            super(program);
            this.symbol = symbol;
        }

        @Override
        protected void doRun() {
            SymbolTablePlugin.this.symProvider.symbolChanged(this.symbol);
            SymbolTablePlugin.this.refProvider.symbolChanged(this.symbol);
        }
    }

    private class SymbolSourceChangedJob
    extends AbstractSymbolUpdateJob {
        private Symbol symbol;

        SymbolSourceChangedJob(Program program, Symbol symbol) {
            super(program);
            this.symbol = symbol;
        }

        @Override
        protected void doRun() {
            SymbolTablePlugin.this.symProvider.symbolChanged(this.symbol);
        }
    }

    private class SymbolSetAsPrimaryJob
    extends AbstractSymbolUpdateJob {
        private Symbol symbol;
        private Symbol oldPrimarySymbol;

        SymbolSetAsPrimaryJob(Program program, Symbol symbol, Symbol oldPrimarySymbol) {
            super(program);
            this.symbol = symbol;
            this.oldPrimarySymbol = oldPrimarySymbol;
        }

        @Override
        protected void doRun() {
            SymbolTablePlugin.this.symProvider.symbolChanged(this.symbol);
            if (this.oldPrimarySymbol != null) {
                SymbolTablePlugin.this.symProvider.symbolChanged(this.oldPrimarySymbol);
            }
        }
    }

    private class ReferenceAddedJob
    extends AbstractSymbolUpdateJob {
        private Reference reference;

        ReferenceAddedJob(Program program, Reference reference) {
            super(program);
            this.reference = reference;
        }

        @Override
        protected void doRun() {
            boolean isValid;
            Address toAddr = this.reference.getToAddress();
            boolean bl = isValid = toAddr.isMemoryAddress() || toAddr.isExternalAddress();
            if (!isValid) {
                return;
            }
            SymbolTable symbolTable = this.program.getSymbolTable();
            Symbol symbol = symbolTable.getSymbol(this.reference);
            if (symbol == null) {
                return;
            }
            if (!symbol.isDynamic() || SymbolTablePlugin.this.symProvider.isShowingDynamicSymbols()) {
                SymbolTablePlugin.this.symProvider.symbolChanged(symbol);
                SymbolTablePlugin.this.refProvider.symbolChanged(symbol);
            }
        }
    }

    private class ReferenceRemovedJob
    extends AbstractSymbolUpdateJob {
        private Reference reference;

        ReferenceRemovedJob(Program program, Reference reference) {
            super(program);
            this.reference = reference;
        }

        @Override
        protected void doRun() {
            boolean isValid;
            Address toAddr = this.reference.getToAddress();
            boolean bl = isValid = toAddr.isMemoryAddress() || toAddr.isExternalAddress();
            if (!isValid) {
                return;
            }
            SymbolTable symbolTable = this.program.getSymbolTable();
            Symbol symbol = symbolTable.getSymbol(this.reference);
            if (symbol != null) {
                if (!symbol.isDynamic() || SymbolTablePlugin.this.symProvider.isShowingDynamicSymbols()) {
                    SymbolTablePlugin.this.symProvider.symbolChanged(symbol);
                    SymbolTablePlugin.this.refProvider.symbolChanged(symbol);
                }
            } else if (toAddr.isMemoryAddress() && SymbolTablePlugin.this.symProvider.isShowingDynamicSymbols()) {
                long dynamicSymbolId = symbolTable.getDynamicSymbolID(toAddr);
                SymbolTablePlugin.this.symProvider.symbolRemoved(dynamicSymbolId);
                SymbolTablePlugin.this.refProvider.symbolRemoved(dynamicSymbolId);
            }
        }
    }

    private class ExternalEntryChangedJob
    extends AbstractSymbolUpdateJob {
        private Address address;

        ExternalEntryChangedJob(Program program, Address address) {
            super(program);
            this.address = address;
        }

        @Override
        protected void doRun() {
            Symbol[] symbols;
            SymbolTable symbolTable = this.program.getSymbolTable();
            for (Symbol element : symbols = symbolTable.getSymbols(this.address)) {
                SymbolTablePlugin.this.symProvider.symbolChanged(element);
                SymbolTablePlugin.this.refProvider.symbolChanged(element);
            }
        }
    }

    private abstract class AbstractSymbolUpdateJob
    extends Job {
        protected Program program;

        AbstractSymbolUpdateJob(Program program) {
            this.program = program;
        }

        public final void run(TaskMonitor taskMonitor) {
            if (this.program != SymbolTablePlugin.this.currentProgram) {
                return;
            }
            this.doRun();
        }

        protected abstract void doRun();
    }
}

