/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import docking.ActionContext;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import resources.Icons;

public class DomainEventComponentProvider
extends ComponentProviderAdapter {
    static final int LIMIT = 200;
    private static final Icon ICON = new GIcon("icon.plugin.debug.domaineventviewer.provider");
    private JTextArea textArea;
    private JScrollPane scrollPane;
    private DockingAction clearAction;
    private List<String> eventList = new ArrayList<String>();

    public DomainEventComponentProvider(PluginTool tool, String name) {
        super(tool, name, name);
        this.textArea = new JTextArea(10, 80);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.createAction();
        this.setIcon(ICON);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setTitle("Domain Object Event Display");
        this.setVisible(true);
    }

    public JComponent getComponent() {
        return this.scrollPane;
    }

    public void componentHidden() {
        this.clear();
    }

    private void createAction() {
        this.clearAction = new DockingAction("Clear Display", this.getName()){

            public void actionPerformed(ActionContext context) {
                DomainEventComponentProvider.this.clear();
            }
        };
        this.clearAction.markHelpUnnecessary();
        this.clearAction.setEnabled(true);
        Icon icon = Icons.CLEAR_ICON;
        this.clearAction.setToolBarData(new ToolBarData(icon));
        this.addLocalAction((DockingActionIf)this.clearAction);
    }

    private void clear() {
        this.textArea.setText("");
        this.eventList.clear();
    }

    void displayEvent(String eventStr) {
        this.eventList.add(eventStr);
        if (this.eventList.size() < 200) {
            int caretPos = this.textArea.getCaretPosition();
            this.textArea.append(eventStr);
            this.textArea.setCaretPosition(caretPos + eventStr.length());
        } else {
            if (this.eventList.size() > 200) {
                List<String> list = this.eventList.subList(100, this.eventList.size() - 1);
                this.eventList = new ArrayList<String>(list);
            }
            this.textArea.setText("");
            int length = 0;
            for (String str : this.eventList) {
                this.textArea.append(str);
                length += str.length();
            }
            this.textArea.setCaretPosition(length);
        }
    }
}

