/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.debug;

import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.debug.DomainEventComponentProvider;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.listing.Program;
import help.Help;
import help.HelpService;
import java.util.Date;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Developer", category="Diagnostic", shortDescription="Displays domain object events", description="This plugin provides a component to display domain object event as they are generated. The maximum number of messages shown is 200.  Useful for debugging.", eventsConsumed={ProgramActivatedPluginEvent.class})
public class DomainEventDisplayPlugin
extends Plugin
implements DomainObjectListener {
    private Program currentProgram;
    private DomainEventComponentProvider provider;

    public DomainEventDisplayPlugin(PluginTool tool) {
        super(tool);
        this.provider = new DomainEventComponentProvider(tool, this.getName());
        HelpService helpService = Help.getHelpService();
        helpService.excludeFromHelp((Object)this.provider);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent ev = (ProgramActivatedPluginEvent)event;
            Program newProg = ev.getActiveProgram();
            if (this.currentProgram != null) {
                this.currentProgram.removeListener((DomainObjectListener)this);
            }
            if (newProg != null) {
                newProg.addListener((DomainObjectListener)this);
            }
        }
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.tool != null && this.provider.isVisible()) {
            this.outputEvent(ev);
        }
    }

    private void outputEvent(DomainObjectChangedEvent event) {
        for (int i = 0; i < event.numRecords(); ++i) {
            DomainObjectChangeRecord changeRecord = event.getChangeRecord(i);
            String dateStr = String.valueOf(new Date()) + ": ";
            this.provider.displayEvent(dateStr + String.valueOf(changeRecord) + "\n");
        }
    }
}

