/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateArrayCmd;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecodeContext;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfDecoderFactory;
import ghidra.app.plugin.exceptionhandlers.gcc.DwarfEHDecoder;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisClass;
import ghidra.app.plugin.exceptionhandlers.gcc.GccAnalysisUtils;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.sections.CieSource;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.Cie;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame.ExceptionHandlerFrameException;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDATable;
import ghidra.app.util.bin.LEB128Info;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.QWordDataType;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.program.model.data.WordDataType;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;

public class FrameDescriptionEntry
extends GccAnalysisClass {
    private static final int DWORD_LEN = DWordDataType.dataType.getLength();
    private static final int QWORD_LEN = QWordDataType.dataType.getLength();
    private static final int BYTE_LEN = ByteDataType.dataType.getLength();
    private byte[] augmentationData;
    private byte[] augmentationDataEx;
    private byte[] callFrameInstructions;
    private boolean hasExtLength = false;
    private boolean endOfFrame = false;
    private int intLength;
    private int intPtr;
    private int intAugmentationDataLength = 0;
    private int intAugmentationDataExLength = 0;
    private int intPcRange;
    private int curSize;
    private CieSource cieSource;
    private Cie cie;
    private Address baseAddress;
    private String cieAugmentationString;
    private Address nextAddress;
    private Address pcBeginAddr = Address.NO_ADDRESS;
    private Address pcEndAddr = Address.NO_ADDRESS;
    private Address augmentationDataAddr = Address.NO_ADDRESS;
    private Address augmentationDataExAddr = Address.NO_ADDRESS;

    public FrameDescriptionEntry(TaskMonitor monitor, Program program, CieSource cieSource) {
        super(monitor, program);
        this.cieSource = cieSource;
        this.curSize = 0;
        this.intPtr = 0;
        this.intPcRange = 0;
        super.init(program);
    }

    private int getPointerDecodeSize(Program theProgram) {
        AddressSpace defaultAddressSpace = theProgram.getAddressFactory().getDefaultAddressSpace();
        Address maxAddress = defaultAddressSpace.getMaxAddress();
        int pointerSize = maxAddress.getPointerSize();
        switch (pointerSize) {
            case 3: {
                return 4;
            }
            case 5: 
            case 6: 
            case 7: {
                return 8;
            }
        }
        return pointerSize;
    }

    private DataType getAddressSizeDataType() {
        int pointerDecodeSize = this.getPointerDecodeSize(this.program);
        switch (pointerDecodeSize) {
            case 2: {
                return new WordDataType();
            }
            case 4: {
                return new DWordDataType();
            }
            case 8: {
                return new QWordDataType();
            }
        }
        throw new IllegalArgumentException("Unhandled pointer size -- " + pointerDecodeSize + " bytes");
    }

    private Address createFdeLength(Address addr) throws MemoryAccessException {
        String comment = "(FDE) Length";
        FrameDescriptionEntry.createAndCommentData(this.program, addr, (DataType)this.dwordDT, comment, 0);
        this.intLength = this.program.getMemory().getInt(addr);
        return addr.add((long)DWORD_LEN);
    }

    private Address createCiePointer(Address addr) throws MemoryAccessException, ExceptionHandlerFrameException {
        String comment = "(FDE) CIE Reference Pointer ";
        DWordDataType locType = new DWordDataType();
        int locTypeSize = locType.getLength();
        FrameDescriptionEntry.createAndCommentData(this.program, addr, (DataType)locType, comment, 0);
        this.intPtr = (int)GccAnalysisUtils.readDWord(this.program, addr);
        Address cieAddr = Address.NO_ADDRESS;
        if (this.isInDebugFrame(addr)) {
            if (this.intPtr == -1) {
                throw new ExceptionHandlerFrameException("Invalid CIE Reference Pointer (0x" + Integer.toHexString(this.intPtr) + ")");
            }
            cieAddr = addr.getNewAddress((long)this.intPtr);
        } else {
            if (this.intPtr == 0) {
                throw new ExceptionHandlerFrameException("Invalid CIE Reference Pointer (0x" + Integer.toHexString(this.intPtr) + ")");
            }
            cieAddr = addr.subtract((long)this.intPtr);
        }
        this.cie = this.cieSource.getCie(cieAddr);
        this.curSize += locTypeSize;
        this.program.getReferenceManager().addMemoryReference(addr, cieAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        return addr.add((long)locTypeSize);
    }

    private boolean isInDebugFrame(Address addr) {
        Memory memory = this.program.getMemory();
        MemoryBlock block = memory.getBlock(addr);
        return ".debug_frame".equals(block.getName());
    }

    private Address createPcBegin(Address addr, RegionDescriptor region) throws MemoryAccessException, ExceptionHandlerFrameException {
        String comment = "(FDE) PcBegin";
        DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, addr, region.getEHMemoryBlock().getStart());
        this.pcBeginAddr = this.cie.getFDEDecoder().decodeAddress(ctx);
        int encodedLen = ctx.getEncodedLength();
        DataType encodedDt = this.cie.getFDEDecoder().getDataType(this.program);
        FrameDescriptionEntry.createAndCommentData(this.program, addr, encodedDt, comment, 0);
        if (this.pcBeginAddr.getOffset() != 0L) {
            this.program.getReferenceManager().addMemoryReference(addr, this.pcBeginAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        }
        this.curSize += encodedLen;
        return addr.add((long)encodedLen);
    }

    private Address createPcRange(Address addr) throws ExceptionHandlerFrameException, MemoryAccessException {
        int next;
        String comment = "(FDE) PcRange";
        DataType dataType = this.getAddressSizeDataType();
        byte[] range = new byte[dataType.getLength()];
        GccAnalysisUtils.readBytes(this.program, addr, range);
        DataConverter converter = DataConverter.getInstance((boolean)this.program.getMemory().isBigEndian());
        this.intPcRange = (int)converter.getSignedValue(range, range.length);
        if (this.intPcRange < 0) {
            return null;
        }
        if (this.intPcRange == 0) {
            this.intPcRange = 1;
        }
        this.pcEndAddr = this.pcBeginAddr.add((long)(this.intPcRange - 1));
        if (dataType.getLength() == 8 && (next = (int)GccAnalysisUtils.readDWord(this.program, addr.add(4L))) != 0) {
            dataType = DWordDataType.dataType;
        }
        int dtLength = dataType.getLength();
        FrameDescriptionEntry.createAndCommentData(this.program, addr, dataType, comment, 0);
        this.curSize += dtLength;
        try {
            Address nextAddr = addr.add((long)dtLength);
            return nextAddr;
        }
        catch (AddressOutOfBoundsException e) {
            return null;
        }
    }

    private Address createAugmentationDataLength(Address addr) throws MemoryAccessException {
        String comment = "(FDE) Augmentation Data Length";
        LEB128Info uleb128 = GccAnalysisUtils.readULEB128Info(this.program, addr);
        this.intAugmentationDataLength = (int)uleb128.asLong();
        FrameDescriptionEntry.createAndCommentData(this.program, addr, (DataType)UnsignedLeb128DataType.dataType, comment, 0);
        this.curSize += uleb128.getLength();
        return addr.add((long)uleb128.getLength());
    }

    private Address createAugmentationData(Address addr) throws MemoryAccessException {
        SetCommentCmd.createComment(this.program, addr, "(FDE) Augmentation Data", 0);
        this.augmentationData = new byte[this.intAugmentationDataLength];
        this.program.getMemory().getBytes(addr, this.augmentationData);
        this.curSize += this.intAugmentationDataLength;
        return addr.add((long)this.intAugmentationDataLength);
    }

    private Address createCallFrameInstructions(Address addr) throws MemoryAccessException {
        int instructionLength = this.intLength - this.curSize;
        ArrayDataType adt = new ArrayDataType((DataType)ByteDataType.dataType, instructionLength, BYTE_LEN);
        try {
            this.program.getListing().createData(addr, (DataType)adt, adt.getLength());
        }
        catch (CodeUnitInsertionException e) {
            CreateDataCmd dataCmd = new CreateDataCmd(addr, (DataType)adt);
            dataCmd.applyTo(this.program);
        }
        SetCommentCmd.createComment(this.program, addr, "(FDE) Call Frame Instructions", 0);
        this.callFrameInstructions = new byte[instructionLength];
        this.program.getMemory().getBytes(addr, this.callFrameInstructions);
        this.curSize += instructionLength;
        try {
            return addr.add((long)instructionLength);
        }
        catch (AddressOutOfBoundsException aoobe) {
            return addr.add((long)(instructionLength - 1));
        }
    }

    public RegionDescriptor create(Address fdeBaseAddress) throws MemoryAccessException, ExceptionHandlerFrameException {
        if (fdeBaseAddress == null || this.monitor.isCancelled()) {
            return null;
        }
        Address addr = fdeBaseAddress;
        this.baseAddress = fdeBaseAddress;
        MemoryBlock ehblock = this.program.getMemory().getBlock(addr);
        RegionDescriptor region = new RegionDescriptor(ehblock);
        if (this.program.getMemory().getInt(addr) == 0) {
            this.markEndOfFrame(addr);
            this.endOfFrame = true;
            return null;
        }
        addr = this.createFdeLength(addr);
        addr = this.createExtendedLength(addr);
        addr = this.createCiePointer(addr);
        addr = this.createPcBegin(addr, region);
        addr = this.createPcRange(addr);
        AddressRangeImpl addrRange = new AddressRangeImpl(this.pcBeginAddr, this.pcEndAddr);
        region.setIPRange((AddressRange)addrRange);
        try {
            CreateFunctionCmd createFuncCmd = new CreateFunctionCmd(this.pcBeginAddr);
            createFuncCmd.applyTo((DomainObject)this.program);
        }
        catch (AddressOutOfBoundsException e) {
            throw new ExceptionHandlerFrameException(e.getMessage() + ": " + this.pcBeginAddr.toString() + " + " + this.intPcRange);
        }
        if (this.curSize < this.intLength) {
            this.cieAugmentationString = this.cie.getAugmentationString();
            addr = this.createAugmentationFields(addr);
            if (!this.hasExtLength) {
                if (addr != null && this.curSize < this.intLength) {
                    addr = this.createCallFrameInstructions(addr);
                }
            } else {
                throw new ExceptionHandlerFrameException("ExtLength is not completely implemented.");
            }
        }
        this.createFdeLabel(fdeBaseAddress);
        region.setFrameDescriptorEntry(this);
        this.createAugmentationInfo(ehblock, region);
        this.nextAddress = addr;
        return region;
    }

    private void markEndOfFrame(Address addr) {
        FrameDescriptionEntry.createAndCommentData(this.program, addr, (DataType)this.dwordDT, "End of Frame", 0);
        SetCommentCmd commentCmd = new SetCommentCmd(addr, 3, "END OF FRAME");
        commentCmd.applyTo(this.program);
    }

    private Address createExtendedLength(Address addr) {
        if (this.intLength == -1) {
            this.hasExtLength = true;
            String comment = "(FDE) Extended Length";
            FrameDescriptionEntry.createAndCommentData(this.program, addr, (DataType)new QWordDataType(), comment, 0);
            addr = addr.add((long)QWORD_LEN);
            this.curSize += QWORD_LEN;
        }
        return addr;
    }

    private Address createAugmentationFields(Address addr) throws MemoryAccessException {
        this.augmentationDataAddr = null;
        if (addr != null && this.cieAugmentationString != null && this.cieAugmentationString.length() > 0 && this.cieAugmentationString.charAt(0) == 'z') {
            this.augmentationDataAddr = addr = this.createAugmentationDataLength(addr);
            addr = this.createAugmentationData(addr);
        }
        return addr;
    }

    private void createFdeLabel(Address fdeBase) {
        try {
            String fdeName = "fde_" + fdeBase.toString();
            Symbol fdeSym = this.program.getSymbolTable().getPrimarySymbol(fdeBase);
            if (fdeSym == null) {
                fdeSym = this.program.getSymbolTable().createLabel(fdeBase, fdeName, SourceType.ANALYSIS);
            } else {
                fdeSym.setName(fdeName, SourceType.ANALYSIS);
            }
        }
        catch (Exception e) {
            Msg.info((Object)this, (Object)("Unable to label FDE -- " + e.getMessage()));
        }
    }

    private void createAugmentationInfo(MemoryBlock ehblock, RegionDescriptor region) throws MemoryAccessException {
        if (this.augmentationDataAddr != null && this.intAugmentationDataLength != 0) {
            if (this.cieAugmentationString.indexOf(76) > 1) {
                this.createLsda(ehblock, region);
            } else {
                DwarfEHDecoder decoder = this.cie.getLSDADecoder();
                DwarfDecodeContext ctx = new DwarfDecodeContext(this.program, this.augmentationDataAddr, region.getEHMemoryBlock().getStart());
                Address potentialAugmentationDataExAddr = decoder.decodeAddress(ctx);
                if (this.program.getMemory().contains(potentialAugmentationDataExAddr)) {
                    this.augmentationDataExAddr = potentialAugmentationDataExAddr;
                    FrameDescriptionEntry.createData(this.program, this.augmentationDataAddr, (DataType)DWordDataType.dataType);
                    this.program.getReferenceManager().addMemoryReference(this.augmentationDataAddr, this.augmentationDataExAddr, RefType.DATA, SourceType.ANALYSIS, 0);
                    try {
                        String label = "eh_augmentation_" + String.valueOf(this.pcBeginAddr) + ".." + String.valueOf(this.pcEndAddr) + "_" + String.valueOf(this.augmentationDataExAddr);
                        this.program.getSymbolTable().createLabel(this.augmentationDataExAddr, label, SourceType.ANALYSIS);
                    }
                    catch (InvalidInputException label) {}
                } else {
                    CreateArrayCmd arrayCmd = new CreateArrayCmd(this.augmentationDataAddr, this.intAugmentationDataLength, (DataType)new ByteDataType(), BYTE_LEN);
                    arrayCmd.applyTo(this.program);
                }
            }
        }
    }

    private void createLsda(MemoryBlock ehblock, RegionDescriptor region) throws MemoryAccessException {
        DwarfDecodeContext lsdaDecodeContext = new DwarfDecodeContext(this.program, this.augmentationDataAddr, ehblock);
        DwarfEHDecoder lsdaDecoder = DwarfDecoderFactory.getDecoder(this.cie.getLSDAEncoding());
        Address lsdaAddr = lsdaDecoder.decodeAddress(lsdaDecodeContext);
        region.setLSDAAddress(lsdaAddr);
        String lsdaComment = "(FDE Augmentation Data) LSDA Data Pointer";
        FrameDescriptionEntry.createAndCommentData(this.program, this.augmentationDataAddr, lsdaDecoder.getDataType(this.program), lsdaComment, 0);
        if (this.augmentationDataAddr.equals((Object)lsdaAddr)) {
            return;
        }
        this.program.getReferenceManager().addMemoryReference(this.augmentationDataAddr, lsdaAddr, RefType.DATA, SourceType.ANALYSIS, 0);
        if (!this.program.getMemory().getAllInitializedAddressSet().contains(lsdaAddr)) {
            String errorMessage = "Can't create LSDA data @ " + String.valueOf(lsdaAddr) + ". The address is not in the program's initialized memory!  CIE @ " + String.valueOf(this.cie.getAddress()) + " FDE @ " + String.valueOf(this.baseAddress);
            Msg.error((Object)this, (Object)errorMessage);
            BookmarkManager bookmarkManager = this.program.getBookmarkManager();
            bookmarkManager.setBookmark(this.augmentationDataAddr, "Error", "Exception Handling Data", errorMessage);
            return;
        }
        try {
            LSDATable table = new LSDATable(this.monitor, this.program);
            table.create(lsdaAddr, region);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Error creating LSDA @ " + String.valueOf(lsdaAddr) + "  " + e.getMessage()), (Throwable)e);
        }
    }

    public Address getNextAddress() {
        return this.nextAddress;
    }

    public boolean isEndOfFrame() {
        return this.endOfFrame;
    }

    public AddressRange getProtectionRange() {
        return new AddressRangeImpl(this.pcBeginAddr, this.pcEndAddr);
    }

    public Address getAugmentationDataAddress() {
        return this.augmentationDataAddr;
    }

    public byte[] getAugmentationData() {
        return this.augmentationData;
    }

    public Address getAugmentationExDataAddress() {
        return this.augmentationDataExAddr;
    }

    public int setAugmentationDataExLength(int len) {
        if (this.intAugmentationDataExLength > 0) {
            return -1;
        }
        this.intAugmentationDataExLength = len;
        try {
            this.updateAugmentationDataEx();
        }
        catch (MemoryAccessException memoryAccessException) {
            // empty catch block
        }
        return len;
    }

    private void updateAugmentationDataEx() throws MemoryAccessException {
        this.augmentationDataEx = new byte[this.intAugmentationDataExLength];
        this.program.getMemory().getBytes(this.getAugmentationExDataAddress(), this.augmentationDataEx);
    }

    public byte[] getAugmentationExData() {
        if (this.augmentationDataEx == null) {
            return new byte[0];
        }
        return this.augmentationDataEx;
    }
}

