/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.RegionDescriptor;
import ghidra.app.plugin.exceptionhandlers.gcc.structures.gccexcepttable.LSDAActionRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LSDAActionTable {
    private TaskMonitor monitor;
    private Program program;
    private RegionDescriptor region;
    private Address tableAddress;
    private Address nextAddress;
    private List<LSDAActionRecord> records = new ArrayList<LSDAActionRecord>();

    public LSDAActionTable(TaskMonitor monitor, Program program, RegionDescriptor region) {
        this.monitor = monitor;
        this.program = program;
        this.region = region;
    }

    public void create(Address address, Address maxAddress) throws MemoryAccessException {
        if (address == null) {
            throw new IllegalArgumentException("action record's address cannot be null.");
        }
        if (this.monitor.isCancelled()) {
            return;
        }
        this.tableAddress = address;
        this.monitor.setMessage("Creating LSDA Action Table");
        LSDAActionRecord rec = null;
        while (address.compareTo((Object)maxAddress) <= 0) {
            rec = new LSDAActionRecord(this.monitor, this.program, this.region, this);
            rec.create(address);
            this.records.add(rec);
            address = rec.getNextAddress();
        }
        this.nextAddress = address;
        SetCommentCmd commentCmd = new SetCommentCmd(this.tableAddress, 3, "(LSDA) Action Table");
        commentCmd.applyTo(this.program);
    }

    Address getAddress() {
        return this.tableAddress;
    }

    Address getNextAddress() {
        return this.nextAddress;
    }

    public List<LSDAActionRecord> getActionRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public LSDAActionRecord getActionRecord(int actionIndex) {
        if (--actionIndex < 0) {
            return null;
        }
        return this.records.get(actionIndex);
    }

    public LSDAActionRecord getActionRecordAtOffset(int actionOffset) {
        int currentOffset = 0;
        for (LSDAActionRecord lsdaActionRecord : this.records) {
            int size = lsdaActionRecord.getSize();
            int nextOffset = currentOffset + size;
            if (actionOffset >= currentOffset && actionOffset < nextOffset) {
                return lsdaActionRecord;
            }
            currentOffset = nextOffset;
        }
        return null;
    }
}

