/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.ReusableDialogComponentProvider;
import ghidra.app.plugin.runtimeinfo.MapTablePanel;
import ghidra.app.plugin.runtimeinfo.RuntimeInfoPlugin;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.util.DefaultLanguageService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class InstalledProcessorsProvider
extends ReusableDialogComponentProvider {
    private RuntimeInfoPlugin plugin;
    private JTabbedPane tabbedPane;

    InstalledProcessorsProvider(RuntimeInfoPlugin plugin) {
        super("Installed Processors", false, false, true, false);
        this.plugin = plugin;
        this.setHelpLocation(plugin.getInstalledProcessorsHelpLocation());
        this.addWorkPanel(this.createWorkPanel());
    }

    private JComponent createWorkPanel() {
        this.tabbedPane = new JTabbedPane();
        this.addProcessors();
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 400);
            }
        };
        mainPanel.add((Component)this.tabbedPane, "Center");
        return mainPanel;
    }

    private void addProcessors() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (LanguageDescription desc : DefaultLanguageService.getLanguageService().getLanguageDescriptions(true)) {
            String processor = desc.getProcessor().toString();
            int count = map.getOrDefault(processor, 0);
            map.put(processor, count + 1);
        }
        String name = "Processors";
        this.tabbedPane.add(new MapTablePanel(name, map, "Name", "Variants", 300, false, this.plugin), name);
    }
}

