/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.ReusableDialogComponentProvider;
import generic.jar.ResourceFile;
import ghidra.GhidraClassLoader;
import ghidra.app.plugin.runtimeinfo.MapTablePanel;
import ghidra.app.plugin.runtimeinfo.MemoryUsagePanel;
import ghidra.app.plugin.runtimeinfo.RuntimeInfoPlugin;
import ghidra.app.plugin.runtimeinfo.VersionInfoPanel;
import ghidra.framework.Application;
import ghidra.framework.GModule;
import ghidra.util.Disposable;
import ghidra.util.classfinder.ClassFileInfo;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

class RuntimeInfoProvider
extends ReusableDialogComponentProvider {
    private RuntimeInfoPlugin plugin;
    private JTabbedPane tabbedPane;
    private MemoryUsagePanel memoryUsagePanel;

    RuntimeInfoProvider(RuntimeInfoPlugin plugin) {
        super("Runtime Information", false, false, true, false);
        this.plugin = plugin;
        this.setHelpLocation(plugin.getRuntimeInfoHelpLocation());
        this.addWorkPanel(this.createWorkPanel());
    }

    public void dispose() {
        super.dispose();
        for (Component c : this.tabbedPane.getComponents()) {
            if (!(c instanceof Disposable)) continue;
            Disposable d = (Disposable)c;
            d.dispose();
        }
    }

    protected void dialogShown() {
        this.memoryUsagePanel.shown();
    }

    protected void dialogClosed() {
        this.memoryUsagePanel.hidden();
    }

    private JComponent createWorkPanel() {
        this.tabbedPane = new JTabbedPane();
        this.addVersionInfoPanel();
        this.addMemory();
        this.addApplicationLayout();
        this.addProperties();
        this.addEnvironment();
        this.addModules();
        this.addExtensionPoints();
        this.addClasspath();
        this.addExtensionsClasspath();
        JPanel mainPanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(700, 400);
            }
        };
        mainPanel.add((Component)this.tabbedPane, "Center");
        return mainPanel;
    }

    private void addVersionInfoPanel() {
        this.tabbedPane.add((Component)new VersionInfoPanel(), "Version");
    }

    private void addMemory() {
        this.memoryUsagePanel = new MemoryUsagePanel();
        this.tabbedPane.add((Component)this.memoryUsagePanel, "Memory");
    }

    private void addApplicationLayout() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("PID", "" + ProcessHandle.current().pid());
        map.put("Installation Directory", Application.getInstallationDirectory().getAbsolutePath());
        map.put("Settings Directory", Application.getUserSettingsDirectory().getPath());
        map.put("Cache Directory", Application.getUserCacheDirectory().getPath());
        map.put("Temp Directory", Application.getUserTempDirectory().getPath());
        String name = "Application Layout";
        this.tabbedPane.add(new MapTablePanel(name, map, "Name", "Path", 200, true, this.plugin), name);
    }

    private void addProperties() {
        Properties properties = System.getProperties();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : properties.keySet()) {
            map.put(key.toString(), properties.getOrDefault(key, "").toString());
        }
        String name = "Properties";
        this.tabbedPane.add(new MapTablePanel(name, map, "Name", "Value", 400, true, this.plugin), name);
    }

    private void addEnvironment() {
        Map<String, String> map = System.getenv();
        String name = "Environment";
        this.tabbedPane.add(new MapTablePanel<String, String>(name, map, "Name", "Value", 400, true, this.plugin), name);
    }

    private void addModules() {
        Map<String, ResourceFile> map = Application.getApplicationLayout().getModules().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((GModule)e.getValue()).getModuleRoot()));
        String name = "Modules";
        this.tabbedPane.add(new MapTablePanel<String, ResourceFile>(name, map, "Name", "Path", 400, true, this.plugin), name);
    }

    private void addExtensionPoints() {
        JTabbedPane epTabbedPane = new JTabbedPane();
        this.tabbedPane.add("Extension Points", epTabbedPane);
        Map<String, String> map = ClassSearcher.getExtensionPointInfo().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::path));
        String name = "Extension Point Info (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "Name", "Path", 400, true, this.plugin), name);
        map = ClassSearcher.getLoaded().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::suffix));
        name = "Loaded (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "Name", "Type", 400, true, this.plugin), name);
        map = ClassSearcher.getFalsePositives().stream().collect(Collectors.toMap(ClassFileInfo::name, ClassFileInfo::suffix));
        name = "False Positives (%d)".formatted(map.size());
        epTabbedPane.add(new MapTablePanel<String, String>(name, map, "Name", "Type", 400, true, this.plugin), name);
    }

    private void addClasspath() {
        Map<Integer, String> map = this.getClasspathMap("java.class.path");
        String name = "Classpath";
        this.tabbedPane.add(new MapTablePanel<Integer, String>(name, map, "Index", "Path", 40, true, this.plugin), name);
    }

    private void addExtensionsClasspath() {
        Map<Integer, String> map = this.getClasspathMap("java.class.path.ext");
        String name = "Extensions Classpath";
        this.tabbedPane.add(new MapTablePanel<Integer, String>(name, map, "Index", "Path", 40, true, this.plugin), name);
    }

    private Map<Integer, String> getClasspathMap(String propertyName) {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 0;
        for (String entry : GhidraClassLoader.getClasspath((String)propertyName)) {
            map.put(i++, entry);
        }
        return map;
    }
}

