/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.runtimeinfo;

import docking.dnd.GClipboard;
import ghidra.framework.Application;
import ghidra.framework.ApplicationProperties;
import ghidra.framework.OperatingSystem;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class VersionInfoPanel
extends JPanel {
    VersionInfoPanel() {
        this.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(this.gatherVersionInfo());
        this.add((Component)textArea, "Center");
        JPanel bottomPanel = new JPanel();
        JButton copyButton = new JButton("Copy");
        copyButton.addActionListener(e -> {
            Clipboard clipboard = GClipboard.getSystemClipboard();
            clipboard.setContents(new StringSelection(textArea.getText()), null);
        });
        bottomPanel.add(copyButton);
        this.add((Component)bottomPanel, "South");
    }

    private String gatherVersionInfo() {
        String def = "???";
        ArrayList<String> lines = new ArrayList<String>();
        this.addApplicationInfo(lines, "???");
        this.addOperatingSystemInfo(lines, "???");
        this.addJavaInfo(lines, "???");
        return String.join((CharSequence)"\n", lines);
    }

    private void addApplicationInfo(List<String> lines, String def) {
        ApplicationProperties props = Application.getApplicationLayout().getApplicationProperties();
        lines.add("Ghidra Version: " + props.getApplicationVersion());
        lines.add("Ghidra Release: " + props.getApplicationReleaseName());
        lines.add("Ghidra Build Date: " + props.getApplicationBuildDate());
        lines.add("Ghidra Revision: " + props.getProperty("application.revision.ghidra", def));
        lines.add("Ghidra Development Mode: " + SystemUtilities.isInDevelopmentMode());
    }

    private void addOperatingSystemInfo(List<String> lines, String def) {
        lines.add("OS Name: " + System.getProperty("os.name", def));
        lines.add("OS Arch: " + System.getProperty("os.arch", def));
        lines.add("OS Version: " + System.getProperty("os.version", def));
        if (OperatingSystem.CURRENT_OPERATING_SYSTEM.equals((Object)OperatingSystem.LINUX)) {
            String prettyName = def;
            File osReleaseFile = new File("/etc/os-release");
            if (!osReleaseFile.isFile()) {
                osReleaseFile = new File("/usr/lib/os-release");
            }
            try (BufferedReader reader = new BufferedReader(new FileReader(osReleaseFile));){
                Properties props = new Properties();
                props.load(reader);
                prettyName = props.getProperty("PRETTY_NAME", def);
                if (prettyName.startsWith("\"") && prettyName.endsWith("\"")) {
                    prettyName = prettyName.substring(1, prettyName.length() - 1);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            lines.add("OS Pretty Name: " + prettyName);
        }
    }

    private void addJavaInfo(List<String> lines, String def) {
        lines.add("Java Vendor: " + System.getProperty("java.vendor", def));
        lines.add("Java Version: " + System.getProperty("java.version", def));
    }
}

