/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.actions.KeyBindingUtils;
import generic.jar.ResourceFile;
import ghidra.app.script.GhidraScriptProvider;
import ghidra.app.script.GhidraScriptUtil;
import ghidra.app.script.UnsupportedScriptProvider;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.StringUtils;
import resources.ResourceManager;

public class ScriptInfo {
    public static final String DELIMITTER = ".";
    static final String AT_AUTHOR = "@author";
    static final String AT_CATEGORY = "@category";
    static final String AT_KEYBINDING = "@keybinding";
    static final String AT_MENUPATH = "@menupath";
    static final String AT_TOOLBAR = "@toolbar";
    static final String AT_RUNTIME = "@runtime";
    private static final String AT_IMPORTPACKAGE = "@importpackage";
    public static final String[] METADATA = new String[]{"@author", "@category", "@keybinding", "@menupath", "@toolbar", "@runtime"};
    private GhidraScriptProvider provider;
    private ResourceFile sourceFile;
    private boolean isCompileErrors;
    private boolean isDuplicate;
    private long modified;
    private String description;
    private String author;
    private String[] category = new String[0];
    private KeyStroke keyBinding;
    private String keybindingErrorMessage;
    private String[] menupath = new String[0];
    private String toolbar;
    private ImageIcon toolbarImage;
    private String importpackage;
    private String runtime;

    ScriptInfo(GhidraScriptProvider provider, ResourceFile sourceFile) {
        this.provider = provider;
        this.sourceFile = sourceFile;
        if (!sourceFile.exists()) {
            throw new IllegalArgumentException("Source file for script does not exist!: " + String.valueOf(sourceFile));
        }
    }

    private void init() {
        this.description = "";
        this.author = null;
        this.category = new String[0];
        this.keyBinding = null;
        this.menupath = new String[0];
        this.toolbar = null;
        this.toolbarImage = null;
        this.importpackage = null;
        this.keybindingErrorMessage = null;
        this.runtime = null;
    }

    public void refresh() {
        this.toolbarImage = null;
    }

    public String getName() {
        return this.sourceFile.getName();
    }

    public ResourceFile getSourceFile() {
        return this.sourceFile;
    }

    public String getAuthor() {
        this.parseHeader();
        return this.author;
    }

    public String getRuntimeEnvironmentName() {
        this.parseHeader();
        return this.runtime;
    }

    public GhidraScriptProvider getProvider() {
        this.parseHeader();
        this.provider = GhidraScriptUtil.getProvider(this.sourceFile);
        return this.provider;
    }

    public boolean isCompileErrors() {
        return this.isCompileErrors;
    }

    public void setCompileErrors(boolean b) {
        this.isCompileErrors = b;
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    public void setDuplicate(boolean isDuplicate) {
        this.isDuplicate = isDuplicate;
    }

    public boolean hasUnsupportedProvider() {
        return this.provider instanceof UnsupportedScriptProvider;
    }

    public String getDescription() {
        this.parseHeader();
        return this.description;
    }

    private void parseHeader() {
        if (this.modified == this.sourceFile.lastModified()) {
            return;
        }
        if (!this.sourceFile.exists()) {
            return;
        }
        this.init();
        String commentPrefix = this.provider.getCommentCharacter();
        String certifyHeaderStart = this.provider.getCertifyHeaderStart();
        boolean allowCertifyHeader = certifyHeaderStart != null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.sourceFile.getInputStream()));){
            String line;
            StringBuilder buffer = new StringBuilder();
            boolean hitAtSign = false;
            while ((line = reader.readLine()) != null) {
                if (allowCertifyHeader && this.skipCertifyHeader(reader, line)) {
                    allowCertifyHeader = false;
                    continue;
                }
                if (this.parseBlockComment(reader, line)) {
                    allowCertifyHeader = false;
                    continue;
                }
                if (line.startsWith(commentPrefix)) {
                    allowCertifyHeader = false;
                    if ((line = line.substring(commentPrefix.length()).trim()).startsWith("@")) {
                        hitAtSign = true;
                        this.parseMetaDataLine(line);
                        continue;
                    }
                    if (hitAtSign) continue;
                    buffer.append(line).append(' ').append('\n');
                    continue;
                }
                if (line.trim().isEmpty()) continue;
            }
            this.description = buffer.toString();
            this.modified = this.sourceFile.lastModified();
        }
        catch (IOException e) {
            Msg.debug((Object)this, (Object)("Unexpected exception reading script: " + String.valueOf(this.sourceFile)), (Throwable)e);
        }
    }

    private boolean skipCertifyHeader(BufferedReader reader, String line) throws IOException {
        String certifyHeaderStart = this.provider.getCertifyHeaderStart();
        if (certifyHeaderStart == null) {
            return false;
        }
        if (!line.startsWith(certifyHeaderStart)) {
            return false;
        }
        String certifyHeaderEnd = this.provider.getCertifyHeaderEnd();
        String certifyHeaderBodyPrefix = this.provider.getCertificationBodyPrefix();
        String string = certifyHeaderBodyPrefix = certifyHeaderBodyPrefix == null ? "" : certifyHeaderBodyPrefix;
        while ((line = reader.readLine()) != null) {
            String trimLine = line.trim();
            if (trimLine.startsWith(certifyHeaderEnd)) {
                return true;
            }
            if (trimLine.startsWith(certifyHeaderBodyPrefix)) continue;
            Msg.error((Object)this, (Object)("Script contains invalid certification header: " + this.getName()));
        }
        return false;
    }

    private boolean parseBlockComment(BufferedReader reader, String line) throws IOException {
        Pattern blockStart = this.provider.getBlockCommentStart();
        Pattern blockEnd = this.provider.getBlockCommentEnd();
        if (blockStart == null || blockEnd == null) {
            return false;
        }
        Matcher startMatcher = blockStart.matcher(line);
        if (startMatcher.find()) {
            int lastOffset = startMatcher.end();
            while (line != null && !blockEnd.matcher(line).find(lastOffset)) {
                line = reader.readLine();
                lastOffset = 0;
            }
            return true;
        }
        return false;
    }

    private void parseMetaDataLine(String line) {
        try {
            if (line.startsWith(AT_AUTHOR)) {
                this.author = this.getTagValue(AT_AUTHOR, line);
            } else if (line.startsWith(AT_CATEGORY)) {
                String tagValue = this.getTagValue(AT_CATEGORY, line);
                if (tagValue != null) {
                    this.category = this.splitString(tagValue, DELIMITTER);
                }
            } else if (line.startsWith(AT_KEYBINDING)) {
                String tagValue = this.getTagValue(AT_KEYBINDING, line);
                if (tagValue != null) {
                    this.setKeyBinding(tagValue);
                }
            } else if (line.startsWith(AT_MENUPATH)) {
                String tagValue = this.getTagValue(AT_MENUPATH, line);
                if (tagValue != null) {
                    StringTokenizer nizer = new StringTokenizer(tagValue, DELIMITTER);
                    this.menupath = new String[nizer.countTokens()];
                    for (int i = 0; i < this.menupath.length; ++i) {
                        this.menupath[i] = nizer.nextToken().trim();
                    }
                }
            } else if (line.startsWith(AT_TOOLBAR)) {
                this.toolbar = this.getTagValue(AT_TOOLBAR, line);
            } else if (line.startsWith(AT_IMPORTPACKAGE)) {
                this.importpackage = this.getTagValue(AT_IMPORTPACKAGE, line);
            } else if (line.startsWith(AT_RUNTIME)) {
                this.runtime = this.getTagValue(AT_RUNTIME, line);
            }
        }
        catch (Exception e) {
            Msg.debug((Object)this, (Object)("Unexpected exception reading script metadata line: " + line), (Throwable)e);
        }
    }

    private String getTagValue(String tag, String line) {
        if (line.length() <= tag.length()) {
            return null;
        }
        if (line.startsWith(tag)) {
            return line.substring(tag.length() + 1).trim();
        }
        return null;
    }

    private String[] splitString(String string, String delimiter) {
        StringTokenizer nizer = new StringTokenizer(string, delimiter);
        String[] pieces = new String[nizer.countTokens()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[i] = nizer.nextToken().trim();
        }
        return pieces;
    }

    private void setKeyBinding(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line);
        StringBuilder buildy = new StringBuilder();
        int tokenCount = tokenizer.countTokens();
        for (int i = 0; i < tokenCount; ++i) {
            String token = tokenizer.nextToken();
            if (i == tokenCount - 1) {
                buildy.append(token.toUpperCase());
                continue;
            }
            buildy.append(token.toLowerCase());
            buildy.append(' ');
        }
        this.keyBinding = KeyBindingUtils.parseKeyStroke((String)buildy.toString());
        if (this.keyBinding == null) {
            this.keybindingErrorMessage = "Unable to parse keybinding: " + String.valueOf(buildy);
        }
    }

    public boolean isCategory(String[] otherCategory) {
        if (otherCategory == null) {
            return true;
        }
        this.parseHeader();
        if (this.category.length < otherCategory.length) {
            return false;
        }
        boolean match = true;
        for (int i = 0; i < otherCategory.length; ++i) {
            if (i >= this.category.length || otherCategory[i].equalsIgnoreCase(this.category[i])) continue;
            match = false;
            break;
        }
        return match;
    }

    public String[] getCategory() {
        this.parseHeader();
        return this.category;
    }

    public String[] getMenuPath() {
        this.parseHeader();
        return this.menupath;
    }

    public String getMenuPathAsString() {
        String[] menuPathArr;
        Object menuPath = "";
        for (String path : menuPathArr = this.getMenuPath()) {
            if (((String)menuPath).length() > 0) {
                menuPath = (String)menuPath + "->";
            }
            menuPath = (String)menuPath + path;
        }
        return menuPath;
    }

    public KeyStroke getKeyBinding() {
        this.parseHeader();
        return this.keyBinding;
    }

    public String getKeyBindingErrorMessage() {
        return this.keybindingErrorMessage;
    }

    public Icon getToolBarImage(boolean scaled) {
        this.parseHeader();
        if (this.toolbar == null) {
            return null;
        }
        if (this.toolbarImage == null) {
            List<ResourceFile> directories = GhidraScriptUtil.getScriptSourceDirectories();
            for (ResourceFile dir : directories) {
                ResourceFile imageFile = new ResourceFile(dir, this.toolbar);
                if (!imageFile.exists()) continue;
                this.toolbarImage = ResourceManager.loadImage((String)imageFile.getAbsolutePath());
                break;
            }
            if (this.toolbarImage == null) {
                this.toolbarImage = ResourceManager.loadImage((String)("images/" + this.toolbar));
            }
        }
        if (scaled && this.toolbarImage != null) {
            return ResourceManager.getScaledIcon((ImageIcon)this.toolbarImage, (int)16, (int)16);
        }
        return this.toolbarImage;
    }

    public String getImportPackage() {
        this.parseHeader();
        return this.importpackage;
    }

    public String getToolTipText() {
        this.parseHeader();
        String htmlDescription = "No Description";
        if (this.description != null) {
            htmlDescription = HTMLUtilities.escapeHTML((String)this.description);
            htmlDescription = htmlDescription.replaceAll("\n", "<br>&nbsp;");
        }
        String space = "&nbsp;";
        String htmlAuthor = HTMLUtilities.bold((String)"Author:") + space + HTMLUtilities.escapeHTML((String)this.toString(this.author));
        String htmlCategory = HTMLUtilities.bold((String)"Category:") + space + HTMLUtilities.escapeHTML((String)this.toString(this.category));
        String htmlKeyBinding = HTMLUtilities.bold((String)"Key Binding:") + space + this.getKeybindingToolTip();
        String htmlMenuPath = HTMLUtilities.bold((String)"Menu Path:") + space + HTMLUtilities.escapeHTML((String)this.toString(this.menupath));
        String htmlRuntime = HTMLUtilities.bold((String)"Runtime Environment:") + space + HTMLUtilities.escapeHTML((String)this.toString(this.runtime));
        StringBuilder buffer = new StringBuilder();
        buffer.append("<h3>").append(space).append(HTMLUtilities.escapeHTML((String)this.getName())).append("</h3>");
        buffer.append("<br>");
        buffer.append(space).append(htmlDescription);
        buffer.append("<br>");
        buffer.append("<br>");
        buffer.append(space).append(htmlAuthor);
        buffer.append("<br>");
        buffer.append(space).append(htmlCategory);
        buffer.append("<br>");
        buffer.append(space).append(htmlKeyBinding);
        buffer.append("<br>");
        buffer.append(space).append(htmlMenuPath);
        buffer.append("<br>");
        buffer.append(space).append(htmlRuntime);
        buffer.append("<br>");
        buffer.append("<br>");
        return HTMLUtilities.wrapAsHTML((String)buffer.toString());
    }

    private String getKeybindingToolTip() {
        return this.toToolTip(this.getKeyBinding());
    }

    private String toToolTip(KeyStroke keyStroke) {
        if (keyStroke == null) {
            if (this.keybindingErrorMessage != null) {
                return this.keybindingErrorMessage;
            }
            return "";
        }
        return KeyBindingUtils.parseKeyStroke((KeyStroke)keyStroke);
    }

    private String toString(String string) {
        return StringUtils.defaultString((String)string);
    }

    private String toString(String[] path) {
        String joined = StringUtils.join((Object[])path, (String)DELIMITTER);
        return StringUtils.defaultString((String)joined);
    }

    public boolean hasErrors() {
        return this.isCompileErrors() || this.isDuplicate() || this.hasUnsupportedProvider();
    }

    public String getErrorMessage() {
        if (this.isCompileErrors()) {
            return "Error compiling script (see console)";
        }
        if (this.isDuplicate()) {
            return "Script is a duplicate of another script";
        }
        if (this.hasUnsupportedProvider()) {
            return "Script's @runtime tag specifies an unsupported runtime environment";
        }
        return null;
    }

    public String toString() {
        return "ScriptInfo: " + this.getName();
    }
}

