/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.util.SystemUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class DWARFDataTypeConflictHandler
extends DataTypeConflictHandler {
    public static final DWARFDataTypeConflictHandler INSTANCE = new DWARFDataTypeConflictHandler();

    private DWARFDataTypeConflictHandler() {
    }

    private boolean isSizeCompatible(Composite src, Composite target) {
        return target.isNotYetDefined() || src.getLength() == target.getLength();
    }

    private boolean isCompositeDefault(Composite composite) {
        return composite.isNotYetDefined() || composite.getNumDefinedComponents() == 0;
    }

    private boolean isCompositePart(Composite full, Composite part, Set<Long> visitedDataTypes) {
        if (full instanceof Structure && part instanceof Structure) {
            return this.isStructurePart((Structure)full, (Structure)part, visitedDataTypes);
        }
        if (full instanceof Union && part instanceof Union) {
            return this.isUnionPart((Union)full, (Union)part, visitedDataTypes);
        }
        return false;
    }

    private boolean isUnionPart(Union full, Union part, Set<Long> visitedDataTypes) {
        String name;
        if (full.getLength() < part.getLength()) {
            return false;
        }
        HashMap<String, DataTypeComponent> fullComponentsByName = new HashMap<String, DataTypeComponent>();
        for (DataTypeComponent dtc : full.getComponents()) {
            name = dtc.getFieldName();
            if (name == null) {
                name = dtc.getDefaultFieldName();
            }
            fullComponentsByName.put(name, dtc);
        }
        for (DataTypeComponent dtc : part.getComponents()) {
            DataType fullDT;
            DataTypeComponent fullDTC;
            name = dtc.getFieldName();
            if (name == null) {
                name = dtc.getDefaultFieldName();
            }
            if ((fullDTC = (DataTypeComponent)fullComponentsByName.get(name)) == null) {
                return false;
            }
            DataType partDT = dtc.getDataType();
            if (this.doRelaxedCompare(partDT, fullDT = fullDTC.getDataType(), visitedDataTypes) != DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD) continue;
            return false;
        }
        return true;
    }

    private boolean isStructurePart(Structure full, Structure part, Set<Long> visitedDataTypes) {
        DataTypeComponent[] partComps;
        if (full.getLength() != part.getLength()) {
            return false;
        }
        for (DataTypeComponent partDTC : partComps = part.getDefinedComponents()) {
            DataTypeComponent fullDTCAt;
            DataType partDT = partDTC.getDataType();
            if (partDT.isZeroLength()) continue;
            DataTypeComponent dataTypeComponent = fullDTCAt = partDTC.getDataType() instanceof BitFieldDataType ? this.getBitfieldByOffsets(full, partDTC) : this.getBestMatchingDTC(full, partDTC);
            if (fullDTCAt == null || fullDTCAt.getOffset() != partDTC.getOffset() || !SystemUtilities.isEqual((Object)fullDTCAt.getFieldName(), (Object)partDTC.getFieldName())) {
                return false;
            }
            if (this.isMemberFieldPartiallyCompatible(fullDTCAt, partDTC, visitedDataTypes)) continue;
            return false;
        }
        return true;
    }

    DataTypeComponent getBestMatchingDTC(Structure struct, DataTypeComponent matchCriteria) {
        for (DataTypeComponent dtc : struct.getComponentsContaining(matchCriteria.getOffset())) {
            DataType dt = dtc.getDataType();
            if (dtc.getOffset() != matchCriteria.getOffset() || dt.isZeroLength()) continue;
            return dtc;
        }
        return null;
    }

    boolean isMemberFieldPartiallyCompatible(DataTypeComponent fullDTC, DataTypeComponent partDTC, Set<Long> visitedDataTypes) {
        DataType partDT = partDTC.getDataType();
        DataType fullDT = fullDTC.getDataType();
        DataTypeConflictHandler.ConflictResult dtCompResult = this.doRelaxedCompare(partDT, fullDT, visitedDataTypes);
        switch (dtCompResult) {
            case RENAME_AND_ADD: {
                return false;
            }
            case REPLACE_EXISTING: {
                return fullDTC.getLength() >= partDTC.getLength();
            }
        }
        return true;
    }

    private DataTypeComponent getBitfieldByOffsets(Structure full, DataTypeComponent partDTC) {
        BitFieldDataType partBF = (BitFieldDataType)partDTC.getDataType();
        DataTypeComponent fullDTC = full.getComponentContaining(partDTC.getOffset());
        if (fullDTC == null) {
            return null;
        }
        int fullNumComp = full.getNumComponents();
        int fullOrdinal = fullDTC.getOrdinal();
        while (fullOrdinal < fullNumComp && (fullDTC = full.getComponent(fullOrdinal)).getDataType() instanceof BitFieldDataType && fullDTC.getOffset() <= partDTC.getOffset()) {
            BitFieldDataType fullBF = (BitFieldDataType)fullDTC.getDataType();
            if (fullDTC.getOffset() == partDTC.getOffset() && fullBF.getBitOffset() == partBF.getBitOffset() && fullBF.getBitSize() == partBF.getBitSize()) {
                return fullDTC;
            }
            ++fullOrdinal;
        }
        return null;
    }

    private DataTypeConflictHandler.ConflictResult doStrictCompare(DataType addedDataType, DataType existingDataType, Set<Long> visitedDataTypes) {
        if (addedDataType == existingDataType || !this.addVisited(existingDataType, addedDataType, visitedDataTypes)) {
            return DataTypeConflictHandler.ConflictResult.USE_EXISTING;
        }
        if (existingDataType instanceof Composite && addedDataType instanceof Composite) {
            Composite existingComposite = (Composite)existingDataType;
            Composite addedComposite = (Composite)addedDataType;
            if (this.isCompositeDefault(addedComposite) && this.isSizeCompatible(existingComposite, addedComposite)) {
                return DataTypeConflictHandler.ConflictResult.USE_EXISTING;
            }
            if (this.isCompositeDefault(existingComposite) && this.isSizeCompatible(addedComposite, existingComposite)) {
                return DataTypeConflictHandler.ConflictResult.REPLACE_EXISTING;
            }
            if (this.isCompositePart(existingComposite, addedComposite, visitedDataTypes)) {
                return DataTypeConflictHandler.ConflictResult.USE_EXISTING;
            }
            if (this.isCompositePart(addedComposite, existingComposite, visitedDataTypes)) {
                return DataTypeConflictHandler.ConflictResult.REPLACE_EXISTING;
            }
            return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }
        if (existingDataType instanceof TypeDef && addedDataType instanceof TypeDef) {
            TypeDef addedTypeDef = (TypeDef)addedDataType;
            TypeDef existingTypeDef = (TypeDef)existingDataType;
            return this.doRelaxedCompare(addedTypeDef.getBaseDataType(), existingTypeDef.getBaseDataType(), visitedDataTypes);
        }
        if (existingDataType instanceof Array && addedDataType instanceof Array) {
            Array addedArray = (Array)addedDataType;
            Array existingArray = (Array)existingDataType;
            if (addedArray.getNumElements() != existingArray.getNumElements() || addedArray.getElementLength() != existingArray.getElementLength()) {
                return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
            }
            return this.doRelaxedCompare(addedArray.getDataType(), existingArray.getDataType(), visitedDataTypes);
        }
        if (existingDataType instanceof Pointer && addedDataType instanceof Pointer) {
            return this.doRelaxedCompare(((Pointer)addedDataType).getDataType(), ((Pointer)existingDataType).getDataType(), visitedDataTypes);
        }
        if (existingDataType instanceof FunctionDefinition && addedDataType instanceof FunctionDefinition) {
            return this.compareFuncDef((FunctionDefinition)addedDataType, (FunctionDefinition)existingDataType, visitedDataTypes);
        }
        if (existingDataType instanceof BitFieldDataType && addedDataType instanceof BitFieldDataType) {
            BitFieldDataType existingBF = (BitFieldDataType)existingDataType;
            BitFieldDataType addedBF = (BitFieldDataType)addedDataType;
            if (existingBF.getDeclaredBitSize() != addedBF.getDeclaredBitSize()) {
                return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
            }
            return existingBF.getPrimitiveBaseDataType().isEquivalent((DataType)addedBF.getPrimitiveBaseDataType()) ? DataTypeConflictHandler.ConflictResult.USE_EXISTING : DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }
        if (existingDataType.isEquivalent(addedDataType)) {
            return DataTypeConflictHandler.ConflictResult.USE_EXISTING;
        }
        return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
    }

    private DataTypeConflictHandler.ConflictResult compareFuncDef(FunctionDefinition addedFunc, FunctionDefinition existingFunc, Set<Long> visitedDataTypes) {
        ParameterDefinition[] existingArgs;
        if (this.doRelaxedCompare(addedFunc.getReturnType(), existingFunc.getReturnType(), visitedDataTypes) == DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD) {
            return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }
        ParameterDefinition[] addedArgs = addedFunc.getArguments();
        if (addedArgs.length != (existingArgs = existingFunc.getArguments()).length) {
            return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }
        for (int i = 0; i < addedArgs.length; ++i) {
            ParameterDefinition addedParam = addedArgs[i];
            ParameterDefinition existingParam = existingArgs[i];
            if (this.doRelaxedCompare(addedParam.getDataType(), existingParam.getDataType(), visitedDataTypes) != DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD) continue;
            return DataTypeConflictHandler.ConflictResult.RENAME_AND_ADD;
        }
        return DataTypeConflictHandler.ConflictResult.USE_EXISTING;
    }

    private DataTypeConflictHandler.ConflictResult doRelaxedCompare(DataType addedDataType, DataType existingDataType, Set<Long> visitedDataTypes) {
        if (addedDataType instanceof TypeDef) {
            return this.doRelaxedCompare(((TypeDef)addedDataType).getBaseDataType(), existingDataType, visitedDataTypes);
        }
        if (existingDataType instanceof TypeDef) {
            return this.doRelaxedCompare(addedDataType, ((TypeDef)existingDataType).getBaseDataType(), visitedDataTypes);
        }
        return this.doStrictCompare(addedDataType, existingDataType, visitedDataTypes);
    }

    private long getDTPairKey(DataType dataType1, DataType dataType2) {
        return ((long)System.identityHashCode(dataType1) << 32) + ((long)System.identityHashCode(dataType2) & 0xFFFFFFFFL);
    }

    private boolean addVisited(DataType dataType1, DataType dataType2, Set<Long> visitedDataTypes) {
        long key = this.getDTPairKey(dataType1, dataType2);
        return visitedDataTypes.add(key);
    }

    public DataTypeConflictHandler.ConflictResult resolveConflict(DataType addedDataType, DataType existingDataType) {
        HashSet<Long> visitedDataTypes = new HashSet<Long>();
        return this.doStrictCompare(addedDataType, existingDataType, visitedDataTypes);
    }

    public boolean shouldUpdate(DataType sourceDataType, DataType localDataType) {
        return false;
    }

    public DataTypeConflictHandler getSubsequentHandler() {
        return this;
    }
}

