/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFCompilationUnit;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeManager;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFFunctionImporter;
import ghidra.app.util.bin.format.dwarf.DWARFImportOptions;
import ghidra.app.util.bin.format.dwarf.DWARFImportSummary;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFSourceInfo;
import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import utility.function.Dummy;

public class DWARFImporter {
    private DWARFProgram prog;
    private DWARFDataTypeManager dwarfDTM;
    private TaskMonitor monitor;

    public DWARFImporter(DWARFProgram prog, TaskMonitor monitor) {
        this.prog = prog;
        this.monitor = monitor;
        this.dwarfDTM = prog.getDwarfDTM();
    }

    private void moveTypesIntoSourceFolders() throws CancelledException {
        List<DataTypePath> importedTypes = this.dwarfDTM.getImportedTypes();
        Collections.sort(importedTypes, (dtp1, dtp2) -> dtp1.getCategoryPath().getPath().compareTo(dtp2.getCategoryPath().getPath()));
        this.monitor.setIndeterminate(false);
        this.monitor.setShowProgressValue(true);
        this.monitor.initialize((long)importedTypes.size());
        this.monitor.setMessage("DWARF Move Types");
        CategoryPath unCatRootCp = this.prog.getUncategorizedRootDNI().getOrganizationalCategoryPath();
        CategoryPath rootCP = this.prog.getRootDNI().asCategoryPath();
        for (DataTypePath dataTypePath : importedTypes) {
            DWARFSourceInfo dsi;
            DataType dataType;
            this.monitor.checkCancelled();
            this.monitor.incrementProgress(1L);
            if (this.monitor.getProgress() % 5L == 0L) {
                Swing.runNow((Runnable)Dummy.runnable());
            }
            if ((dataType = this.prog.getGhidraProgram().getDataTypeManager().getDataType(dataTypePath)) == null || dataType instanceof Pointer || dataType instanceof Array || (dsi = this.dwarfDTM.getSourceInfo(dataType)) == null || dsi.filename() == null) continue;
            CategoryPath dataTypeOrigCP = dataType.getCategoryPath();
            CategoryPath newRoot = new CategoryPath(rootCP, new String[]{dsi.filename()});
            CategoryPath newCP = this.rehomeCategoryPathSubTree(unCatRootCp, newRoot, dataTypeOrigCP);
            if (newCP == null) continue;
            try {
                dataType.setCategoryPath(newCP);
                if (dataType instanceof Composite) {
                    this.fixupAnonStructMembers((Composite)dataType, dataTypeOrigCP, newCP);
                }
                this.deleteEmptyCategoryPaths(dataTypeOrigCP);
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to move " + String.valueOf(dataType.getDataTypePath()) + " to " + String.valueOf(newCP)));
            }
        }
        this.monitor.setMessage("DWARF Move Types - Done");
    }

    private void fixupAnonStructMembers(Composite compositeDataType, CategoryPath origCategoryPath, CategoryPath newCP) throws DuplicateNameException {
        CategoryPath origCompositeNSCP = new CategoryPath(origCategoryPath, new String[]{compositeDataType.getName()});
        CategoryPath destCompositeNSCP = new CategoryPath(newCP, new String[]{compositeDataType.getName()});
        for (DataTypeComponent component : compositeDataType.getDefinedComponents()) {
            DataType dtcDT = component.getDataType();
            if (dtcDT instanceof Array || dtcDT instanceof Pointer) {
                dtcDT = DataTypeUtils.getNamedBaseDataType(dtcDT);
            }
            if (!dtcDT.getCategoryPath().equals((Object)origCompositeNSCP) || this.dwarfDTM.getSourceInfo(dtcDT) != null) continue;
            dtcDT.setCategoryPath(destCompositeNSCP);
        }
        this.deleteEmptyCategoryPaths(origCompositeNSCP);
    }

    private void deleteEmptyCategoryPaths(CategoryPath cp) {
        ProgramBasedDataTypeManager dtm = this.prog.getGhidraProgram().getDataTypeManager();
        while (!CategoryPath.ROOT.equals((Object)cp)) {
            Category cat = dtm.getCategory(cp);
            Category parentCat = dtm.getCategory(cp.getParent());
            if (cat == null || parentCat == null || cat.getDataTypes().length != 0 || cat.getCategories().length != 0) break;
            if (!parentCat.removeEmptyCategory(cat.getName(), this.monitor)) {
                Msg.error((Object)this, (Object)("Failed to delete empty category " + String.valueOf(cp)));
                break;
            }
            cp = parentCat.getCategoryPath();
        }
    }

    private CategoryPath rehomeCategoryPathSubTree(CategoryPath origRoot, CategoryPath newRoot, CategoryPath cp) {
        if (origRoot.equals((Object)cp)) {
            return newRoot;
        }
        List origRootParts = origRoot.asList();
        List cpParts = cp.asList();
        if (cpParts.size() < origRootParts.size() || !origRootParts.equals(cpParts.subList(0, origRootParts.size()))) {
            return null;
        }
        return new CategoryPath(newRoot, cpParts.subList(origRootParts.size(), cpParts.size()));
    }

    private void addSourceLineInfo(BinaryReader reader) throws CancelledException, IOException {
        if (reader == null) {
            return;
        }
        this.monitor.initialize(reader.length(), "DWARF Source Line Info");
        List<DWARFCompilationUnit> compUnits = this.prog.getCompilationUnits();
        for (DWARFCompilationUnit cu : compUnits) {
            try {
                this.monitor.checkCancelled();
                this.monitor.setProgress(cu.getLine().getStartOffset());
                List<DWARFLine.SourceFileAddr> allSFA = cu.getLine().getAllSourceFileAddrInfo(cu, reader);
                for (DWARFLine.SourceFileAddr sfa : allSFA) {
                    Address addr = this.prog.getCodeAddress(sfa.address());
                    DWARFUtil.appendComment(this.prog.getGhidraProgram(), addr, 0, "", "%s:%d".formatted(sfa.fileName(), sfa.lineNum()), ";");
                }
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)"Failed to read DWARF line info for cu %d".formatted(cu.getUnitNumber()), (Throwable)e);
            }
        }
    }

    public DWARFImportSummary performImport() throws IOException, DWARFException, CancelledException {
        this.monitor.setIndeterminate(false);
        this.monitor.setShowProgressValue(true);
        DWARFImportOptions importOptions = this.prog.getImportOptions();
        DWARFImportSummary importSummary = this.prog.getImportSummary();
        long start_ts = System.currentTimeMillis();
        if (importOptions.isImportDataTypes()) {
            this.dwarfDTM.importAllDataTypes(this.monitor);
            this.prog.getGhidraProgram().flushEvents();
            importSummary.dataTypeElapsedMS = System.currentTimeMillis() - start_ts;
        }
        if (importOptions.isImportFuncs()) {
            long funcstart_ts = System.currentTimeMillis();
            DWARFFunctionImporter dfi = new DWARFFunctionImporter(this.prog, this.monitor);
            dfi.importFunctions();
            importSummary.funcsElapsedMS = System.currentTimeMillis() - funcstart_ts;
        }
        if (importOptions.isOrganizeTypesBySourceFile()) {
            this.moveTypesIntoSourceFolders();
        }
        if (importOptions.isOutputSourceLineInfo()) {
            this.addSourceLineInfo(this.prog.getDebugLineBR());
        }
        importSummary.totalElapsedMS = System.currentTimeMillis() - start_ts;
        return importSummary;
    }
}

