/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineException;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineNumberExtendedOpcodes;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineNumberStandardOpcodes;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineProgramInstruction;
import ghidra.app.util.bin.format.dwarf.line.DWARFLineProgramState;
import ghidra.program.model.data.LEB128;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class DWARFLineProgramExecutor
implements Closeable {
    private DWARFLineProgramState state;
    private BinaryReader reader;
    private final int pointerSize;
    private final long streamEnd;
    private final int opcodeBase;
    private final int lineRange;
    private final int lineBase;
    private final int minInstrLen;
    private final boolean defaultIsStatement;

    public DWARFLineProgramExecutor(BinaryReader reader, long streamEnd, int pointerSize, int opcodeBase, int lineBase, int lineRange, int minInstrLen, boolean defaultIsStatement) {
        this.reader = reader;
        this.streamEnd = streamEnd;
        this.pointerSize = pointerSize;
        this.opcodeBase = opcodeBase;
        this.lineBase = lineBase;
        this.lineRange = lineRange;
        this.minInstrLen = minInstrLen;
        this.defaultIsStatement = defaultIsStatement;
    }

    @Override
    public void close() {
        this.reader = null;
    }

    public boolean hasNext() {
        return this.reader.getPointerIndex() < this.streamEnd;
    }

    public DWARFLineProgramState currentState() {
        return new DWARFLineProgramState(this.state);
    }

    public DWARFLineProgramState nextRow() throws IOException {
        while (this.hasNext()) {
            DWARFLineProgramInstruction instr = this.step();
            if (instr.row() == null) continue;
            return instr.row();
        }
        return null;
    }

    public List<DWARFLineProgramState> allRows() throws IOException {
        DWARFLineProgramState row;
        ArrayList<DWARFLineProgramState> results = new ArrayList<DWARFLineProgramState>();
        while ((row = this.nextRow()) != null) {
            results.add(row);
        }
        return results;
    }

    public DWARFLineProgramInstruction step() throws IOException {
        DWARFLineProgramInstruction instr = this.stepInstr();
        return instr;
    }

    private DWARFLineProgramInstruction stepInstr() throws IOException {
        if (this.state == null) {
            this.state = new DWARFLineProgramState(this.defaultIsStatement);
        }
        long instrOffset = this.reader.getPointerIndex();
        int opcode = this.reader.readNextUnsignedByte();
        if (opcode == 0) {
            return this.executeExtended(instrOffset);
        }
        if (opcode >= this.opcodeBase) {
            return this.executeSpecial(instrOffset, opcode);
        }
        return this.executeStandard(instrOffset, opcode);
    }

    private DWARFLineProgramInstruction executeSpecial(long instrOffset, int specialOpcodeValue) {
        int adjustedOpcode = (specialOpcodeValue & 0xFF) - this.opcodeBase;
        int addressIncrement = adjustedOpcode / this.lineRange;
        int lineIncrement = this.lineBase + adjustedOpcode % this.lineRange;
        this.state.line += (byte)(lineIncrement &= 0xFF);
        this.state.address += (long)((addressIncrement &= 0xFF) * this.minInstrLen);
        DWARFLineProgramState row = this.currentState();
        this.state.isBasicBlock = false;
        this.state.prologueEnd = false;
        this.state.epilogueBegin = false;
        this.state.discriminator = 0L;
        return new DWARFLineProgramInstruction(instrOffset, "DW_LN_special_" + specialOpcodeValue, List.of(Integer.valueOf(addressIncrement), Integer.valueOf(lineIncrement)), row);
    }

    private DWARFLineProgramInstruction executeExtended(long instrOffset) throws IOException {
        int length = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        long oldIndex = this.reader.getPointerIndex();
        byte extendedOpcode = this.reader.readNextByte();
        String instr = DWARFLineNumberExtendedOpcodes.toString(extendedOpcode);
        List<Number> operands = List.of();
        DWARFLineProgramState row = null;
        switch (extendedOpcode) {
            case 1: {
                this.state.isEndSequence = true;
                row = this.currentState();
                --row.address;
                this.state = new DWARFLineProgramState(this.defaultIsStatement);
                break;
            }
            case 2: {
                this.state.address = this.reader.readNextUnsignedValue(this.pointerSize);
                operands = List.of(Long.valueOf(this.state.address));
                break;
            }
            case 3: {
                String sourceFilename = this.reader.readNextUtf8String();
                int dirIndex = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                long lastMod = this.reader.readNext(LEB128::unsigned);
                long fileLen = this.reader.readNext(LEB128::unsigned);
                break;
            }
            case 4: {
                this.state.discriminator = this.reader.readNext(LEB128::unsigned);
                operands = List.of(Long.valueOf(this.state.discriminator));
                break;
            }
            default: {
                throw new DWARFLineException("Unknown extended instruction: " + instr);
            }
        }
        if (oldIndex + (long)length != this.reader.getPointerIndex()) {
            throw new DWARFLineException("Bad extended opcode decoding, length mismatch @0x%x: %s".formatted(oldIndex, instr));
        }
        return new DWARFLineProgramInstruction(instrOffset, instr, operands, row);
    }

    private DWARFLineProgramInstruction executeStandard(long instrOffset, int opcode) throws IOException {
        String instr = DWARFLineNumberStandardOpcodes.toString(opcode);
        List<Object> operands = List.of();
        DWARFLineProgramState row = null;
        switch (opcode) {
            case 1: {
                row = this.currentState();
                this.state.discriminator = 0L;
                this.state.isBasicBlock = false;
                this.state.prologueEnd = false;
                this.state.epilogueBegin = false;
                break;
            }
            case 2: {
                long value = this.reader.readNext(LEB128::unsigned);
                operands = List.of(Long.valueOf(value));
                this.state.address += value * (long)this.minInstrLen;
                break;
            }
            case 3: {
                int value = this.reader.readNextVarInt(LEB128::signed);
                operands = List.of(Integer.valueOf(value));
                this.state.line += value;
                break;
            }
            case 4: {
                int value = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                operands = List.of(Integer.valueOf(value));
                this.state.file = value;
                break;
            }
            case 5: {
                int value = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
                operands = List.of(Integer.valueOf(value));
                this.state.column = value;
                break;
            }
            case 6: {
                this.state.isStatement = !this.state.isStatement;
                break;
            }
            case 7: {
                this.state.isBasicBlock = true;
                break;
            }
            case 8: {
                int adjustedOpcode = 255 - this.opcodeBase;
                int addressIncrement = adjustedOpcode / this.lineRange;
                this.state.address += (long)(addressIncrement & 0xFF);
                break;
            }
            case 9: {
                int value = this.reader.readNextUnsignedShort();
                operands = List.of(Integer.valueOf(value));
                this.state.address += (long)value;
                break;
            }
            case 10: {
                this.state.prologueEnd = true;
                break;
            }
            case 11: {
                this.state.epilogueBegin = true;
                break;
            }
            case 12: {
                long value = this.reader.readNext(LEB128::unsigned);
                operands = List.of(Long.valueOf(value));
                this.state.isa = value;
                break;
            }
            default: {
                throw new DWARFLineException("Unsupported standard opcode: " + instr);
            }
        }
        return new DWARFLineProgramInstruction(instrOffset, instr, operands, row);
    }
}

