/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.LEB128Info;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.elf.info.ElfInfoItem;
import ghidra.app.util.bin.format.golang.GoBuildSettings;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoModuleInfo;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GoBuildInfo
implements ElfInfoItem {
    public static final String SECTION_NAME = "go.buildinfo";
    public static final String ELF_SECTION_NAME = ".go.buildinfo";
    public static final String MACHO_SECTION_NAME = "go_buildinfo";
    private static final byte[] GO_BUILDINF_MAGIC = "\u00ff Go buildinf:".getBytes(StandardCharsets.ISO_8859_1);
    private static final byte[] INFOSTART_SENTINEL = NumericUtilities.convertStringToBytes((String)"3077af0c9274080241e1c107e6d618e6");
    private static final byte[] INFOEND_SENTINEL = NumericUtilities.convertStringToBytes((String)"f932433186182072008242104116d8f2");
    private static final int FLAG_ENDIAN = 1;
    private static final int FLAG_INLINE_STRING = 2;
    private final int pointerSize;
    private final Endian endian;
    private final String version;
    private final String path;
    private final GoModuleInfo moduleInfo;
    private final List<GoModuleInfo> dependencies;
    private final List<GoBuildSettings> buildSettings;
    private final StructureDataType struct;

    public static GoBuildInfo fromProgram(Program program) {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> wrappedItem = GoBuildInfo.findBuildInfo(program);
        return wrappedItem != null ? wrappedItem.item() : null;
    }

    public static ElfInfoItem.ItemWithAddress<GoBuildInfo> findBuildInfo(Program program) {
        ElfInfoItem.ItemWithAddress<GoBuildInfo> wrappedItem = GoBuildInfo.readItemFromSection(program, GoRttiMapper.getFirstGoSection(program, SECTION_NAME, MACHO_SECTION_NAME));
        if (wrappedItem == null) {
            wrappedItem = GoBuildInfo.readItemFromSection(program, GoRttiMapper.getGoSection(program, "data"));
        }
        return wrappedItem;
    }

    private static ElfInfoItem.ItemWithAddress<GoBuildInfo> readItemFromSection(Program program, MemoryBlock memBlock) {
        if (memBlock != null) {
            ElfInfoItem.ItemWithAddress<GoBuildInfo> itemWithAddress;
            block9: {
                MemoryByteProvider bp = MemoryByteProvider.createMemoryBlockByteProvider(program.getMemory(), memBlock);
                try {
                    BinaryReader br = new BinaryReader(bp, !program.getMemory().isBigEndian());
                    GoBuildInfo item = GoBuildInfo.read(br, program);
                    itemWithAddress = new ElfInfoItem.ItemWithAddress<GoBuildInfo>(item, memBlock.getStart());
                    if (bp == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bp != null) {
                            try {
                                bp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                bp.close();
            }
            return itemWithAddress;
        }
        return null;
    }

    public static GoBuildInfo read(BinaryReader reader, Program program) throws IOException {
        boolean inlineStr;
        byte[] magicBytes = reader.readNextByteArray(GO_BUILDINF_MAGIC.length);
        if (!Arrays.equals(magicBytes, GO_BUILDINF_MAGIC)) {
            throw new IOException("Missing GoBuildInfo magic");
        }
        int pointerSize = reader.readNextUnsignedByte();
        int flags = reader.readNextUnsignedByte();
        Endian endian = (flags & 1) == 0 ? Endian.LITTLE : Endian.BIG;
        boolean bl = inlineStr = (flags & 2) != 0;
        if (reader.isBigEndian() && endian != Endian.BIG) {
            throw new IOException("Mixed endian-ness");
        }
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        StructureDataType struct = new StructureDataType(GoConstants.GOLANG_CATEGORYPATH, "GoBuildInfo", 0, (DataTypeManager)dtm);
        struct.add((DataType)new ArrayDataType(StructConverter.ASCII, 14, -1, (DataTypeManager)dtm), "magic", "\\xff Go buildinf:");
        struct.add(StructConverter.BYTE, "ptrSize", null);
        struct.add(StructConverter.BYTE, "flags", null);
        return GoBuildInfo.readStringInfo(reader, inlineStr, program, pointerSize, struct);
    }

    public static boolean isPresent(InputStream is) {
        try {
            byte[] buffer = new byte[GO_BUILDINF_MAGIC.length];
            int bytesRead = is.read(buffer);
            return bytesRead == GO_BUILDINF_MAGIC.length && Arrays.equals(buffer, GO_BUILDINF_MAGIC);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private GoBuildInfo(int pointerSize, Endian endian, String version, String path, GoModuleInfo moduleInfo, List<GoModuleInfo> dependencies, List<GoBuildSettings> buildSettings, StructureDataType struct) {
        this.pointerSize = pointerSize;
        this.endian = endian;
        this.version = version;
        this.path = path;
        this.moduleInfo = moduleInfo;
        this.dependencies = dependencies;
        this.buildSettings = buildSettings;
        this.struct = struct;
    }

    public int getPointerSize() {
        return this.pointerSize;
    }

    public Endian getEndian() {
        return this.endian;
    }

    public String getVersion() {
        return this.version;
    }

    public GoVer getGoVer() {
        return GoVer.parse(this.version);
    }

    public String getPath() {
        return this.path;
    }

    public GoModuleInfo getModuleInfo() {
        return this.moduleInfo;
    }

    public List<GoModuleInfo> getDependencies() {
        return this.dependencies;
    }

    public List<GoBuildSettings> getBuildSettings() {
        return this.buildSettings;
    }

    @Override
    public void markupProgram(Program program, Address address) {
        this.decorateProgramInfo(program.getOptions("Program Information"));
        try {
            if (this.struct != null) {
                DataUtilities.createData((Program)program, (Address)address, (DataType)this.struct, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
            }
        }
        catch (CodeUnitInsertionException e) {
            Msg.error((Object)this, (Object)"Failed to markup GoBuildInfo at %s: %s".formatted(address, this));
        }
    }

    public void decorateProgramInfo(Options props) {
        GoVer.setProgramPropertiesWithOriginalVersionString(props, this.getVersion());
        props.setString("Golang app path", this.getPath());
        if (this.getModuleInfo() != null) {
            this.getModuleInfo().asKeyValuePairs("Golang main package ").entrySet().stream().forEach(entry -> props.setString((String)entry.getKey(), (String)entry.getValue()));
        }
        int depNum = 0;
        for (GoModuleInfo dep : this.getDependencies()) {
            String key = "Golang dep[%4d]".formatted(depNum++);
            props.setString(key, dep.getFormattedString());
        }
        for (GoBuildSettings buildSetting : this.getBuildSettings()) {
            props.setString("Golang build[" + buildSetting.key().replaceAll("\\.", "_") + "]", buildSetting.value());
        }
    }

    StructureDataType toStructure(DataTypeManager dtm) {
        return this.struct.clone(dtm);
    }

    public String toString() {
        return String.format("GoBuildInfo [pointerSize=%s, endian=%s, version=%s, path=%s]", this.pointerSize, this.endian, this.version, this.path);
    }

    private static GoBuildInfo readStringInfo(BinaryReader reader, boolean inlineStr, Program program, int ptrSize, StructureDataType struct) throws IOException {
        String moduleString;
        String versionString;
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        if (inlineStr) {
            reader.setPointerIndex(32);
            LEB128Info verStrLen = reader.readNext(LEB128Info::unsigned);
            byte[] versionStringBytes = reader.readNextByteArray(verStrLen.asInt32());
            versionString = new String(versionStringBytes, StandardCharsets.UTF_8);
            LEB128Info modStrLen = reader.readNext(LEB128Info::unsigned);
            byte[] moduleStringBytes = reader.readNextByteArray(modStrLen.asInt32());
            struct.add((DataType)new ArrayDataType(StructConverter.BYTE, 16, -1, (DataTypeManager)dtm), -1, "padding", null);
            struct.add((DataType)new UnsignedLeb128DataType((DataTypeManager)dtm), verStrLen.getLength(), "versionlen", null);
            struct.add((DataType)new ArrayDataType(StructConverter.ASCII, verStrLen.asInt32(), -1, (DataTypeManager)dtm), -1, "version", null);
            struct.add((DataType)new UnsignedLeb128DataType((DataTypeManager)dtm), modStrLen.getLength(), "modulelen", null);
            moduleString = GoBuildInfo.extractModuleString(moduleStringBytes, struct);
            try {
                String structNameSuffix = "_inline_%d_%d_%d_%d".formatted(verStrLen.getLength(), verStrLen.asInt32(), modStrLen.getLength(), modStrLen.asInt32());
                struct.setName(struct.getName() + structNameSuffix);
            }
            catch (InvalidNameException structNameSuffix) {}
        } else {
            reader.setPointerIndex(16);
            long versionStrOffset = reader.readNextUnsignedValue(ptrSize);
            long moduleStrOffset = reader.readNextUnsignedValue(ptrSize);
            MemoryByteProvider memBP = new MemoryByteProvider(program.getMemory(), program.getImageBase().getAddressSpace());
            BinaryReader fullReader = new BinaryReader(memBP, reader.isLittleEndian());
            fullReader.setPointerIndex(versionStrOffset);
            versionString = GoBuildInfo.readGoString(fullReader, ptrSize);
            fullReader.setPointerIndex(moduleStrOffset);
            byte[] moduleStrBytes = GoBuildInfo.readRawGoString(fullReader, ptrSize);
            moduleString = GoBuildInfo.extractModuleString(moduleStrBytes, null);
            DataType ofsDT = AbstractIntegerDataType.getUnsignedDataType((int)ptrSize, (DataTypeManager)dtm);
            struct.add(ofsDT, -1, "versionofs", null);
            struct.add(ofsDT, -1, "moduleofs", null);
        }
        return GoBuildInfo.parseBuildInfo(ptrSize, reader.isBigEndian() ? Endian.BIG : Endian.LITTLE, versionString, moduleString, struct);
    }

    private static GoBuildInfo parseBuildInfo(int pointerSize, Endian endian, String versionString, String moduleString, StructureDataType struct) throws IOException {
        String path = null;
        GoModuleInfo module = null;
        ArrayList<GoModuleInfo> deps = new ArrayList<GoModuleInfo>();
        ArrayList<GoBuildSettings> buildSettings = new ArrayList<GoBuildSettings>();
        String[] lines = moduleString.split("\n");
        block12: for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String replaceInfo;
            String line = lines[lineNum];
            String string = replaceInfo = lineNum + 1 < lines.length && lines[lineNum + 1].startsWith("=>\t") ? lines[++lineNum].substring(3) : null;
            if (line.isBlank()) continue;
            String[] lineParts = line.split("\t", 2);
            switch (lineParts[0]) {
                case "path": {
                    path = lineParts[1];
                    continue block12;
                }
                case "mod": {
                    GoModuleInfo replace = replaceInfo != null ? GoModuleInfo.fromString(replaceInfo, null) : null;
                    module = GoModuleInfo.fromString(lineParts[1], replace);
                    continue block12;
                }
                case "dep": {
                    GoModuleInfo dep = GoModuleInfo.fromString(lineParts[1], null);
                    deps.add(dep);
                    continue block12;
                }
                case "build": {
                    GoBuildSettings build = GoBuildSettings.fromString(lineParts[1]);
                    buildSettings.add(build);
                }
            }
        }
        if (versionString.startsWith("go")) {
            versionString = versionString.substring(2);
        }
        return new GoBuildInfo(pointerSize, endian, versionString, path, module, deps, buildSettings, struct);
    }

    private static String extractModuleString(byte[] bytes, StructureDataType struct) throws IOException {
        int sentLen = INFOSTART_SENTINEL.length;
        if (bytes.length < sentLen * 2) {
            return "";
        }
        int sentEndStart = bytes.length - sentLen;
        if (!Arrays.equals(INFOSTART_SENTINEL, 0, sentLen, bytes, 0, sentLen) || !Arrays.equals(INFOEND_SENTINEL, 0, sentLen, bytes, sentEndStart, bytes.length)) {
            throw new IOException("bad sentinel");
        }
        int moduleStrLen = bytes.length - sentLen * 2;
        if (struct != null) {
            struct.add((DataType)new ArrayDataType(StructConverter.BYTE, sentLen, -1, struct.getDataTypeManager()), -1, "sentinelstart", null);
            struct.add((DataType)new ArrayDataType(StructConverter.ASCII, moduleStrLen, -1, struct.getDataTypeManager()), -1, "moduleinfo", null);
            struct.add((DataType)new ArrayDataType(StructConverter.BYTE, sentLen, -1, struct.getDataTypeManager()), -1, "sentinelend", null);
        }
        return new String(bytes, sentLen, moduleStrLen, StandardCharsets.UTF_8);
    }

    private static String readGoString(BinaryReader reader, int ptrSize) throws IOException {
        byte[] bytes = GoBuildInfo.readRawGoString(reader, ptrSize);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static byte[] readRawGoString(BinaryReader reader, int ptrSize) throws IOException {
        long dataAddr = reader.readNextUnsignedValue(ptrSize);
        long dataLen = reader.readNextUnsignedValue(ptrSize);
        if (dataAddr == 0L || dataLen == 0L) {
            return new byte[0];
        }
        byte[] bytes = reader.readByteArray(dataAddr, (int)dataLen);
        return bytes;
    }
}

