/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.LocalVariable;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class GoFunctionFixup {
    public static void fixupFunction(Function func) throws DuplicateNameException, InvalidInputException {
        Program program = func.getProgram();
        GoVer goVersion = GoVer.fromProgramProperties(program);
        GoFunctionFixup.fixupFunction(func, goVersion);
    }

    public static void fixupFunction(Function func, GoVer goVersion) throws DuplicateNameException, InvalidInputException {
        Program program = func.getProgram();
        GoParamStorageAllocator storageAllocator = new GoParamStorageAllocator(program, goVersion);
        if (GoFunctionFixup.isGolangAbi0Func(func)) {
            storageAllocator.setAbi0Mode();
        }
        GoFunctionFixup.fixupFunction(func, storageAllocator);
    }

    private static void fixupFunction(Function func, GoParamStorageAllocator storageAllocator) throws DuplicateNameException, InvalidInputException {
        ArrayList<ParameterImpl> spillVars = new ArrayList<ParameterImpl>();
        Program program = func.getProgram();
        ArrayList<ParameterImpl> newParams = new ArrayList<ParameterImpl>();
        for (Parameter oldParam : func.getParameters()) {
            DataType dt = oldParam.getFormalDataType();
            ParameterImpl newParam = null;
            List<Register> regStorage = storageAllocator.getRegistersFor(dt);
            if (regStorage != null && !regStorage.isEmpty()) {
                newParam = GoFunctionFixup.updateParamWithCustomRegisterStorage(oldParam, regStorage);
                spillVars.add(newParam);
                if (dt instanceof Structure && newParam.getVariableStorage().size() != dt.getLength()) {
                    MarkupSession.logWarningAt(program, func.getEntryPoint(), "Known storage allocation problem: param %s register allocation for structs missing inter-field padding.".formatted(newParam.toString()));
                }
            } else {
                newParam = GoFunctionFixup.updateParamWithStackStorage(oldParam, storageAllocator);
            }
            newParams.add(newParam);
        }
        storageAllocator.alignStack();
        storageAllocator.resetRegAllocation();
        DataType returnDT = func.getReturnType();
        ArrayList<LocalVariable> returnResultAliasVars = new ArrayList<LocalVariable>();
        ReturnParameterImpl returnParam = returnDT != null ? GoFunctionFixup.updateReturn(func, storageAllocator, returnResultAliasVars) : null;
        storageAllocator.alignStack();
        if (returnParam == null && newParams.isEmpty()) {
            return;
        }
        try {
            func.updateFunction(null, (Variable)returnParam, newParams, Function.FunctionUpdateType.CUSTOM_STORAGE, true, SourceType.USER_DEFINED);
        }
        catch (DuplicateNameException | InvalidInputException e) {
            MarkupSession.logWarningAt(program, func.getEntryPoint(), "Failed to update function signature: " + e.getMessage());
            return;
        }
        for (Variable localVar : func.getLocalVariables()) {
            if (!localVar.isStackVariable() || GoFunctionFixup.isInLocalVarStorageArea(func, localVar.getStackOffset())) continue;
            func.removeVariable(localVar);
        }
        for (ParameterImpl param : spillVars) {
            DataType paramDT = param.getFormalDataType();
            long stackOffset = storageAllocator.getStackAllocation(paramDT);
            Varnode stackVarnode = new Varnode(program.getAddressFactory().getStackSpace().getAddress(stackOffset), paramDT.getLength());
            VariableStorage varStorage = new VariableStorage((ProgramArchitecture)program, List.of(stackVarnode));
            LocalVariableImpl localVar = new LocalVariableImpl(param.getName() + "_spill", 0, paramDT, varStorage, program);
            func.addLocalVariable((Variable)localVar, SourceType.USER_DEFINED);
        }
        for (LocalVariable returnResultAliasVar : returnResultAliasVars) {
            func.addLocalVariable((Variable)returnResultAliasVar, SourceType.USER_DEFINED);
        }
    }

    public static DataType makeEmptyArrayDataType(DataType dt) {
        StructureDataType struct = new StructureDataType(dt.getCategoryPath(), "empty_" + dt.getName(), 0, dt.getDataTypeManager());
        struct.setToDefaultPacking();
        return struct;
    }

    private static ParameterImpl updateParamWithCustomRegisterStorage(Parameter oldParam, List<Register> regStorage) throws InvalidInputException {
        Program program = oldParam.getProgram();
        DataType dt = oldParam.getDataType();
        List<Varnode> varnodes = DWARFUtil.convertRegisterListToVarnodeStorage(regStorage, dt.getLength());
        VariableStorage varStorage = new VariableStorage((ProgramArchitecture)program, (Varnode[])varnodes.toArray(Varnode[]::new));
        ParameterImpl newParam = new ParameterImpl(oldParam.getName(), -2, dt, varStorage, true, program, SourceType.USER_DEFINED);
        return newParam;
    }

    private static ParameterImpl updateParamWithStackStorage(Parameter oldParam, GoParamStorageAllocator storageAllocator) throws InvalidInputException {
        DataType dt = oldParam.getDataType();
        Program program = oldParam.getProgram();
        if (!DWARFUtil.isZeroByteDataType(dt)) {
            long stackOffset = storageAllocator.getStackAllocation(dt);
            return new ParameterImpl(oldParam.getName(), dt, (int)stackOffset, program);
        }
        if (DWARFUtil.isEmptyArray(dt)) {
            dt = GoFunctionFixup.makeEmptyArrayDataType(dt);
        }
        Address zerobaseAddress = GoRttiMapper.getZerobaseAddress(program);
        return new ParameterImpl(oldParam.getName(), dt, zerobaseAddress, program, SourceType.USER_DEFINED);
    }

    private static ReturnParameterImpl updateReturn(Function func, GoParamStorageAllocator storageAllocator, List<LocalVariable> returnResultAliasVars) throws InvalidInputException {
        Program program = func.getProgram();
        ProgramBasedDataTypeManager dtm = program.getDataTypeManager();
        DataType returnDT = func.getReturnType();
        ArrayList<Varnode> varnodes = new ArrayList<Varnode>();
        if (returnDT == null || Undefined.isUndefined((DataType)returnDT) || DWARFUtil.isVoid(returnDT)) {
            return null;
        }
        GoFunctionMultiReturn multiReturn = GoFunctionMultiReturn.fromStructure(returnDT, (DataTypeManager)dtm, storageAllocator);
        if (multiReturn != null) {
            returnDT = multiReturn.getStruct();
            for (DataTypeComponent dtc : multiReturn.getNormalStorageComponents()) {
                GoFunctionFixup.allocateReturnStorage(program, dtc.getFieldName() + "_return_result_alias", dtc.getDataType(), storageAllocator, varnodes, returnResultAliasVars, false);
            }
            for (DataTypeComponent dtc : multiReturn.getStackStorageComponents()) {
                GoFunctionFixup.allocateReturnStorage(program, dtc.getFieldName() + "_return_result_alias", dtc.getDataType(), storageAllocator, varnodes, returnResultAliasVars, false);
            }
            if (!program.getMemory().isBigEndian()) {
                GoFunctionFixup.reverseNonStackStorageLocations(varnodes);
            }
        } else if (DWARFUtil.isZeroByteDataType(returnDT)) {
            if (DWARFUtil.isEmptyArray(returnDT)) {
                returnDT = GoFunctionFixup.makeEmptyArrayDataType(returnDT);
            }
            varnodes.add(new Varnode(GoRttiMapper.getZerobaseAddress(program), 1));
        } else {
            GoFunctionFixup.allocateReturnStorage(program, "return_value_alias_variable", returnDT, storageAllocator, varnodes, returnResultAliasVars, true);
        }
        if (varnodes.isEmpty()) {
            return null;
        }
        VariableStorage varStorage = new VariableStorage((ProgramArchitecture)program, (Varnode[])varnodes.toArray(Varnode[]::new));
        return new ReturnParameterImpl(returnDT, varStorage, true, program);
    }

    private static void allocateReturnStorage(Program program, String name_unused, DataType dt, GoParamStorageAllocator storageAllocator, List<Varnode> varnodes, List<LocalVariable> returnResultAliasVars, boolean allowEndianFixups) throws InvalidInputException {
        List<Register> regStorage = storageAllocator.getRegistersFor(dt, allowEndianFixups);
        if (regStorage != null && !regStorage.isEmpty()) {
            varnodes.addAll(DWARFUtil.convertRegisterListToVarnodeStorage(regStorage, dt.getLength()));
        } else if (!DWARFUtil.isZeroByteDataType(dt)) {
            Varnode prev;
            long stackOffset = storageAllocator.getStackAllocation(dt);
            Varnode varnode = prev = !varnodes.isEmpty() ? varnodes.get(varnodes.size() - 1) : null;
            if (prev != null && prev.getAddress().isStackAddress()) {
                Varnode updatedVN = new Varnode(prev.getAddress(), prev.getSize() + dt.getLength());
                varnodes.set(varnodes.size() - 1, updatedVN);
            } else {
                varnodes.add(new Varnode(program.getAddressFactory().getStackSpace().getAddress(stackOffset), dt.getLength()));
            }
            LocalVariableImpl returnAliasLocalVar = new LocalVariableImpl(name_unused, dt, (int)stackOffset, program, SourceType.USER_DEFINED);
            returnResultAliasVars.add((LocalVariable)returnAliasLocalVar);
        }
    }

    public static boolean isGolangAbi0Func(Function func) {
        Address funcAddr = func.getEntryPoint();
        for (Symbol symbol : func.getProgram().getSymbolTable().getSymbolsAsIterator(funcAddr)) {
            String labelName;
            if (symbol.getSymbolType() != SymbolType.LABEL && symbol.getSymbolType() != SymbolType.FUNCTION || !(labelName = symbol.getName()).endsWith("abi0")) continue;
            return true;
        }
        return false;
    }

    public static boolean isInLocalVarStorageArea(Function func, long stackOffset) {
        Program program = func.getProgram();
        boolean paramsHavePositiveOffset = program.getCompilerSpec().stackGrowsNegative();
        return paramsHavePositiveOffset && stackOffset < 0L || !paramsHavePositiveOffset && stackOffset >= 0L;
    }

    public static void reverseNonStackStorageLocations(List<Varnode> varnodes) {
        int regStorageCount;
        for (regStorageCount = 0; regStorageCount < varnodes.size() && !DWARFUtil.isStackVarnode(varnodes.get(regStorageCount)); ++regStorageCount) {
        }
        ArrayList<Varnode> regStorageList = new ArrayList<Varnode>(varnodes.subList(0, regStorageCount));
        for (int i = 0; i < regStorageList.size(); ++i) {
            varnodes.set(i, (Varnode)regStorageList.get(regStorageList.size() - 1 - i));
        }
    }
}

