/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoRegisterInfoManager;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.util.NumericUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GoParamStorageAllocator {
    private static final int INTREG = 0;
    private static final int FLOATREG = 1;
    private List<List<Register>> regs;
    private int[] nextReg = new int[2];
    private GoRegisterInfo callspecInfo;
    private long stackOffset;
    private boolean isBigEndian;
    private String archDescription;

    public GoParamStorageAllocator(Program program, GoVer goVersion) {
        Language lang = program.getLanguage();
        this.callspecInfo = GoRegisterInfoManager.getInstance().getRegisterInfoForLang(lang, goVersion);
        this.stackOffset = this.callspecInfo.getStackInitialOffset();
        this.regs = List.of(this.callspecInfo.getIntRegisters(), this.callspecInfo.getFloatRegisters());
        this.isBigEndian = lang.isBigEndian();
        this.archDescription = "%s_%d".formatted(lang.getLanguageDescription().getProcessor().toString(), lang.getLanguageDescription().getSize());
    }

    private GoParamStorageAllocator(List<List<Register>> regs, int[] nextReg, GoRegisterInfo callspecInfo, long stackOffset, boolean isBigEndian, String archDescription) {
        this.regs = List.of(regs.get(0), regs.get(1));
        this.nextReg = new int[]{nextReg[0], nextReg[1]};
        this.callspecInfo = callspecInfo;
        this.stackOffset = stackOffset;
        this.isBigEndian = isBigEndian;
        this.archDescription = archDescription;
    }

    public GoParamStorageAllocator clone() {
        return new GoParamStorageAllocator(this.regs, this.nextReg, this.callspecInfo, this.stackOffset, this.isBigEndian, this.archDescription);
    }

    public String getArchDescription() {
        return this.archDescription;
    }

    public boolean isBigEndian() {
        return this.isBigEndian;
    }

    public void resetRegAllocation() {
        this.nextReg[0] = 0;
        this.nextReg[1] = 0;
    }

    private boolean allocateReg(int count, int regType, DataType dt, List<Register> result) {
        int newNextReg = this.nextReg[regType] + count;
        if (newNextReg > this.regs.get(regType).size()) {
            return false;
        }
        int remainingSize = dt.getLength();
        for (int regNum = this.nextReg[regType]; regNum < newNextReg; ++regNum) {
            Register reg = this.getBestFitRegister(this.regs.get(regType).get(regNum), remainingSize);
            remainingSize -= reg.getMinimumByteSize();
            result.add(reg);
        }
        this.nextReg[regType] = newNextReg;
        return true;
    }

    private Register getBestFitRegister(Register reg, int size) {
        while (reg.getMinimumByteSize() > size && reg.hasChildren()) {
            reg = (Register)reg.getChildRegisters().get(0);
        }
        return reg;
    }

    private int[] saveRegAllocation() {
        return new int[]{this.nextReg[0], this.nextReg[1]};
    }

    private void restoreRegAllocation(int[] savedNextReg) {
        this.nextReg[0] = savedNextReg[0];
        this.nextReg[1] = savedNextReg[1];
    }

    public void setAbi0Mode() {
        this.regs = List.of(List.of(), List.of());
    }

    public boolean isAbi0Mode() {
        return this.regs.get(0).isEmpty() && this.regs.get(1).isEmpty();
    }

    public Register getNextIntParamRegister(Register reg) {
        List<Register> intRegs = this.regs.get(0);
        for (int regNum = 0; regNum < intRegs.size() - 1; ++regNum) {
            Register tmpReg = intRegs.get(regNum);
            if (!tmpReg.equals((Object)reg)) continue;
            return intRegs.get(regNum + 1);
        }
        return null;
    }

    public List<Register> getRegistersFor(DataType dt) {
        return this.getRegistersFor(dt, true);
    }

    public List<Register> getRegistersFor(DataType dt, boolean allowEndianFixups) {
        int[] saveRegAllocation = this.saveRegAllocation();
        ArrayList<Register> result = new ArrayList<Register>();
        if (!this.countRegistersFor(dt, result)) {
            this.restoreRegAllocation(saveRegAllocation);
            return null;
        }
        if (allowEndianFixups && !this.isBigEndian && result.size() > 1) {
            Collections.reverse(result);
        }
        return new ArrayList<Register>(result);
    }

    public long getStackAllocation(DataType dt) {
        if (dt.isZeroLength()) {
            return this.stackOffset;
        }
        this.alignStackFor(dt);
        long result = this.stackOffset;
        this.stackOffset += (long)dt.getLength();
        return result;
    }

    public long getStackOffset() {
        return this.stackOffset;
    }

    public void setStackOffset(long newStackOffset) {
        this.stackOffset = newStackOffset;
    }

    public void alignStackFor(DataType dt) {
        int alignmentSize = this.callspecInfo.getAlignmentForType(dt);
        this.stackOffset = NumericUtilities.getUnsignedAlignedValue((long)this.stackOffset, (long)alignmentSize);
    }

    public void alignStack() {
        this.stackOffset = NumericUtilities.getUnsignedAlignedValue((long)this.stackOffset, (long)this.callspecInfo.getMaxAlign());
    }

    private boolean countRegistersFor(DataType dt, List<Register> result) {
        int intRegSize;
        int size;
        if (DWARFUtil.isZeroByteDataType(dt)) {
            return false;
        }
        if (dt instanceof TypeDef) {
            TypeDef typedefDT = (TypeDef)dt;
            dt = typedefDT.getBaseDataType();
        }
        if (dt instanceof Pointer) {
            return this.allocateReg(1, 0, dt, result);
        }
        if (GoRegisterInfo.isIntType(dt) && (size = dt.getLength()) <= (intRegSize = this.callspecInfo.getIntRegisterSize()) * 2) {
            return this.allocateReg((int)(NumericUtilities.getUnsignedAlignedValue((long)size, (long)intRegSize) / (long)intRegSize), 0, dt, result);
        }
        if (dt instanceof AbstractFloatDataType) {
            return this.allocateReg(1, 1, dt, result);
        }
        if (dt instanceof Array) {
            Array array = (Array)dt;
            int numElements = array.getNumElements();
            if (numElements == 0) {
                return true;
            }
            return numElements == 1 && this.countRegistersFor(array.getDataType(), result);
        }
        if (dt instanceof Structure) {
            Structure struct = (Structure)dt;
            Object prevDTC = null;
            for (DataTypeComponent dtc : struct.getDefinedComponents()) {
                int padding;
                int n = padding = prevDTC != null ? dtc.getOffset() - prevDTC.getOffset() : 0;
                if (padding != 0) {
                    // empty if block
                }
                if (this.countRegistersFor(dtc.getDataType(), result)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

