/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang;

import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import java.util.Objects;

public class GoVer
implements Comparable<GoVer> {
    public static final GoVer INVALID = new GoVer(0, 0);
    public static final GoVer ANY = new GoVer(-1, -1);
    public static final GoVer V1_2 = new GoVer(1, 2);
    public static final GoVer V1_16 = new GoVer(1, 16);
    public static final GoVer V1_17 = new GoVer(1, 17);
    public static final GoVer V1_18 = new GoVer(1, 18);
    private final int major;
    private final int minor;
    public static final String GOLANG_VERSION_PROPERTY_NAME = "Golang go version";

    public GoVer(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public boolean isInvalid() {
        return this.major == 0 && this.minor == 0;
    }

    public boolean isWildcard() {
        return this.major == -1 && this.minor == -1;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(GoVer o) {
        int result = Integer.compare(this.major, o.major);
        if (result == 0) {
            result = Integer.compare(this.minor, o.minor);
        }
        return result;
    }

    public boolean isAtLeast(GoVer otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    public boolean inRange(GoVer min, GoVer max) {
        return min.compareTo(this) <= 0 && this.compareTo(max) <= 0;
    }

    public static GoVer parse(String s) {
        String[] parts = Objects.requireNonNullElse(s, "").split("\\.");
        if (parts.length < 2) {
            return INVALID;
        }
        try {
            int major = Integer.parseInt(parts[0]);
            int minor = Integer.parseInt(parts[1]);
            return new GoVer(major, minor);
        }
        catch (NumberFormatException numberFormatException) {
            return INVALID;
        }
    }

    public static GoVer fromProgramProperties(Program program) {
        Options props = program.getOptions("Program Information");
        String verStr = props.getString(GOLANG_VERSION_PROPERTY_NAME, null);
        return GoVer.parse(verStr);
    }

    public static void setProgramPropertiesWithOriginalVersionString(Options props, String s) {
        props.setString(GOLANG_VERSION_PROPERTY_NAME, s);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GoVer)) {
            return false;
        }
        GoVer other = (GoVer)obj;
        return this.major == other.major && this.minor == other.minor;
    }

    public String toString() {
        return "%d.%d".formatted(this.major, this.minor);
    }
}

