/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoVarlenString;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutput;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.data.DataType;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;

@StructureMapping(structureName={"GoName"})
public class GoName
implements StructureReader<GoName>,
StructureMarkup<GoName> {
    @ContextField
    private StructureContext<GoName> context;
    @ContextField
    private GoRttiMapper programContext;
    @FieldOutput(dataTypeName="byte")
    @EOLComment(value="flagsSet")
    int flags;
    @FieldOutput(isVariableLength=true)
    @EOLComment(value="getFullNameString")
    GoVarlenString name;
    @FieldOutput(isVariableLength=true)
    GoVarlenString tag;
    @FieldOutput(isVariableLength=true, getter="getPkgPathDataType")
    @MarkupReference(value="getPkgPath")
    long pkgPath;

    @Override
    public void readStructure() throws IOException {
        this.flags = this.context.getReader().readNextUnsignedByte();
        this.name = this.programContext.readStructure(GoVarlenString.class, this.context.getReader());
        this.tag = Flag.HAS_TAG.isSet(this.flags) ? this.programContext.readStructure(GoVarlenString.class, this.context.getReader()) : null;
        this.pkgPath = Flag.HAS_PKGPATH.isSet(this.flags) ? this.context.getReader().readNextUnsignedInt() : 0L;
    }

    public String getName() {
        return this.name.getString();
    }

    public String getTag() {
        return this.tag != null ? this.tag.getString() : "";
    }

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.pkgPath);
    }

    public DataType getPkgPathDataType() {
        return Flag.HAS_PKGPATH.isSet(this.flags) ? this.programContext.getInt32DT() : null;
    }

    public String getFullNameString() {
        String packagePathString = "";
        try {
            GoName pkgPathName = this.getPkgPath();
            packagePathString = pkgPathName != null ? pkgPathName.getFullNameString() + "." : "";
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packagePathString + this.getName();
    }

    public int getFlags() {
        return this.flags;
    }

    public Set<Flag> getFlagsSet() {
        return Flag.parseFlags(this.flags);
    }

    @Override
    public StructureContext<GoName> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() throws IOException {
        return this.getName();
    }

    public String toString() {
        return String.format("GoName [context=%s, flags=%s, name=%s, tag=%s, pkgPath=%s, getFullNameString(): %s]", this.context, this.flags, this.name, this.tag, this.pkgPath, this.getFullNameString());
    }

    public static GoName createFakeInstance(final String fakeName) {
        return new GoName(){

            @Override
            public String getName() {
                return fakeName;
            }
        };
    }

    public static enum Flag {
        EXPORTED(1),
        HAS_TAG(2),
        HAS_PKGPATH(4),
        EMBEDDED(8);

        private final int flagValue;

        private Flag(int flagValue) {
            this.flagValue = flagValue;
        }

        public boolean isSet(int value) {
            return (value & this.flagValue) != 0;
        }

        public static Set<Flag> parseFlags(int b) {
            EnumSet<Flag> result = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if (!flag.isSet(b)) continue;
                result.add(flag);
            }
            return result;
        }
    }
}

