/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.program.model.data.LEB128;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class GoPcValueEvaluator {
    private final int pcquantum;
    private final long funcEntry;
    private final BinaryReader reader;
    private int value = -1;
    private long pc;

    public GoPcValueEvaluator(GoFuncData func, long offset) throws IOException {
        GoModuledata moduledata = func.getModuledata();
        this.pcquantum = moduledata.getGoBinary().getMinLC();
        this.reader = moduledata.getPcValueTable().getElementReader(1, (int)offset);
        this.pc = this.funcEntry = func.getFuncAddress().getOffset();
    }

    public long getMaxPC() throws IOException {
        this.eval(Long.MAX_VALUE);
        return this.pc;
    }

    public int eval(long targetPC) throws IOException {
        while (this.pc <= targetPC) {
            if (this.step()) continue;
            return -1;
        }
        return this.value;
    }

    public List<Integer> evalAll(long targetPC) throws IOException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (this.pc <= targetPC) {
            if (!this.step()) {
                return result;
            }
            result.add(this.value);
        }
        return result;
    }

    private boolean step() throws IOException {
        int uvdelta = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        if (uvdelta == 0 && this.pc != this.funcEntry) {
            return false;
        }
        this.value += -(uvdelta & 1) ^ uvdelta >> 1;
        int pcdelta = this.reader.readNextUnsignedVarIntExact(LEB128::unsigned);
        this.pc += (long)(pcdelta * this.pcquantum);
        return true;
    }
}

