/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.TransientProgramProperties;
import ghidra.app.plugin.core.datamgr.util.DataTypeArchiveUtility;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.golang.BootstrapInfoException;
import ghidra.app.util.bin.format.golang.GoBuildInfo;
import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoFunctionFixup;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.GoParamStorageAllocator;
import ghidra.app.util.bin.format.golang.GoRegisterInfo;
import ghidra.app.util.bin.format.golang.GoRegisterInfoManager;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoFuncData;
import ghidra.app.util.bin.format.golang.rtti.GoFunctabEntry;
import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoPcHeader;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.GoSourceFileInfo;
import ghidra.app.util.bin.format.golang.rtti.GoString;
import ghidra.app.util.bin.format.golang.rtti.GoVarlenString;
import ghidra.app.util.bin.format.golang.rtti.MethodInfo;
import ghidra.app.util.bin.format.golang.rtti.types.GoArrayType;
import ghidra.app.util.bin.format.golang.rtti.types.GoBaseType;
import ghidra.app.util.bin.format.golang.rtti.types.GoChanType;
import ghidra.app.util.bin.format.golang.rtti.types.GoFuncType;
import ghidra.app.util.bin.format.golang.rtti.types.GoIMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMapType;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.rtti.types.GoPlainType;
import ghidra.app.util.bin.format.golang.rtti.types.GoPointerType;
import ghidra.app.util.bin.format.golang.rtti.types.GoSliceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructField;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeDetector;
import ghidra.app.util.bin.format.golang.rtti.types.GoUncommonType;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapperContext;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMappingInfo;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.Platform;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class GoRttiMapper
extends DataTypeMapper
implements DataTypeMapperContext {
    public static final GoVer SUPPORTED_MIN_VER = new GoVer(1, 15);
    public static final GoVer SUPPORTED_MAX_VER = new GoVer(1, 22);
    private static final List<String> SYMBOL_SEARCH_PREFIXES = List.of("", "_");
    private static final List<String> SECTION_PREFIXES = List.of(".", "__");
    private static final String FAILED_FLAG = "FAILED TO FIND GOLANG BINARY";
    public static final String ARTIFICIAL_RUNTIME_ZEROBASE_SYMBOLNAME = "ARTIFICIAL.runtime.zerobase";
    private static final CategoryPath RECOVERED_TYPES_CP = GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
    private static final CategoryPath GOLANG_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final CategoryPath VARLEN_STRUCTS_CP = GoConstants.GOLANG_CATEGORYPATH;
    private static final List<Class<?>> GOLANG_STRUCTMAPPED_CLASSES = List.of(GoModuledata.class, GoName.class, GoVarlenString.class, GoSlice.class, GoBaseType.class, GoTypeDetector.class, GoPlainType.class, GoUncommonType.class, GoArrayType.class, GoChanType.class, GoFuncType.class, GoInterfaceType.class, GoMapType.class, GoPointerType.class, GoSliceType.class, GoIface.class, GoStructType.class, GoMethod.class, GoStructField.class, GoIMethod.class, GoFunctabEntry.class, GoFuncData.class, GoItab.class, GoString.class, GoPcHeader.class);
    private final BinaryReader reader;
    private final GoVer goVersion;
    private final int ptrSize;
    private final Endian endian;
    private final DataType uintptrDT;
    private final DataType int32DT;
    private final DataType uint32DT;
    private final DataType uint8DT;
    private final DataType stringDT;
    private final Map<Long, GoType> goTypes = new HashMap<Long, GoType>();
    private final Map<String, GoType> typeNameIndex = new HashMap<String, GoType>();
    private final Map<Long, String> fixedGoTypeNames = new HashMap<Long, String>();
    private final Map<Long, DataType> cachedRecoveredDataTypes = new HashMap<Long, DataType>();
    private final List<GoModuledata> modules = new ArrayList<GoModuledata>();
    private Map<Address, GoFuncData> funcdataByAddr = new HashMap<Address, GoFuncData>();
    private Map<String, GoFuncData> funcdataByName = new HashMap<String, GoFuncData>();
    private Map<Address, List<MethodInfo>> methodsByAddr = new HashMap<Address, List<MethodInfo>>();
    private Map<Long, List<GoItab>> interfacesImplementedByType = new HashMap<Long, List<GoItab>>();
    private byte minLC;
    private GoType mapGoType;
    private GoType chanGoType;
    private GoRegisterInfo regInfo;

    public static GoRttiMapper getSharedGoBinary(Program program, TaskMonitor monitor) {
        if (TransientProgramProperties.hasProperty(program, FAILED_FLAG)) {
            return null;
        }
        GoRttiMapper goBinary = TransientProgramProperties.getProperty(program, GoRttiMapper.class, TransientProgramProperties.SCOPE.ANALYSIS_SESSION, GoRttiMapper.class, () -> {
            Msg.info(GoRttiMapper.class, (Object)("Reading golang binary info: " + program.getName()));
            try {
                GoRttiMapper supplier_result = GoRttiMapper.getGoBinary(program);
                if (supplier_result != null) {
                    supplier_result.init(monitor);
                    return supplier_result;
                }
            }
            catch (BootstrapInfoException mbie) {
                Msg.warn(GoRttiMapper.class, (Object)mbie.getMessage());
                GoRttiMapper.logAnalyzerMsg(program, mbie.getMessage());
            }
            catch (IOException e) {
                Msg.error(GoRttiMapper.class, (Object)"Failed to read golang info", (Throwable)e);
                GoRttiMapper.logAnalyzerMsg(program, e.getMessage());
            }
            TransientProgramProperties.getProperty(program, FAILED_FLAG, TransientProgramProperties.SCOPE.PROGRAM, Boolean.class, () -> true);
            return null;
        });
        return goBinary;
    }

    private static void logAnalyzerMsg(Program program, String msg) {
        AutoAnalysisManager aam = AutoAnalysisManager.getAnalysisManager(program);
        if (aam.isAnalyzing()) {
            MessageLog log = aam.getMessageLog();
            log.appendMsg(msg);
        }
    }

    public static GoRttiMapper getGoBinary(Program program) throws BootstrapInfoException, IOException {
        ResourceFile gdtFile;
        GoBuildInfo buildInfo = GoBuildInfo.fromProgram(program);
        if (buildInfo == null) {
            return null;
        }
        GoVer goVer = buildInfo.getGoVer();
        if (goVer.isInvalid()) {
            throw new BootstrapInfoException("Invalid Golang version string [%s]".formatted(buildInfo.getVersion()));
        }
        if (!goVer.inRange(SUPPORTED_MIN_VER, SUPPORTED_MAX_VER)) {
            Msg.error(GoRttiMapper.class, (Object)"Untested golang version [%s]".formatted(goVer));
        }
        if ((gdtFile = GoRttiMapper.findGolangBootstrapGDT(goVer, buildInfo.getPointerSize(), GoRttiMapper.getGolangOSString(program))) == null) {
            Msg.error(GoRttiMapper.class, (Object)"Missing golang gdt archive for golang version [%s]".formatted(goVer));
        }
        return new GoRttiMapper(program, buildInfo.getPointerSize(), buildInfo.getEndian(), goVer, gdtFile);
    }

    public static String getGDTFilename(GoVer goVer, int pointerSizeInBytes, String osName) {
        String bitSize = pointerSizeInBytes > 0 ? Integer.toString(pointerSizeInBytes * 8) : "any";
        String gdtFilename = "golang_%d.%d_%sbit_%s.gdt".formatted(goVer.getMajor(), goVer.getMinor(), bitSize, osName);
        return gdtFilename;
    }

    public static String getGolangOSString(Program program) {
        LanguageID languageID;
        String loaderName = program.getExecutableFormat();
        if ("Executable and Linking Format (ELF)".equals(loaderName)) {
            return "linux";
        }
        if ("Portable Executable (PE)".equals(loaderName)) {
            return "win";
        }
        if ("Mac OS X Mach-O".equals(loaderName) && "AARCH64:LE:64:AppleSilicon".equals((languageID = program.getLanguageCompilerSpecPair().getLanguageID()).getIdAsString())) {
            return Platform.MAC_ARM_64.getDirectoryName();
        }
        return null;
    }

    public static ResourceFile findGolangBootstrapGDT(GoVer goVer, int ptrSize, String osName) {
        ResourceFile result = null;
        if (osName != null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, ptrSize, osName));
        }
        if (result == null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, ptrSize, "any"));
        }
        if (result == null) {
            result = DataTypeArchiveUtility.findArchiveFile(GoRttiMapper.getGDTFilename(goVer, -1, "any"));
        }
        return result;
    }

    public static boolean isGolangProgram(Program program) {
        return "golang".equals(program.getCompilerSpec().getCompilerSpecDescription().getCompilerSpecName());
    }

    public static boolean hasGolangSections(List<String> sectionNames) {
        for (String sectionName : sectionNames) {
            if (!sectionName.contains("gopclntab") && !sectionName.contains("go_buildinfo") && !sectionName.contains("go.buildinfo")) continue;
            return true;
        }
        return false;
    }

    public static Symbol getGoSymbol(Program program, String symbolName) {
        for (String prefix : SYMBOL_SEARCH_PREFIXES) {
            List symbols = program.getSymbolTable().getSymbols(prefix + symbolName, null);
            if (symbols.size() != 1) continue;
            return (Symbol)symbols.get(0);
        }
        return null;
    }

    public static MemoryBlock getGoSection(Program program, String sectionName) {
        for (String prefix : SECTION_PREFIXES) {
            MemoryBlock memBlock = program.getMemory().getBlock(prefix + sectionName);
            if (memBlock == null) continue;
            return memBlock;
        }
        return null;
    }

    public static MemoryBlock getFirstGoSection(Program program, String ... blockNames) {
        for (String blockToSearch : blockNames) {
            MemoryBlock memBlock = GoRttiMapper.getGoSection(program, blockToSearch);
            if (memBlock == null) continue;
            return memBlock;
        }
        return null;
    }

    public static Address getZerobaseAddress(Program prog) {
        Address zerobaseAddr;
        Symbol zerobaseSym = GoRttiMapper.getGoSymbol(prog, "runtime.zerobase");
        Address address = zerobaseAddr = zerobaseSym != null ? zerobaseSym.getAddress() : GoRttiMapper.getArtificalZerobaseAddress(prog);
        if (zerobaseAddr == null) {
            zerobaseAddr = prog.getImageBase().getAddressSpace().getMinAddress();
            Msg.warn(GoFunctionFixup.class, (Object)("Unable to find Golang runtime.zerobase, using " + String.valueOf(zerobaseAddr)));
        }
        return zerobaseAddr;
    }

    public static List<GoVer> getAllSupportedVersions() {
        ArrayList<GoVer> result = new ArrayList<GoVer>();
        for (int minor = SUPPORTED_MIN_VER.getMinor(); minor <= SUPPORTED_MAX_VER.getMinor(); ++minor) {
            result.add(new GoVer(1, minor));
        }
        return result;
    }

    private static Address getArtificalZerobaseAddress(Program program) {
        Symbol zerobaseSym = GoRttiMapper.getGoSymbol(program, ARTIFICIAL_RUNTIME_ZEROBASE_SYMBOLNAME);
        return zerobaseSym != null ? zerobaseSym.getAddress() : null;
    }

    public GoRttiMapper(Program program, int ptrSize, Endian endian, GoVer goVersion, ResourceFile archiveGDT) throws IOException, BootstrapInfoException {
        super(program, archiveGDT);
        this.goVersion = goVersion;
        this.ptrSize = ptrSize;
        this.endian = endian;
        this.reader = super.createProgramReader();
        this.addArchiveSearchCategoryPath(CategoryPath.ROOT, GOLANG_CP);
        this.addProgramSearchCategoryPath(DWARFProgram.DWARF_ROOT_CATPATH, DWARFProgram.UNCAT_CATPATH);
        this.uintptrDT = this.getTypeOrDefault("uintptr", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)ptrSize, (DataTypeManager)this.getDTM()));
        this.int32DT = this.getTypeOrDefault("int32", DataType.class, AbstractIntegerDataType.getSignedDataType((int)4, null));
        this.uint32DT = this.getTypeOrDefault("uint32", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)4, null));
        this.uint8DT = this.getTypeOrDefault("uint8", DataType.class, AbstractIntegerDataType.getUnsignedDataType((int)1, null));
        this.stringDT = this.getTypeOrDefault("string", Structure.class, null);
        try {
            this.registerStructures(GOLANG_STRUCTMAPPED_CLASSES, this);
        }
        catch (IOException e) {
            if (archiveGDT == null) {
                throw new BootstrapInfoException("Missing golang .gdt archive for %s, no fallback DWARF info, unable to extract Golang RTTI info.".formatted(goVersion));
            }
            throw new IOException("Invalid Golang bootstrap GDT file or struct mapping info: %s".formatted(archiveGDT.getAbsolutePath()), e);
        }
    }

    @Override
    public <T extends DataType> T getType(String name, Class<T> clazz) {
        Object result = super.getType(name, clazz);
        if (result == null && "runtime.pcHeader".equals(name) && Structure.class.isAssignableFrom(clazz)) {
            result = (DataType)clazz.cast(GoPcHeader.createArtificialGoPcHeaderStructure(GOLANG_CP, (DataTypeManager)this.program.getDataTypeManager()));
        }
        return result;
    }

    public GoVer getGolangVersion() {
        return this.goVersion;
    }

    public GoRegisterInfo getRegInfo() {
        return this.regInfo;
    }

    public void init(TaskMonitor monitor) throws IOException {
        this.regInfo = GoRegisterInfoManager.getInstance().getRegisterInfoForLang(this.program.getLanguage(), this.goVersion);
        GoModuledata firstModule = this.findFirstModuledata(monitor);
        if (firstModule != null) {
            GoPcHeader pcHeader = firstModule.getPcHeader();
            if (pcHeader != null) {
                this.minLC = pcHeader.getMinLC();
                if (pcHeader.getPtrSize() != this.ptrSize) {
                    throw new IOException("Mismatched ptrSize: %d vs %d".formatted(pcHeader.getPtrSize(), this.ptrSize));
                }
            }
            this.addModule(firstModule);
        }
        this.initFuncdata();
    }

    private void initFuncdata() throws IOException {
        for (GoModuledata module : this.modules) {
            for (GoFuncData funcdata : module.getAllFunctionData()) {
                this.funcdataByAddr.put(funcdata.getFuncAddress(), funcdata);
                this.funcdataByName.put(funcdata.getName(), funcdata);
            }
        }
    }

    public void initMethodInfoIfNeeded() throws IOException {
        if (this.methodsByAddr.isEmpty()) {
            this.initMethodInfo();
        }
    }

    private void initMethodInfo() throws IOException {
        for (GoType goType : this.goTypes.values()) {
            goType.getMethodInfoList().forEach(this::addMethodInfo);
        }
        for (GoModuledata module : this.modules) {
            for (GoItab itab : module.getItabs()) {
                itab.getMethodInfoList().forEach(this::addMethodInfo);
                List itabs = this.interfacesImplementedByType.computeIfAbsent(itab.getType().getTypeOffset(), unused -> new ArrayList());
                itabs.add(itab);
            }
        }
    }

    private void addMethodInfo(MethodInfo bm) {
        List methods = this.methodsByAddr.computeIfAbsent(bm.getAddress(), unused -> new ArrayList());
        methods.add(bm);
    }

    public byte getMinLC() throws IOException {
        if (this.minLC == 0) {
            throw new IOException("Unknown Golang minLC value");
        }
        return this.minLC;
    }

    public GoModuledata getFirstModule() {
        return !this.modules.isEmpty() ? this.modules.get(0) : null;
    }

    public void addModule(GoModuledata module) {
        this.modules.add(module);
    }

    public GoParamStorageAllocator newStorageAllocator() {
        GoParamStorageAllocator storageAllocator = new GoParamStorageAllocator(this.program, this.goVersion);
        return storageAllocator;
    }

    public boolean isGolangAbi0Func(Function func) {
        Address funcAddr = func.getEntryPoint();
        for (Symbol symbol : func.getProgram().getSymbolTable().getSymbolsAsIterator(funcAddr)) {
            String labelName;
            if (symbol.getSymbolType() != SymbolType.LABEL || !(labelName = symbol.getName()).endsWith("abi0")) continue;
            return true;
        }
        return false;
    }

    public boolean hasCallingConvention(String ccName) {
        return this.program.getFunctionManager().getCallingConvention(ccName) != null;
    }

    @Override
    public MarkupSession createMarkupSession(TaskMonitor monitor) {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        upwtm.initialize(1L, "Marking up Golang RTTI structures");
        return super.createMarkupSession((TaskMonitor)upwtm);
    }

    public GoModuledata findContainingModule(long offset) {
        for (GoModuledata module : this.modules) {
            if (module.getTypesOffset() > offset || offset >= module.getTypesEndOffset()) continue;
            return module;
        }
        return null;
    }

    public GoModuledata findContainingModuleByFuncData(long offset) {
        for (GoModuledata module : this.modules) {
            if (!module.containsFuncDataInstance(offset)) continue;
            return module;
        }
        return null;
    }

    @Override
    public CategoryPath getDefaultVariableLengthStructCategoryPath() {
        return VARLEN_STRUCTS_CP;
    }

    public DataType getUintptrDT() {
        return this.uintptrDT;
    }

    public DataType getInt32DT() {
        return this.int32DT;
    }

    public DataType getUint32DT() {
        return this.uint32DT;
    }

    public Structure getGenericSliceDT() {
        return this.getStructureDataType(GoSlice.class);
    }

    public GoType getMapGoType() {
        return this.mapGoType;
    }

    public GoType getChanGoType() {
        return this.chanGoType;
    }

    @Override
    protected BinaryReader createProgramReader() {
        return this.reader.clone();
    }

    public int getPtrSize() {
        return this.ptrSize;
    }

    public GoType getGoType(long offset) throws IOException {
        if (offset == 0L) {
            return null;
        }
        GoType goType = this.goTypes.get(offset);
        if (goType == null) {
            Class<? extends GoType> typeClass = GoType.getSpecializedTypeClass(this, offset);
            goType = this.readStructure(typeClass, offset);
            this.goTypes.put(offset, goType);
        }
        return goType;
    }

    public GoType getCachedGoType(long offset) {
        GoType goType = this.goTypes.get(offset);
        return goType;
    }

    public GoType getGoType(Address addr) throws IOException {
        return this.getGoType(addr.getOffset());
    }

    public GoType findGoType(String typeName) {
        return this.typeNameIndex.get(typeName);
    }

    public <T extends DataType> T getGhidraDataType(String goTypeName, Class<T> clazz) {
        GoType goType;
        Object dt = this.getType(goTypeName, clazz);
        if (dt == null && (goType = this.findGoType(goTypeName)) != null) {
            try {
                DataType tmpDT = goType.recoverDataType();
                if (clazz.isInstance(tmpDT)) {
                    dt = (DataType)clazz.cast(tmpDT);
                }
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)"Failed to get Ghidra data type from go type: %s[%x]".formatted(goTypeName, goType.getStructureContext().getStructureStart()));
            }
        }
        return dt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTypesToGDT(File gdtFile, boolean runtimeFuncSnapshot, TaskMonitor monitor) throws IOException, CancelledException {
        List bootstrapFuncDefs = runtimeFuncSnapshot ? this.createBootstrapFuncDefs((DataTypeManager)this.program.getDataTypeManager(), GoConstants.GOLANG_BOOTSTRAP_FUNCS_CATEGORYPATH, monitor) : List.of();
        List<DataType> registeredStructDTs = this.mappingInfo.values().stream().map(this::structMappingInfoToDataType).filter(Objects::nonNull).toList();
        File tmpGDTFile = new File(gdtFile.getParentFile(), gdtFile.getName() + ".step1.gdt");
        FileDataTypeManager tmpFdtm = FileDataTypeManager.createFileArchive((File)tmpGDTFile);
        int tx = tmpFdtm.startTransaction("Import");
        try {
            tmpFdtm.addDataTypes(registeredStructDTs, DataTypeConflictHandler.DEFAULT_HANDLER, monitor);
            if (runtimeFuncSnapshot) {
                tmpFdtm.addDataTypes(bootstrapFuncDefs, DataTypeConflictHandler.KEEP_HANDLER, monitor);
            }
            this.moveAllDataTypesTo((DataTypeManager)tmpFdtm, DWARFProgram.DWARF_ROOT_CATPATH, GOLANG_CP);
            for (SourceArchive sa : tmpFdtm.getSourceArchives()) {
                tmpFdtm.removeSourceArchive(sa);
            }
            tmpFdtm.getRootCategory().removeCategory(DWARFProgram.DWARF_ROOT_CATPATH.getName(), monitor);
            Iterator it = tmpFdtm.getAllDataTypes();
            while (it.hasNext()) {
                DataType dt2 = (DataType)it.next();
                if (dt2.getDescription() != null && dt2 instanceof Composite && !GoFunctionMultiReturn.isMultiReturnDataType(dt2)) {
                    dt2.setDescription(null);
                }
                if (!(dt2 instanceof FunctionDefinition)) continue;
                FunctionDefinition funcDef = (FunctionDefinition)dt2;
                funcDef.setComment(null);
            }
        }
        catch (DataTypeDependencyException | InvalidNameException | CancelledException | DuplicateNameException e) {
            Msg.error((Object)this, (Object)"Error when exporting types to file: %s".formatted(gdtFile), (Throwable)e);
        }
        finally {
            tmpFdtm.endTransaction(tx, true);
        }
        tmpFdtm.save();
        FileDataTypeManager fdtm = FileDataTypeManager.createFileArchive((File)gdtFile);
        tx = fdtm.startTransaction("Import");
        try {
            tmpFdtm.getAllDataTypes().forEachRemaining(dt -> fdtm.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER));
            for (SourceArchive sa : fdtm.getSourceArchives()) {
                fdtm.removeSourceArchive(sa);
            }
        }
        finally {
            fdtm.endTransaction(tx, true);
        }
        fdtm.save();
        tmpFdtm.close();
        fdtm.close();
        tmpGDTFile.delete();
    }

    private DataType structMappingInfoToDataType(StructureMappingInfo<?> smi) {
        if (smi.getStructureDataType() == null) {
            return null;
        }
        DataType existingDT = this.findType(smi.getStructureName(), List.of(DWARFProgram.DWARF_ROOT_CATPATH, DWARFProgram.UNCAT_CATPATH), this.programDTM);
        if (existingDT == null) {
            existingDT = smi.getStructureDataType();
        }
        if (existingDT == null) {
            Msg.warn((Object)this, (Object)("Missing type: " + smi.getDescription()));
        }
        return existingDT;
    }

    private List<DataType> createBootstrapFuncDefs(DataTypeManager destDTM, CategoryPath destCP, TaskMonitor monitor) throws CancelledException {
        List<Function> funcs = this.getAllFunctions().stream().filter(funcData -> funcData.getFlags().isEmpty()).map(BootstrapFuncInfo::from).filter(Objects::nonNull).filter(BootstrapFuncInfo::isBootstrapFunction).filter(BootstrapFuncInfo::isNotPlatformSpecificSourceFile).map(BootstrapFuncInfo::func).toList();
        monitor.initialize((long)funcs.size(), "Creating golang bootstrap function defs");
        ArrayList<DataType> results = new ArrayList<DataType>();
        for (Function func : funcs) {
            monitor.increment();
            try {
                FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(func.getSignature());
                funcDef.setCategoryPath(destCP);
                funcDef.setCallingConvention(null);
                funcDef.setComment(null);
                DataType newDT = destDTM.addDataType((DataType)funcDef, DataTypeConflictHandler.KEEP_HANDLER);
                results.add(newDT);
            }
            catch (InvalidInputException invalidInputException) {}
        }
        return results;
    }

    private void moveAllDataTypesTo(DataTypeManager dtm, CategoryPath srcCP, CategoryPath destCP) throws DuplicateNameException, DataTypeDependencyException, InvalidNameException {
        Category srcCat = dtm.getCategory(srcCP);
        if (srcCat != null) {
            for (DataType dataType : srcCat.getDataTypes()) {
                DataType existingDT;
                TypeDef td;
                if (dataType instanceof Array || dataType instanceof Pointer) continue;
                Object destName = dataType.getName();
                if (dataType instanceof TypeDef && (td = (TypeDef)dataType).getName().startsWith(".param")) {
                    destName = td.getCategoryPath().getName() + dataType.getName();
                }
                if ((existingDT = dtm.getDataType(new DataTypePath(destCP, (String)destName))) != null) {
                    if (DWARFDataTypeConflictHandler.INSTANCE.resolveConflict(dataType, existingDT) != DataTypeConflictHandler.ConflictResult.USE_EXISTING) {
                        throw new DuplicateNameException("Error moving golang type: [%s] to [%s]".formatted(dataType.getDataTypePath(), existingDT.getDataTypePath()));
                    }
                    dtm.replaceDataType(dataType, existingDT, false);
                    continue;
                }
                dataType.setNameAndCategory(destCP, (String)destName);
            }
            for (DataType dataType : srcCat.getCategories()) {
                this.moveAllDataTypesTo(dtm, dataType.getCategoryPath(), destCP);
            }
        }
    }

    public CategoryPath getRecoveredTypesCp(String packagePath) {
        CategoryPath result = RECOVERED_TYPES_CP;
        if (packagePath != null && !packagePath.isEmpty()) {
            result = result.extend(new String[]{packagePath});
        }
        return result;
    }

    public DataType getRecoveredType(GoType typ) throws IOException {
        Address typeStructAddr = this.getAddressOfStructure(typ);
        if (typeStructAddr == null) {
            throw new IOException("Unable to get address of a struct mapped instance");
        }
        long offset = typeStructAddr.getOffset();
        DataType dt = this.cachedRecoveredDataTypes.get(offset);
        if (dt != null) {
            return dt;
        }
        dt = typ.recoverDataType();
        this.cachedRecoveredDataTypes.put(offset, dt);
        return dt;
    }

    public FunctionDefinition getSpecializedMethodSignature(String methodName, GoType methodType, DataType receiverDT, boolean allowPartial) throws IOException {
        FunctionDefinitionDataType methodFuncDef;
        if (methodType == null && !allowPartial || receiverDT == null) {
            return null;
        }
        Object object = methodFuncDef = methodType != null ? GoFuncType.unwrapFunctionDefinitionPtrs(this.getRecoveredType(methodType)) : new FunctionDefinitionDataType("empty", (DataTypeManager)this.program.getDataTypeManager());
        if (methodFuncDef == null) {
            return null;
        }
        methodFuncDef = (FunctionDefinition)methodFuncDef.copy((DataTypeManager)this.program.getDataTypeManager());
        try {
            methodFuncDef.setNameAndCategory(receiverDT.getCategoryPath(), methodName);
            ArrayList<ParameterDefinition> args = new ArrayList<ParameterDefinition>(Arrays.asList(methodFuncDef.getArguments()));
            args.add(0, (ParameterDefinition)new ParameterDefinitionImpl(null, receiverDT, null));
            methodFuncDef.setArguments((ParameterDefinition[])args.toArray(ParameterDefinition[]::new));
            return methodFuncDef;
        }
        catch (InvalidNameException | DuplicateNameException e) {
            Msg.warn((Object)this, (Object)"Error when creating function signature for method", (Throwable)e);
            return null;
        }
    }

    public void cacheRecoveredDataType(GoType typ, DataType dt) throws IOException {
        Address typeStructAddr = this.getAddressOfStructure(typ);
        if (typeStructAddr == null) {
            throw new IOException("Unable to get address of a struct mapped instance");
        }
        long offset = typeStructAddr.getOffset();
        this.cachedRecoveredDataTypes.put(offset, dt);
    }

    public DataType getCachedRecoveredDataType(GoType typ) throws IOException {
        Address typeStructAddr = this.getAddressOfStructure(typ);
        if (typeStructAddr == null) {
            throw new IOException("Unable to get address of a struct mapped instance");
        }
        long offset = typeStructAddr.getOffset();
        return this.cachedRecoveredDataTypes.get(offset);
    }

    public void recoverDataTypes(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.initialize((long)this.goTypes.size(), "Converting Golang types to Ghidra data types");
        List typeOffsets = this.goTypes.keySet().stream().sorted().toList();
        for (Long typeOffset : typeOffsets) {
            monitor.increment();
            GoType typ = this.getGoType(typeOffset);
            DataType dt = typ.recoverDataType();
            if (this.programDTM.getDataType(dt.getDataTypePath()) != null) continue;
            this.programDTM.addDataType(dt, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    public void initTypeInfoIfNeeded(TaskMonitor monitor) throws CancelledException, IOException {
        if (this.goTypes.isEmpty()) {
            this.discoverGoTypes(monitor);
        }
    }

    public void discoverGoTypes(TaskMonitor monitor) throws IOException, CancelledException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        upwtm.setMessage("Iterating Golang RTTI types");
        this.goTypes.clear();
        this.typeNameIndex.clear();
        HashSet<Long> discoveredTypes = new HashSet<Long>();
        for (GoModuledata goModuledata : this.modules) {
            Iterator<GoType> it = goModuledata.iterateTypes();
            while (it.hasNext()) {
                upwtm.checkCancelled();
                upwtm.setProgress((long)discoveredTypes.size());
                GoType type = it.next();
                type.discoverGoTypes(discoveredTypes);
            }
        }
        HashMap<String, Integer> typeDupCount = new HashMap<String, Integer>();
        for (GoType goType : this.goTypes.values()) {
            String typeName = goType.getNameWithPackageString();
            typeDupCount.merge(typeName, 1, (i1, i2) -> i1 + i2);
        }
        Set set = typeDupCount.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
        typeDupCount.clear();
        for (GoType goType : this.goTypes.values()) {
            GoType existingType;
            Object typeName = goType.getNameWithPackageString();
            if (set.contains(typeName)) {
                typeName = (String)typeName + "." + String.valueOf(typeDupCount.merge((String)typeName, 1, (i1, i2) -> i1 + i2));
            }
            if ((existingType = this.typeNameIndex.put((String)typeName, goType)) != null) {
                Msg.warn((Object)this, (Object)("Go type name conflict: " + (String)typeName));
            }
            this.fixedGoTypeNames.put(goType.getTypeOffset(), (String)typeName);
        }
        Msg.info((Object)this, (Object)"Found %d golang types".formatted(this.goTypes.size()));
        this.mapGoType = this.findGoType("runtime.hmap");
        this.chanGoType = this.findGoType("runtime.hchan");
    }

    public List<MethodInfo> getMethodInfoForFunction(Address funcAddr) {
        List<MethodInfo> result = this.methodsByAddr.get(funcAddr);
        return result != null ? result : List.of();
    }

    public List<GoItab> getInterfacesImplementedByType(GoType type) {
        return this.interfacesImplementedByType.getOrDefault(type.getTypeOffset(), List.of());
    }

    public String getUniqueGoTypename(GoType goType) {
        String name = this.fixedGoTypeNames.get(goType.getTypeOffset());
        if (name == null) {
            name = goType.getNameWithPackageString();
        }
        return name;
    }

    public <T> GoName getSafeName(GoNameSupplier supplier, T structInstance, String defaultValue) {
        try {
            GoName result = supplier.get();
            if (result != null) {
                return result;
            }
        }
        catch (IOException e) {
            defaultValue = null;
        }
        StructureContext<T> structContext = this.getStructureContextOfInstance(structInstance);
        String fallbackName = defaultValue;
        fallbackName = fallbackName == null && structContext != null ? "%s_%x".formatted(structContext.getMappingInfo().getStructureName(), structContext.getStructureStart()) : "invalid_object";
        return GoName.createFakeInstance(fallbackName);
    }

    public String getGoTypeName(long offset) {
        try {
            GoType goType = this.getGoType(offset);
            if (goType != null) {
                return goType.getName();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown_type_%x".formatted(offset);
    }

    public GoType resolveTypeOff(long ptrInModule, long off) throws IOException {
        if (off == 0L || off == 0xFFFFFFFFL || off == -1L) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        return this.getGoType(module.getTypesOffset() + off);
    }

    public Address resolveTextOff(long ptrInModule, long off) {
        if (off == -1L || off == 0xFFFFFFFFL) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        return module != null ? module.getText().add(off) : null;
    }

    public GoName resolveNameOff(long ptrInModule, long off) throws IOException {
        if (off == 0L) {
            return null;
        }
        GoModuledata module = this.findContainingModule(ptrInModule);
        if (module == null) {
            throw new IOException("Unable to find containing module for structure at 0x%x".formatted(ptrInModule));
        }
        long nameStart = module.getTypesOffset() + off;
        return this.getGoName(nameStart);
    }

    public GoName getGoName(long offset) throws IOException {
        return offset != 0L ? this.readStructure(GoName.class, offset) : null;
    }

    public GoFuncData getFunctionData(Address funcAddr) {
        return this.funcdataByAddr.get(funcAddr);
    }

    public GoFuncData getFunctionByName(String funcName) {
        return this.funcdataByName.get(funcName);
    }

    public List<GoFuncData> getAllFunctions() {
        return new ArrayList<GoFuncData>(this.funcdataByAddr.values());
    }

    public FunctionDefinition getBootstrapFunctionDefintion(String funcName) {
        if (this.archiveDTM != null) {
            FunctionDefinition funcDef;
            DataType dt = this.archiveDTM.getDataType(GoConstants.GOLANG_BOOTSTRAP_FUNCS_CATEGORYPATH, funcName);
            return dt instanceof FunctionDefinition ? (funcDef = (FunctionDefinition)dt) : null;
        }
        return null;
    }

    private GoModuledata findFirstModuledata(TaskMonitor monitor) throws IOException {
        Address pcHeaderAddress;
        GoModuledata result = GoModuledata.getFirstModuledata(this);
        Address address = pcHeaderAddress = result != null ? result.getPcHeaderAddress() : GoPcHeader.getPcHeaderAddress(this.program);
        if (pcHeaderAddress == null) {
            monitor.initialize(0L, "Searching for Golang pclntab");
            pcHeaderAddress = GoPcHeader.findPcHeaderAddress(this, this.getPclntabSearchRange(), monitor);
        }
        if (result == null && pcHeaderAddress != null) {
            monitor.initialize(0L, "Searching for Golang firstmoduledata");
            GoPcHeader pcHeader = this.readStructure(GoPcHeader.class, pcHeaderAddress);
            result = GoModuledata.findFirstModule(this, pcHeaderAddress, pcHeader, this.getModuledataSearchRange(), monitor);
        }
        if (result != null && !result.isValid()) {
            throw new IOException("Invalid Golang moduledata at %s".formatted(result.getStructureContext().getStructureAddress()));
        }
        return result;
    }

    private AddressRange getPclntabSearchRange() {
        MemoryBlock memBlock = GoRttiMapper.getFirstGoSection(this.program, "noptrdata", "rdata");
        return memBlock != null ? new AddressRangeImpl(memBlock.getStart(), memBlock.getEnd()) : null;
    }

    private AddressRange getModuledataSearchRange() {
        MemoryBlock memBlock = GoRttiMapper.getFirstGoSection(this.program, "noptrdata", "data");
        return memBlock != null ? new AddressRangeImpl(memBlock.getStart(), memBlock.getEnd()) : null;
    }

    public AddressSetView getStringStructRange() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getDataRange());
            result.add(moduledata.getRoDataRange());
        }
        return result;
    }

    public AddressSetView getStringDataRange() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getRoDataRange());
        }
        return result;
    }

    public AddressSetView getTextAddresses() {
        AddressSet result = new AddressSet();
        for (GoModuledata moduledata : this.modules) {
            result.add(moduledata.getTextRange());
        }
        return result;
    }

    public Symbol getGoSymbol(String symbolName) {
        return GoRttiMapper.getGoSymbol(this.program, symbolName);
    }

    public MemoryBlock getGoSection(String sectionName) {
        return GoRttiMapper.getGoSection(this.program, sectionName);
    }

    @Override
    public boolean isFieldPresent(String presentWhen) {
        GoVer endVer;
        if ((presentWhen = presentWhen.strip()).isEmpty()) {
            return true;
        }
        String[] verNums = presentWhen.split("[+-]", -1);
        if (verNums.length != 2) {
            throw new IllegalArgumentException("Invalid 'presentWhen' value [%s]".formatted(presentWhen));
        }
        GoVer startVer = verNums[0].isBlank() ? new GoVer(1, 0) : GoVer.parse(verNums[0]);
        GoVer goVer = endVer = verNums[1].isBlank() ? new GoVer(99, 99) : GoVer.parse(verNums[1]);
        if (startVer.isInvalid() || endVer.isInvalid()) {
            throw new IllegalArgumentException("Invalid 'presentWhen' value [%s]".formatted(presentWhen));
        }
        return startVer.compareTo(this.goVersion) <= 0 && this.goVersion.compareTo(endVer) <= 0;
    }

    public static interface GoNameSupplier {
        public GoName get() throws IOException;
    }

    record BootstrapFuncInfo(GoFuncData funcData, Function func) {
        private static final Set<String> BOOTSTRAP_PACKAGE_PATHS = Set.of("archive/tar", "archive/zip", "bufio", "bytes", "compress/bzip2", "compress/flate", "compress/gzip", "compress/lzw", "compress/zlib", "container/heap", "container/list", "container/ring", "context", "crypto", "crypto/aes", "crypto/cipher", "crypto/des", "crypto/dsa", "crypto/ecdh", "crypto/ecdsa", "crypto/ed25519", "crypto/elliptic", "crypto/hmac", "crypto/md5", "crypto/rand", "crypto/rc4", "crypto/rsa", "crypto/sha1", "crypto/sha256", "crypto/sha512", "crypto/subtle", "crypto/tls", "crypto/x509", "database/sql", "debug/buildinfo", "debug/elf", "debug/gosym", "errors", "flag", "fmt", "io", "io/fs", "io/ioutil", "log", "log/syslog", "math", "math/big", "math/rand", "net", "net/http", "net/url", "os", "path", "path/filepath", "plugin", "runtime", "sort", "strconv", "strings", "sync", "text/scanner", "text/tabwriter", "text/template", "time", "unicode", "unicode/utf16", "unicode/utf8", "unsafe", "reflect", "internal/cpu", "internal/fmtsort", "internal/reflectlite");
        private static final Set<String> BOOTSTRAP_SRCFILE_PLATFORM_SPECIFIC = Set.of("amd64", "arm", "loong64", "ppc64", "386", "mips", "risc", "s390", "wasm", "aix", "android", "darwin", "dragonfly", "freebsd", "linux", "windows", "openbsd", "ios");

        static BootstrapFuncInfo from(GoFuncData funcData) {
            Function func = funcData.getFunction();
            return func != null ? new BootstrapFuncInfo(funcData, func) : null;
        }

        public boolean isBootstrapFunction() {
            String packagePath = this.funcData.getSymbolName().getPackagePath();
            return packagePath != null && BOOTSTRAP_PACKAGE_PATHS.contains(packagePath);
        }

        public boolean isNotPlatformSpecificSourceFile() {
            try {
                String sourceFilename;
                GoSourceFileInfo sfi = this.funcData.getSourceFileInfo();
                String string = sourceFilename = sfi != null ? sfi.getFileName() : null;
                if (sourceFilename != null) {
                    for (String sourceFileExclude : BOOTSTRAP_SRCFILE_PLATFORM_SPECIFIC) {
                        if (!sourceFilename.contains("_" + sourceFileExclude)) continue;
                        return false;
                    }
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
    }
}

