/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.golang.GoVer;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutput;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.LEB128;
import ghidra.program.model.data.UnsignedLeb128DataType;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

@StructureMapping(structureName={"GoVarlenString"})
public class GoVarlenString
implements StructureReader<GoVarlenString> {
    @ContextField
    private StructureContext<GoVarlenString> context;
    @FieldMapping(fieldName={"strlen"})
    @FieldOutput(isVariableLength=true, getter="strlenDataType")
    private int strlenLen;
    @FieldMapping(fieldName={"value"})
    @FieldOutput(isVariableLength=true, getter="valueDataType")
    private byte[] bytes;

    @Override
    public void readStructure() throws IOException {
        this.readFrom(this.context.getReader());
    }

    private boolean useLEB128() {
        return ((GoRttiMapper)this.context.getDataTypeMapper()).getGolangVersion().isAtLeast(GoVer.V1_17);
    }

    private void readFrom(BinaryReader reader) throws IOException {
        long startPos = reader.getPointerIndex();
        int strLen = this.useLEB128() ? reader.readNextUnsignedVarIntExact(LEB128::unsigned) : reader.readNextUnsignedShort((DataConverter)BigEndianDataConverter.INSTANCE);
        this.strlenLen = (int)(reader.getPointerIndex() - startPos);
        this.bytes = reader.readNextByteArray(strLen);
    }

    public int getStrlen() {
        return this.bytes.length;
    }

    public int getStrlenLen() {
        return this.strlenLen;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public String getString() {
        return new String(this.bytes, StandardCharsets.UTF_8);
    }

    public DataTypeInstance getStrlenDataType() {
        UnsignedLeb128DataType dt = this.useLEB128() ? UnsignedLeb128DataType.dataType : AbstractIntegerDataType.getUnsignedDataType((int)2, null);
        return DataTypeInstance.getDataTypeInstance((DataType)dt, (int)this.strlenLen, (boolean)false);
    }

    public DataType getValueDataType() {
        return new ArrayDataType((DataType)CharDataType.dataType, this.bytes.length, -1, this.context.getDataTypeMapper().getDTM());
    }

    public String toString() {
        return String.format("GoVarlenString [context=%s, strlenLen=%s, bytes=%s, getString()=%s]", this.context, this.strlenLen, Arrays.toString(this.bytes), this.getString());
    }
}

