/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.TypedefDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime.arraytype", "internal/abi.ArrayType"})
public class GoArrayType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getElement")
    private long elem;
    @FieldMapping
    @MarkupReference(value="getSliceType")
    private long slice;
    @FieldMapping
    private long len;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Markup
    public GoType getSliceType() throws IOException {
        return this.programContext.getGoType(this.slice);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        DataType elementDt = this.programContext.getRecoveredType(this.getElement());
        DataType self = this.programContext.getCachedRecoveredDataType(this);
        if (self != null) {
            return self;
        }
        return this.isValidLength() ? new ArrayDataType(elementDt, (int)this.len, -1) : new TypedefDataType(elementDt.getCategoryPath(), ".invalid_arraysize_%d_%s".formatted(this.len, elementDt.getName()), (DataType)new ArrayDataType(elementDt, 1, -1), elementDt.getDataTypeManager());
    }

    private boolean isValidLength() {
        return 0L <= this.len && this.len <= Integer.MAX_VALUE;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType elementType = this.getElement();
        GoType sliceType = this.getSliceType();
        if (elementType != null) {
            elementType.discoverGoTypes(discoveredTypes);
        }
        if (sliceType != null) {
            sliceType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public String getStructureNamespace() throws IOException {
        String packagePath = this.getPackagePathString();
        if (packagePath != null && !packagePath.isEmpty()) {
            return packagePath;
        }
        GoType elementType = this.getElement();
        if (elementType != null) {
            return elementType.getStructureNamespace();
        }
        return super.getStructureNamespace();
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String selfName = this.typ.getName();
        String elemName = this.programContext.getGoTypeName(this.elem);
        String arrayDefStr = "[%d]%s".formatted(this.len, elemName);
        String defStrWithLinks = "[%d]%s".formatted(this.len, AddressAnnotatedStringHandler.createAddressAnnotationString(this.elem, elemName));
        boolean hasName = !arrayDefStr.equals(selfName);
        return "type %s%s".formatted(hasName ? selfName + " " : "", defStrWithLinks);
    }
}

