/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.MethodInfo;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkup;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.FunctionDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@StructureMapping(structureName={"runtime.method", "internal/abi.Method"})
public class GoMethod
implements StructureMarkup<GoMethod> {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoMethod> context;
    @FieldMapping
    @MarkupReference(value="getGoName")
    @EOLComment(value="getName")
    private long name;
    @FieldMapping
    @MarkupReference(value="getType")
    private long mtyp;
    @FieldMapping
    @MarkupReference
    private long ifn;
    @FieldMapping
    @MarkupReference
    private long tfn;

    @Markup
    public GoName getGoName() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.name);
    }

    public String getName() {
        GoName n = this.programContext.getSafeName(this::getGoName, this, "unnamed_method");
        return n.getName();
    }

    public boolean isSignatureMissing() {
        return this.mtyp == 0L || this.mtyp == 0xFFFFFFFFL || this.mtyp == -1L;
    }

    @Markup
    public GoType getType() throws IOException {
        return this.programContext.resolveTypeOff(this.context.getStructureStart(), this.mtyp);
    }

    @Override
    public StructureContext<GoMethod> getStructureContext() {
        return this.context;
    }

    @Override
    public String getStructureName() {
        return this.getName();
    }

    public Address getIfn() {
        return this.programContext.resolveTextOff(this.context.getStructureStart(), this.ifn);
    }

    public Address getTfn() {
        return this.programContext.resolveTextOff(this.context.getStructureStart(), this.tfn);
    }

    public List<GoMethodInfo> getMethodInfos(GoType containingType) {
        ArrayList<GoMethodInfo> results = new ArrayList<GoMethodInfo>(2);
        Address addr = this.getTfn();
        if (addr != null) {
            results.add(new GoMethodInfo(this, containingType, this, addr));
        }
        if ((addr = this.getIfn()) != null) {
            results.add(new GoMethodInfo(this, containingType, this, addr));
        }
        return results;
    }

    public String toString() {
        return String.format("GoMethod [context=%s, getName()=%s, getIfn()=%s, getTfn()=%s]", this.context, this.getName(), this.getIfn(), this.getTfn());
    }

    public class GoMethodInfo
    extends MethodInfo {
        GoType type;
        GoMethod method;

        public GoMethodInfo(GoMethod this$0, GoType type, GoMethod method, Address address) {
            super(address);
            this.type = type;
            this.method = method;
        }

        public GoType getType() {
            return this.type;
        }

        public GoMethod getMethod() {
            return this.method;
        }

        public boolean isIfn(Address funcAddr) {
            return funcAddr.equals((Object)this.method.getIfn());
        }

        public boolean isTfn(Address funcAddr) {
            return funcAddr.equals((Object)this.method.getTfn());
        }

        @Override
        public FunctionDefinition getSignature() throws IOException {
            return this.type.getMethodSignature(this.method, false);
        }

        public FunctionDefinition getPartialSignature() throws IOException {
            return this.type.getMethodSignature(this.method, true);
        }
    }
}

