/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime.ptrtype", "internal/abi.PtrType"})
public class GoPointerType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getElement")
    private long elem;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        DataType elementDT = this.programContext.getRecoveredType(this.getElement());
        DataType self = this.programContext.getCachedRecoveredDataType(this);
        if (self != null) {
            return self;
        }
        return new PointerDataType(elementDT, this.programContext.getDTM());
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType element = this.getElement();
        if (element != null) {
            element.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public String getStructureNamespace() throws IOException {
        GoType elementType = this.getElement();
        return elementType != null ? elementType.getStructureNamespace() : super.getStructureNamespace();
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String selfName = this.getName();
        String elemName = this.programContext.getGoTypeName(this.elem);
        String defStr = "*" + elemName;
        String defStrWithLinks = "*" + AddressAnnotatedStringHandler.createAddressAnnotationString(this.elem, elemName);
        boolean hasName = !defStr.equals(selfName);
        return "type %s%s".formatted(hasName ? selfName + " " : "", defStrWithLinks);
    }
}

