/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.viewer.field.AddressAnnotatedStringHandler;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import java.io.IOException;
import java.util.Set;

@StructureMapping(structureName={"runtime.slicetype", "internal/abi.SliceType"})
public class GoSliceType
extends GoType {
    @FieldMapping
    @MarkupReference(value="getElement")
    private long elem;

    @Markup
    public GoType getElement() throws IOException {
        return this.programContext.getGoType(this.elem);
    }

    @Override
    public DataType recoverDataType() throws IOException {
        Structure genericSliceDT = this.programContext.getGenericSliceDT();
        StructureDataType sliceDT = new StructureDataType(this.programContext.getRecoveredTypesCp(this.getPackagePathString()), this.getUniqueTypename(), genericSliceDT.getLength(), this.programContext.getDTM());
        sliceDT.replaceWith((DataType)genericSliceDT);
        this.programContext.cacheRecoveredDataType(this, (DataType)sliceDT);
        GoType elementType = this.getElement();
        DataType elementDT = this.programContext.getRecoveredType(elementType);
        Pointer elementPtrDT = this.programContext.getDTM().getPointer(elementDT);
        int arrayPtrComponentIndex = 0;
        DataTypeComponent arrayDTC = genericSliceDT.getComponent(arrayPtrComponentIndex);
        sliceDT.replace(arrayPtrComponentIndex, (DataType)elementPtrDT, -1, arrayDTC.getFieldName(), arrayDTC.getComment());
        return sliceDT;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        GoType elementType = this.getElement();
        if (elementType != null) {
            elementType.discoverGoTypes(discoveredTypes);
        }
        return true;
    }

    @Override
    public String getStructureNamespace() throws IOException {
        String packagePath = this.getPackagePathString();
        if (packagePath != null) {
            return packagePath;
        }
        GoType elementType = this.getElement();
        return elementType != null ? elementType.getStructureNamespace() : super.getStructureNamespace();
    }

    @Override
    protected String getTypeDeclString() throws IOException {
        String selfName = this.typ.getName();
        String elemName = this.programContext.getGoTypeName(this.elem);
        String defStr = "[]%s".formatted(elemName);
        String defStrWithLinks = "[]%s".formatted(AddressAnnotatedStringHandler.createAddressAnnotationString(this.elem, elemName));
        boolean hasName = !defStr.equals(selfName);
        return "type %s%s".formatted(hasName ? selfName + " " : "", defStrWithLinks);
    }
}

