/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.dwarf.DWARFUtil;
import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructField;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@StructureMapping(structureName={"runtime.structtype", "internal/abi.StructType"})
public class GoStructType
extends GoType {
    @FieldMapping
    @MarkupReference
    private long pkgPath;
    @FieldMapping
    private GoSlice fields;

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.getGoName(this.pkgPath);
    }

    @Override
    public String getPackagePathString() {
        String s = super.getPackagePathString();
        if (s == null || s.isEmpty()) {
            try {
                GoName structPP = this.getPkgPath();
                if (structPP != null) {
                    s = structPP.getName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return s;
    }

    public List<GoStructField> getFields() throws IOException {
        return this.fields.readList(GoStructField.class);
    }

    @Override
    public long getEndOfTypeInfo() throws IOException {
        return this.fields.getArrayEnd(GoStructField.class);
    }

    @Override
    public void additionalMarkup(MarkupSession session) throws IOException, CancelledException {
        super.additionalMarkup(session);
        this.fields.markupArray(this.getStructureLabel() + "_fields", this.getStructureNamespace(), GoStructField.class, false, session);
        this.fields.markupArrayElements(GoStructField.class, session);
    }

    @Override
    public String getTypeDeclString() throws IOException {
        String pps = this.getPackagePathString();
        if (pps == null || pps.isEmpty()) {
            pps = "<None>";
        }
        return "// size: %d\n// package: %s\ntype %s struct {\n%s}".formatted(this.typ.getSize(), pps, this.typ.getName(), this.getFieldListString().indent(2));
    }

    private String getFieldListString() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (GoStructField field : this.getFields()) {
            if (!sb.isEmpty()) {
                sb.append("\n");
            }
            long offset = field.getOffset();
            long fieldSize = field.getType().getBaseType().getSize();
            sb.append("%s %s // %d..%d".formatted(field.getName(), field.getType().getName(), offset, offset + fieldSize));
        }
        return sb.toString();
    }

    @Override
    public DataType recoverDataType() throws IOException {
        StructureDataType struct = new StructureDataType(this.programContext.getRecoveredTypesCp(this.getPackagePathString()), this.getUniqueTypename(), (int)this.typ.getSize(), this.programContext.getDTM());
        this.programContext.cacheRecoveredDataType(this, (DataType)struct);
        ArrayList<GoStructField> skippedFields = new ArrayList<GoStructField>();
        List<GoStructField> fieldList = this.getFields();
        for (int i = 0; i < fieldList.size(); ++i) {
            GoStructField field = fieldList.get(i);
            GoStructField nextField = i < fieldList.size() - 1 ? fieldList.get(i + 1) : null;
            long availSpace = nextField != null ? nextField.getOffset() - field.getOffset() : this.typ.getSize() - field.getOffset();
            GoType fieldType = field.getType();
            long fieldSize = fieldType.getBaseType().getSize();
            if (fieldSize == 0L) {
                skippedFields.add(field);
                continue;
            }
            try {
                DataType fieldDT = this.programContext.getRecoveredType(fieldType);
                struct.replaceAtOffset((int)field.getOffset(), fieldDT, (int)fieldSize, field.getName(), null);
                continue;
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)"Failed to add field to go recovered struct: %s".formatted(this.getDebugId()), (Throwable)e);
            }
        }
        for (GoStructField skippedField : skippedFields) {
            DataTypeComponent dtc = struct.getDefinedComponentAtOrAfterOffset((int)skippedField.getOffset());
            GoType skippedFieldType = skippedField.getType();
            if (dtc == null) continue;
            Object comment = dtc.getComment();
            comment = comment == null ? "" : (String)comment + "\n";
            comment = (String)comment + "Omitted zero-len field: %s=%s".formatted(skippedField.getName(), skippedFieldType.getName());
            dtc.setComment((String)comment);
        }
        DWARFUtil.packCompositeIfPossible((Composite)struct, this.programContext.getDTM());
        return struct;
    }

    @Override
    public boolean discoverGoTypes(Set<Long> discoveredTypes) throws IOException {
        if (!super.discoverGoTypes(discoveredTypes)) {
            return false;
        }
        for (GoStructField field : this.getFields()) {
            field.getType().discoverGoTypes(discoveredTypes);
        }
        return true;
    }
}

