/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti.types;

import ghidra.app.util.bin.format.golang.rtti.GoName;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSlice;
import ghidra.app.util.bin.format.golang.rtti.types.GoMethod;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.EOLComment;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.MarkupReference;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.util.Msg;
import java.io.IOException;
import java.util.List;

@StructureMapping(structureName={"runtime.uncommontype", "internal/abi.UncommonType"})
public class GoUncommonType {
    @ContextField
    private GoRttiMapper programContext;
    @ContextField
    private StructureContext<GoUncommonType> context;
    @FieldMapping(fieldName={"pkgpath"})
    @MarkupReference(value="getPkgPath")
    @EOLComment(value="getPackagePathString")
    long pkgpath_nameOff;
    @FieldMapping
    int mcount;
    @FieldMapping
    int xcount;
    @FieldMapping
    long moff;

    @Markup
    public GoName getPkgPath() throws IOException {
        return this.programContext.resolveNameOff(this.context.getStructureStart(), this.pkgpath_nameOff);
    }

    public String getPackagePathString() throws IOException {
        GoName pkgPath = this.getPkgPath();
        return pkgPath != null ? pkgPath.getName() : "";
    }

    public GoSlice getMethodsSlice() {
        return new GoSlice(this.context.getFieldLocation(this.moff), this.mcount, this.mcount, this.programContext);
    }

    public List<GoMethod> getMethods() throws IOException {
        GoSlice slice = this.getMethodsSlice();
        if (!slice.isValid(this.programContext.getStructureMappingInfo(GoMethod.class).getStructureLength())) {
            Msg.warn((Object)this, (Object)"Bad uncommon method list: %s".formatted(this.context.getStructureAddress()));
            return List.of();
        }
        return slice.readList(GoMethod.class);
    }

    public long getEndOfTypeInfo() {
        if (this.mcount == 0) {
            return this.context.getStructureEnd();
        }
        GoSlice slice = this.getMethodsSlice();
        return slice.getArrayEnd(GoMethod.class);
    }
}

