/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.format.golang.structmapping.AfterStructureRead;
import ghidra.app.util.bin.format.golang.structmapping.ContextField;
import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapperContext;
import ghidra.app.util.bin.format.golang.structmapping.FieldContext;
import ghidra.app.util.bin.format.golang.structmapping.FieldMapping;
import ghidra.app.util.bin.format.golang.structmapping.FieldMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutput;
import ghidra.app.util.bin.format.golang.structmapping.FieldOutputInfo;
import ghidra.app.util.bin.format.golang.structmapping.FieldReadFunction;
import ghidra.app.util.bin.format.golang.structmapping.Markup;
import ghidra.app.util.bin.format.golang.structmapping.PlateComment;
import ghidra.app.util.bin.format.golang.structmapping.ReflectionHelper;
import ghidra.app.util.bin.format.golang.structmapping.Signedness;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.app.util.bin.format.golang.structmapping.StructureMarkupFunction;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.InvalidNameException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StructureMappingInfo<T> {
    private final Class<T> targetClass;
    private final ObjectInstanceCreator<T> instanceCreator;
    private final String structureName;
    private final Structure structureDataType;
    private final Map<String, DataTypeComponent> fieldNameLookup;
    private final List<FieldMappingInfo<T>> fields = new ArrayList<FieldMappingInfo<T>>();
    private final List<FieldOutputInfo<T>> outputFields = new ArrayList<FieldOutputInfo<T>>();
    private final List<StructureMarkupFunction<T>> markupFuncs = new ArrayList<StructureMarkupFunction<T>>();
    private final List<Field> contextFields = new ArrayList<Field>();
    private final List<Method> afterMethods;
    private final boolean useFieldMappingInfo;
    private Field structureContextField;

    public static <T> StructureMappingInfo<T> fromClass(Class<T> targetClass, Structure structDataType, DataTypeMapperContext context) {
        StructureMapping sma = targetClass.getAnnotation(StructureMapping.class);
        if (sma == null) {
            throw new IllegalArgumentException("Missing @StructureMapping annotation on " + targetClass.getSimpleName());
        }
        return new StructureMappingInfo<T>(targetClass, structDataType, sma, context);
    }

    private StructureMappingInfo(Class<T> targetClass, Structure structDataType, StructureMapping sma, DataTypeMapperContext context) {
        this.targetClass = targetClass;
        this.structureDataType = structDataType;
        this.structureName = this.structureDataType != null ? this.structureDataType.getName() : sma.structureName()[0];
        this.fieldNameLookup = this.indexStructFields();
        this.useFieldMappingInfo = !StructureReader.class.isAssignableFrom(targetClass);
        this.instanceCreator = this.findInstanceCreator();
        this.readFieldInfo(targetClass, context);
        Collections.sort(this.outputFields, (foi1, foi2) -> Integer.compare(foi1.getOrdinal(), foi2.getOrdinal()));
        this.afterMethods = ReflectionHelper.getMarkedMethods(targetClass, AfterStructureRead.class, null, true, new Class[0]);
        List<Method> markupGetters = ReflectionHelper.getMarkedMethods(targetClass, Markup.class, null, true, new Class[0]);
        for (Method markupGetterMethod : markupGetters) {
            this.markupFuncs.add(this.createMarkupFuncFromGetter(markupGetterMethod));
        }
        for (PlateComment pca : ReflectionHelper.getAnnotations(targetClass, PlateComment.class, null)) {
            this.addPlateCommentMarkupFuncs(pca);
        }
    }

    public String getDescription() {
        return "%s-%s".formatted(this.targetClass.getSimpleName(), this.structureName);
    }

    public Structure getStructureDataType() {
        return this.structureDataType;
    }

    public String getStructureName() {
        return this.structureName;
    }

    public int getStructureLength() {
        if (this.structureDataType == null) {
            throw new IllegalArgumentException();
        }
        return this.structureDataType.getLength();
    }

    public Class<T> getTargetClass() {
        return this.targetClass;
    }

    public ObjectInstanceCreator<T> getInstanceCreator() {
        return this.instanceCreator;
    }

    public List<FieldMappingInfo<T>> getFields() {
        return this.fields;
    }

    public List<Method> getAfterMethods() {
        return this.afterMethods;
    }

    public void readStructure(StructureContext<T> context) throws IOException {
        T newInstance = context.getStructureInstance();
        if (newInstance instanceof StructureReader) {
            StructureReader selfReader = (StructureReader)newInstance;
            selfReader.readStructure();
        } else {
            for (FieldMappingInfo<T> fieldInfo : this.fields) {
                FieldContext<T> fieldReadContext = context.createFieldContext(fieldInfo, true);
                FieldReadFunction<T> readFunc = fieldInfo.getReaderFunc();
                if (readFunc == null) {
                    throw new IOException("Missing read info for field: " + String.valueOf(fieldInfo.getField()));
                }
                Object value = readFunc.get(fieldReadContext);
                fieldInfo.assignField(fieldReadContext, value);
            }
            context.reader.setPointerIndex(context.getStructureEnd());
        }
    }

    public List<StructureMarkupFunction<T>> getMarkupFuncs() {
        return this.markupFuncs;
    }

    public Structure createStructureDataType(StructureContext<T> context) throws IOException {
        StructureDataType newStruct = new StructureDataType(context.getDataTypeMapper().getDefaultVariableLengthStructCategoryPath(), this.structureName, 0, context.getDataTypeMapper().getDTM());
        Object nameSuffix = "";
        for (FieldOutputInfo<T> foi : this.outputFields) {
            long structSizeBefore = StructureMappingInfo.getStructLength((Structure)newStruct);
            foi.getOutputFunc().addFieldToStructure(context, (Structure)newStruct, foi);
            long sizeDelta = (long)StructureMappingInfo.getStructLength((Structure)newStruct) - structSizeBefore;
            if (!foi.isVariableLength()) continue;
            nameSuffix = (String)nameSuffix + "_%d".formatted(sizeDelta);
        }
        if (!((String)nameSuffix).isEmpty()) {
            try {
                newStruct.setName(this.structureName + (String)nameSuffix);
            }
            catch (InvalidNameException | DuplicateNameException e) {
                throw new IOException(e);
            }
        }
        return newStruct;
    }

    public StructureContext<T> recoverStructureContext(T structureInstance) {
        try {
            if (this.structureContextField != null) {
                return ReflectionHelper.getFieldValue(structureInstance, this.structureContextField, StructureContext.class);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void assignContextFieldValues(StructureContext<T> context) throws IOException {
        Class<?> dataTypeMapperType = context.getDataTypeMapper().getClass();
        Class<?> structureContextType = context.getClass();
        T obj = context.getStructureInstance();
        for (Field f : this.contextFields) {
            Class<?> fieldType = f.getType();
            if (fieldType.isAssignableFrom(dataTypeMapperType)) {
                ReflectionHelper.assignField(f, obj, context.getDataTypeMapper());
                continue;
            }
            if (fieldType.isAssignableFrom(structureContextType)) {
                ReflectionHelper.assignField(f, obj, context);
                continue;
            }
            throw new IOException("Unsupported context field: " + String.valueOf(f));
        }
    }

    private void readFieldInfo(Class<?> clazz, DataTypeMapperContext context) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.readFieldInfo(superclass, context);
        }
        for (Field field : clazz.getDeclaredFields()) {
            FieldMapping fma = field.getAnnotation(FieldMapping.class);
            FieldOutput foa = field.getAnnotation(FieldOutput.class);
            if (fma != null || foa != null) {
                FieldMappingInfo<T> fmi = this.readFieldMappingInfo(field, fma, context);
                if (fmi == null) continue;
                field.setAccessible(true);
                this.fields.add(fmi);
                if (foa == null) continue;
                FieldOutputInfo<T> foi = this.readFieldOutputInfo(fmi, foa);
                field.setAccessible(true);
                this.outputFields.add(foi);
                continue;
            }
            ContextField cfa = field.getAnnotation(ContextField.class);
            if (cfa == null) continue;
            field.setAccessible(true);
            this.contextFields.add(field);
            if (!StructureContext.class.isAssignableFrom(field.getType())) continue;
            this.structureContextField = field;
        }
    }

    private FieldMappingInfo<T> readFieldMappingInfo(Field field, FieldMapping fma, DataTypeMapperContext context) {
        if (fma != null && !context.isFieldPresent(fma.presentWhen())) {
            return null;
        }
        Object[] fieldNames = this.getFieldNamesToSearchFor(field, fma);
        DataTypeComponent dtc = this.getFirstMatchingField((String[])fieldNames);
        if (this.useFieldMappingInfo && dtc == null) {
            if (fma.optional()) {
                return null;
            }
            throw new IllegalArgumentException("Missing structure field: %s.%s for %s.%s".formatted(this.structureName, Arrays.toString(fieldNames), this.targetClass.getSimpleName(), field.getName()));
        }
        Signedness signedness = fma != null ? fma.signedness() : Signedness.Unspecified;
        int length = fma != null ? fma.length() : -1;
        FieldMappingInfo fmi = this.useFieldMappingInfo ? FieldMappingInfo.createEarlyBinding(field, dtc, signedness, length) : FieldMappingInfo.createLateBinding(field, fieldNames[0], signedness, length);
        Class<FieldReadFunction> fieldReadFuncClass = fma != null ? fma.readFunc() : FieldReadFunction.class;
        String setterNameOverride = fma != null ? fma.setter() : null;
        fmi.setFieldValueDeserializationInfo(fieldReadFuncClass, this.targetClass, setterNameOverride);
        fmi.addMarkupNestedFuncs();
        fmi.addCommentMarkupFuncs();
        fmi.addMarkupReferenceFunc();
        return fmi;
    }

    private String[] getFieldNamesToSearchFor(Field field, FieldMapping fma) {
        String[] stringArray;
        String[] fmaFieldNames;
        String[] stringArray2 = fmaFieldNames = fma != null ? fma.fieldName() : null;
        if (fmaFieldNames != null && fmaFieldNames.length != 0 && !fmaFieldNames[0].isBlank()) {
            stringArray = fmaFieldNames;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = field.getName();
        }
        return stringArray;
    }

    private DataTypeComponent getFirstMatchingField(String[] fieldNames) {
        for (String fieldName : fieldNames) {
            DataTypeComponent dtc = this.fieldNameLookup.get(fieldName.toLowerCase());
            if (dtc == null) continue;
            return dtc;
        }
        return null;
    }

    private FieldOutputInfo<T> readFieldOutputInfo(FieldMappingInfo<T> fmi, FieldOutput foa) {
        FieldOutputInfo<T> foi = new FieldOutputInfo<T>(fmi, foa.dataTypeName(), foa.isVariableLength(), foa.ordinal(), foa.offset());
        foi.setOutputFuncClass(foa.fieldOutputFunc(), foa.getter());
        return foi;
    }

    private ObjectInstanceCreator<T> findInstanceCreator() {
        Constructor ctor1 = ReflectionHelper.getCtor(this.targetClass, StructureContext.class);
        if (ctor1 != null) {
            return context -> ReflectionHelper.callCtor(ctor1, context);
        }
        Constructor ctor2 = ReflectionHelper.getCtor(this.targetClass, new Class[0]);
        if (ctor2 != null) {
            return context -> ReflectionHelper.callCtor(ctor2, new Object[0]);
        }
        throw new IllegalArgumentException("Bad instance creator for " + this.targetClass.getSimpleName());
    }

    private void addPlateCommentMarkupFuncs(PlateComment pca) {
        Method commentGetter = ReflectionHelper.getCommentMethod(this.targetClass, pca.value(), "toString");
        this.markupFuncs.add((context, session) -> {
            Object obj = context.getStructureInstance();
            Object val = ReflectionHelper.callGetter(commentGetter, obj);
            if (val != null) {
                session.appendComment(context, 3, null, val.toString(), "\n");
            }
        });
    }

    private StructureMarkupFunction<T> createMarkupFuncFromGetter(Method markupGetterMethod) {
        return (context, session) -> {
            Object obj = context.getStructureInstance();
            Object val = ReflectionHelper.callGetter(markupGetterMethod, obj);
            session.markup(val, false);
        };
    }

    private static int getStructLength(Structure struct) {
        return struct.isZeroLength() ? 0 : struct.getLength();
    }

    private Map<String, DataTypeComponent> indexStructFields() {
        if (this.structureDataType == null) {
            return Map.of();
        }
        HashMap<String, DataTypeComponent> result = new HashMap<String, DataTypeComponent>();
        for (DataTypeComponent dtc : this.structureDataType.getDefinedComponents()) {
            String fieldName = dtc.getFieldName();
            if (fieldName == null) continue;
            result.put(fieldName.toLowerCase(), dtc);
        }
        return result;
    }

    static interface ObjectInstanceCreator<T> {
        public T get(StructureContext<T> var1) throws IOException;
    }

    static interface ReadFromStructureFunction<T> {
        public T readStructure(StructureContext<T> var1) throws IOException;
    }
}

