/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixupHeader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedFixups;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInImage;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedStartsInSegment;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DyldChainedFixupsCommand
extends LinkEditDataCommand {
    private DyldChainedFixupHeader chainHeader;

    DyldChainedFixupsCommand(BinaryReader loadCommandReader, BinaryReader dataReader) throws IOException {
        super(loadCommandReader, dataReader);
        this.chainHeader = new DyldChainedFixupHeader(dataReader);
    }

    public DyldChainedFixupHeader getChainHeader() {
        return this.chainHeader;
    }

    @Override
    public String getCommandName() {
        return "dyld_chained_fixups_command";
    }

    @Override
    public void markup(Program program, MachHeader header, String source, TaskMonitor monitor, MessageLog log) throws CancelledException {
        Address addr = this.fileOffsetToAddress(program, header, this.dataoff, this.datasize);
        if (addr == null) {
            return;
        }
        super.markup(program, header, source, monitor, log);
        try {
            DataUtilities.createData((Program)program, (Address)addr, (DataType)this.chainHeader.toDataType(), (int)-1, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
            this.chainHeader.markup(program, addr, header, monitor, log);
        }
        catch (Exception e) {
            log.appendMsg(DyldChainedFixupsCommand.class.getSimpleName(), "Failed to markup: " + this.getContextualName(source, null));
        }
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            List addrs = api.getCurrentProgram().getMemory().locateAddressesForFileOffset((long)this.getLinkerDataOffset());
            if (addrs.size() <= 0) {
                throw new Exception("Chain Header does not exist in program");
            }
            Address dyldChainedHeader = (Address)addrs.get(0);
            DataType cHeader = this.chainHeader.toDataType();
            api.createData(dyldChainedHeader, cHeader);
            Address segsAddr = dyldChainedHeader.add((long)this.chainHeader.getStartsOffset());
            DyldChainedStartsInImage chainedStartsInImage = this.chainHeader.getChainedStartsInImage();
            int[] segInfoOffset = chainedStartsInImage.getSegInfoOffset();
            List<DyldChainedStartsInSegment> chainedStarts = chainedStartsInImage.getChainedStarts();
            for (int i = 0; i < chainedStarts.size(); ++i) {
                DyldChainedStartsInSegment startsInSeg = chainedStarts.get(i);
                DataType dataType = startsInSeg.toDataType();
                api.createData(segsAddr.add((long)segInfoOffset[i]), dataType);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
            log.appendException((Throwable)e);
        }
    }

    public List<DyldFixup> getChainedFixups(BinaryReader reader, long imagebase, SymbolTable symbolTable, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> result = new ArrayList<DyldFixup>();
        HashMap<DyldChainedPtr.DyldChainType, Integer> countMap = new HashMap<DyldChainedPtr.DyldChainType, Integer>();
        for (DyldChainedStartsInSegment chainStart : this.chainHeader.getChainedStartsInImage().getChainedStarts()) {
            if (chainStart == null) continue;
            DyldChainedPtr.DyldChainType ptrFormat = DyldChainedPtr.DyldChainType.lookupChainPtr(chainStart.getPointerFormat());
            monitor.initialize((long)chainStart.getPageCount(), "Getting " + ptrFormat.getName() + " chained pointer fixups...");
            try {
                for (int index = 0; index < chainStart.getPageCount(); ++index) {
                    monitor.increment();
                    long page = chainStart.getSegmentOffset() + (long)(chainStart.getPageSize() * index);
                    int pageEntry = chainStart.getPageStarts()[index] & 0xFFFF;
                    if (pageEntry == 65535) continue;
                    List<DyldFixup> fixups = DyldChainedFixups.getChainedFixups(reader, this.chainHeader.getChainedImports(), ptrFormat, page, pageEntry, 0L, imagebase, symbolTable, log, monitor);
                    result.addAll(fixups);
                    countMap.put(ptrFormat, countMap.getOrDefault((Object)ptrFormat, 0) + fixups.size());
                }
            }
            catch (IOException e) {
                log.appendMsg("Failed to get segment chain fixups at 0x%x".formatted(chainStart.getSegmentOffset()));
            }
        }
        countMap.forEach((type, count) -> log.appendMsg("Discovered " + count + " " + String.valueOf(type) + " chained pointers."));
        return result;
    }
}

