/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachException;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.BuildVersionCommand;
import ghidra.app.util.bin.format.macho.commands.CodeSignatureCommand;
import ghidra.app.util.bin.format.macho.commands.CorruptLoadCommand;
import ghidra.app.util.bin.format.macho.commands.DataInCodeCommand;
import ghidra.app.util.bin.format.macho.commands.DyldChainedFixupsCommand;
import ghidra.app.util.bin.format.macho.commands.DyldExportsTrieCommand;
import ghidra.app.util.bin.format.macho.commands.DyldInfoCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicLinkerCommand;
import ghidra.app.util.bin.format.macho.commands.DynamicSymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.EncryptedInformationCommand;
import ghidra.app.util.bin.format.macho.commands.EntryPointCommand;
import ghidra.app.util.bin.format.macho.commands.FileSetEntryCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemoryFileCommand;
import ghidra.app.util.bin.format.macho.commands.FixedVirtualMemorySharedLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.FunctionStartsCommand;
import ghidra.app.util.bin.format.macho.commands.IdentCommand;
import ghidra.app.util.bin.format.macho.commands.LinkEditDataCommand;
import ghidra.app.util.bin.format.macho.commands.LinkerOptionCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.PrebindChecksumCommand;
import ghidra.app.util.bin.format.macho.commands.PreboundDynamicLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.RoutinesCommand;
import ghidra.app.util.bin.format.macho.commands.RunPathCommand;
import ghidra.app.util.bin.format.macho.commands.SegmentCommand;
import ghidra.app.util.bin.format.macho.commands.SourceVersionCommand;
import ghidra.app.util.bin.format.macho.commands.SubClientCommand;
import ghidra.app.util.bin.format.macho.commands.SubFrameworkCommand;
import ghidra.app.util.bin.format.macho.commands.SubLibraryCommand;
import ghidra.app.util.bin.format.macho.commands.SubUmbrellaCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolCommand;
import ghidra.app.util.bin.format.macho.commands.SymbolTableCommand;
import ghidra.app.util.bin.format.macho.commands.TwoLevelHintsCommand;
import ghidra.app.util.bin.format.macho.commands.UnsupportedLoadCommand;
import ghidra.app.util.bin.format.macho.commands.UuidCommand;
import ghidra.app.util.bin.format.macho.commands.VersionMinCommand;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheMappingInfo;
import ghidra.app.util.bin.format.macho.threadcommand.ThreadCommand;
import ghidra.app.util.opinion.DyldCacheUtils;
import java.io.IOException;

public class LoadCommandFactory {
    public static LoadCommand getLoadCommand(BinaryReader reader, MachHeader header, DyldCacheUtils.SplitDyldCache splitDyldCache) throws IOException, MachException {
        long origIndex = reader.getPointerIndex();
        int type = reader.peekNextInt();
        try {
            return switch (type) {
                case 1 -> new SegmentCommand(reader, header.is32bit());
                case 2 -> new SymbolTableCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
                case 3 -> new SymbolCommand(reader);
                case 4, 5 -> new ThreadCommand(reader, header);
                case 6, 7 -> new FixedVirtualMemorySharedLibraryCommand(reader);
                case 8 -> new IdentCommand(reader);
                case 9 -> new FixedVirtualMemoryFileCommand(reader);
                case 10 -> new UnsupportedLoadCommand(reader);
                case 11 -> new DynamicSymbolTableCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
                case -2147483613, 12, 13 -> new DynamicLibraryCommand(reader);
                case 14, 15, 39 -> new DynamicLinkerCommand(reader);
                case 16 -> new PreboundDynamicLibraryCommand(reader);
                case 17 -> new RoutinesCommand(reader, header.is32bit());
                case 18 -> new SubFrameworkCommand(reader);
                case 19 -> new SubUmbrellaCommand(reader);
                case 20 -> new SubClientCommand(reader);
                case 21 -> new SubLibraryCommand(reader);
                case 22 -> new TwoLevelHintsCommand(reader);
                case 23 -> new PrebindChecksumCommand(reader);
                case -2147483624 -> new DynamicLibraryCommand(reader);
                case 25 -> new SegmentCommand(reader, header.is32bit());
                case 26 -> new RoutinesCommand(reader, header.is32bit());
                case 27 -> new UuidCommand(reader);
                case -2147483620 -> new RunPathCommand(reader);
                case 29 -> new CodeSignatureCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case 30, 43, 46 -> new LinkEditDataCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case -2147483617 -> new DynamicLibraryCommand(reader);
                case 33, 44 -> new EncryptedInformationCommand(reader, header.is32bit());
                case -2147483614, 34 -> new DyldInfoCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache), header);
                case 36, 37, 47, 48 -> new VersionMinCommand(reader);
                case 38 -> new FunctionStartsCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case -2147483608 -> new EntryPointCommand(reader);
                case 41 -> new DataInCodeCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case 42 -> new SourceVersionCommand(reader);
                case 32 -> new DynamicLibraryCommand(reader);
                case 45 -> new LinkerOptionCommand(reader);
                case 50 -> new BuildVersionCommand(reader);
                case -2147483597 -> new DyldExportsTrieCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case -2147483596 -> new DyldChainedFixupsCommand(reader, LoadCommandFactory.getLinkerLoadCommandReader(reader, header, splitDyldCache));
                case -2147483595 -> new FileSetEntryCommand(reader);
                default -> new UnsupportedLoadCommand(reader);
            };
        }
        catch (Exception e) {
            reader.setPointerIndex(origIndex);
            return new CorruptLoadCommand(reader, e);
        }
    }

    private static BinaryReader getLinkerLoadCommandReader(BinaryReader reader, MachHeader header, DyldCacheUtils.SplitDyldCache splitDyldCache) throws MachException {
        if (splitDyldCache == null) {
            return reader.clone();
        }
        SegmentCommand linkEdit = header.getSegment("__LINKEDIT");
        if (linkEdit != null) {
            for (int i = 0; i < splitDyldCache.size(); ++i) {
                DyldCacheHeader dyldCacheHeader = splitDyldCache.getDyldCacheHeader(i);
                for (DyldCacheMappingInfo mappingInfo : dyldCacheHeader.getMappingInfos()) {
                    if (!mappingInfo.contains(linkEdit.getVMaddress())) continue;
                    return new BinaryReader(splitDyldCache.getProvider(i), true);
                }
            }
        }
        throw new MachException("__LINKEDIT segment not found in DYLD cache");
    }
}

