/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands.chained;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImport;
import ghidra.app.util.bin.format.macho.commands.chained.DyldChainedImports;
import ghidra.app.util.bin.format.macho.dyld.DyldChainedPtr;
import ghidra.app.util.bin.format.macho.dyld.DyldFixup;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.MachoProgramBuilder;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DyldChainedFixups {
    public static List<DyldFixup> getChainedFixups(BinaryReader reader, DyldChainedImports chainedImports, DyldChainedPtr.DyldChainType pointerFormat, long page, long nextOff, long auth_value_add, long imagebase, SymbolTable symbolTable, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        long next = -1L;
        while (next != 0L) {
            long chainValue;
            monitor.checkCancelled();
            long chainLoc = page + nextOff;
            long newChainValue = chainValue = DyldChainedPtr.getChainValue(reader, chainLoc, pointerFormat);
            boolean isAuthenticated = DyldChainedPtr.isAuthenticated(pointerFormat, chainValue);
            boolean isBound = DyldChainedPtr.isBound(pointerFormat, chainValue);
            Symbol symbol = null;
            Integer libOrdinal = null;
            if (isBound) {
                if (chainedImports == null) {
                    log.appendMsg("Error: dyld_chained_import array required to process bound chain fixup at " + chainLoc);
                    return List.of();
                }
                if (symbolTable == null) {
                    log.appendMsg("Error: symbol table required to process bound chain fixup at " + chainLoc);
                    return List.of();
                }
                int chainOrdinal = (int)DyldChainedPtr.getOrdinal(pointerFormat, chainValue);
                long addend = DyldChainedPtr.getAddend(pointerFormat, chainValue);
                DyldChainedImport chainedImport = chainedImports.getChainedImport(chainOrdinal);
                List globalSymbols = symbolTable.getGlobalSymbols(chainedImport.getName());
                if (globalSymbols.size() > 0) {
                    symbol = (Symbol)globalSymbols.get(0);
                    newChainValue = symbol.getAddress().getOffset();
                    libOrdinal = chainedImport.getLibOrdinal();
                }
                newChainValue += isAuthenticated ? auth_value_add : addend;
            } else if (isAuthenticated) {
                newChainValue = imagebase + DyldChainedPtr.getTarget(pointerFormat, chainValue) + auth_value_add;
            } else {
                newChainValue = DyldChainedPtr.getTarget(pointerFormat, chainValue);
                if (DyldChainedPtr.isRelative(pointerFormat)) {
                    newChainValue += imagebase;
                }
            }
            fixups.add(new DyldFixup(chainLoc, newChainValue, DyldChainedPtr.getSize(pointerFormat), symbol, libOrdinal));
            next = DyldChainedPtr.getNext(pointerFormat, chainValue);
            nextOff += next * DyldChainedPtr.getStride(pointerFormat);
        }
        return fixups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Address> fixupChainedPointers(List<DyldFixup> fixups, Program program, Address imagebase, List<String> libraryPaths, MessageLog log, TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        ArrayList<Address> fixedAddrs = new ArrayList<Address>();
        if (fixups.isEmpty()) {
            return fixedAddrs;
        }
        Memory memory = program.getMemory();
        for (DyldFixup fixup : fixups) {
            Address addr;
            Relocation.Status status;
            block9: {
                monitor.checkCancelled();
                status = Relocation.Status.FAILURE;
                addr = imagebase.add(fixup.offset());
                try {
                    if (fixup.size() == 8 || fixup.size() == 4) {
                        if (fixup.size() == 8) {
                            memory.setLong(addr, fixup.value());
                        } else {
                            memory.setInt(addr, (int)fixup.value());
                        }
                        fixedAddrs.add(addr);
                        status = Relocation.Status.APPLIED_OTHER;
                        break block9;
                    }
                    status = Relocation.Status.UNSUPPORTED;
                }
                catch (Throwable throwable) {
                    program.getRelocationTable().add(addr, status, 0, new long[]{fixup.value()}, fixup.size(), fixup.symbol() != null ? fixup.symbol().getName() : null);
                    throw throwable;
                }
            }
            program.getRelocationTable().add(addr, status, 0, new long[]{fixup.value()}, fixup.size(), fixup.symbol() != null ? fixup.symbol().getName() : null);
            if (fixup.symbol() == null || fixup.libOrdinal() == null) continue;
            try {
                MachoProgramBuilder.fixupExternalLibrary(program, libraryPaths, fixup.libOrdinal(), fixup.symbol());
            }
            catch (Exception e) {
                log.appendMsg("WARNING: Problem fixing up symbol '%s' - %s".formatted(fixup.symbol().getName(), e.getMessage()));
            }
        }
        log.appendMsg("Fixed up " + fixedAddrs.size() + " chained pointers.");
        return fixedAddrs;
    }

    public static List<DyldFixup> processPointerChain(BinaryReader reader, long chainStart, long nextOffSize, long imagebase, MessageLog log, TaskMonitor monitor) throws IOException, CancelledException {
        long BIT63 = Long.MIN_VALUE;
        long BIT62 = 0x4000000000000000L;
        ArrayList<DyldFixup> fixups = new ArrayList<DyldFixup>();
        while (true) {
            monitor.checkCancelled();
            long chainValue = reader.readLong(chainStart);
            long fixedPointerValue = 0L;
            if ((chainValue & 0x4000000000000000L) != 0L) {
                // empty if block
            }
            if ((chainValue & Long.MIN_VALUE) != 0L) {
                fixedPointerValue = imagebase + (chainValue & 0xFFFFFFFFL);
            } else {
                fixedPointerValue = chainValue << 13 & 0xFF00000000000000L | chainValue & 0x7FFFFFFFFFFL;
                if ((chainValue & 0x40000000000L) != 0L) {
                    fixedPointerValue |= 0xFFFC0000000000L;
                }
            }
            fixups.add(new DyldFixup(chainStart, fixedPointerValue, 8, null, null));
            long nextValueOff = (chainValue >> 51 & 0x7FFL) * nextOffSize;
            if (nextValueOff == 0L) break;
            chainStart += nextValueOff;
        }
        return fixups;
    }
}

